/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.tokenizer;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public abstract class EscapeSequenceTokenizer<T extends PsiElement>
extends Tokenizer<T> {
    private static final Key<int[]> ESCAPE_OFFSETS = Key.create((String)"escape.tokenizer.offsets");

    public static void processTextWithOffsets(PsiElement element, TokenConsumer consumer2, StringBuilder unescapedText, int[] offsets, int startOffset) {
        if (element != null) {
            element.putUserData(ESCAPE_OFFSETS, (Object)offsets);
        }
        String text2 = unescapedText.toString();
        consumer2.consumeToken(element, text2, false, startOffset, TextRange.allOf((String)text2), PlainTextSplitter.getInstance());
        if (element != null) {
            element.putUserData(ESCAPE_OFFSETS, null);
        }
    }

    @Override
    @NotNull
    public TextRange getHighlightingRange(PsiElement element, int offset, TextRange range) {
        int[] offsets = (int[])element.getUserData(ESCAPE_OFFSETS);
        if (offsets != null) {
            int start2 = offsets[range.getStartOffset()];
            int end = offsets[range.getEndOffset()];
            return new TextRange(offset + start2, offset + end);
        }
        TextRange textRange = super.getHighlightingRange(element, offset, range);
        if (textRange == null) {
            EscapeSequenceTokenizer.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/tokenizer/EscapeSequenceTokenizer", "getHighlightingRange"));
    }
}

