/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.SpellCheckerManagerKt;
import com.intellij.spellchecker.engine.SpellCheckerEngine;
import com.intellij.spellchecker.settings.SpellCheckerSettings;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/spellchecker/CustomDictFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "manager", "Lcom/intellij/spellchecker/SpellCheckerManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/spellchecker/SpellCheckerManager;)V", "contentsChanged", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "fileCreated", "fileDeleted", "fileMoved", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "loadCustomDictionaries", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "removeCustomDictionaries", "path", "", "intellij.spellchecker"})
final class CustomDictFileListener
implements VirtualFileListener {
    @NotNull
    private final Project project;
    @NotNull
    private final SpellCheckerManager manager;

    public CustomDictFileListener(@NotNull Project project2, @NotNull SpellCheckerManager manager) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.project = project2;
        this.manager = manager;
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string2 = event.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        this.removeCustomDictionaries(string2);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.loadCustomDictionaries(virtualFile);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String oldPath = event.getOldParent().getPath() + File.separator + event.getFileName();
        if (!SpellCheckerManagerKt.access$affectCustomDictionaries(oldPath, this.project)) {
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            this.loadCustomDictionaries(virtualFile);
        } else {
            String newPath = event.getNewParent().getPath() + File.separator + event.getFileName();
            if (!SpellCheckerManagerKt.access$affectCustomDictionaries(newPath, this.project)) {
                this.removeCustomDictionaries(oldPath);
            }
        }
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string2 = FileUtilRt.toSystemDependentName((String)event.getFile().getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        String path2 = string2;
        SpellCheckerEngine spellCheckerEngine = this.manager.getSpellChecker();
        Intrinsics.checkNotNull((Object)spellCheckerEngine);
        if (!spellCheckerEngine.isDictionaryLoad(path2)) {
            return;
        }
        SpellCheckerEngine spellCheckerEngine2 = this.manager.getSpellChecker();
        Intrinsics.checkNotNull((Object)spellCheckerEngine2);
        spellCheckerEngine2.removeDictionary(path2);
        this.manager.loadDictionary$intellij_spellchecker(path2);
        SpellCheckerManager.Companion.restartInspections();
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        if (file.isDirectory()) {
            return;
        }
        if (Intrinsics.areEqual((Object)"name", (Object)event.getPropertyName())) {
            Object object = event.getOldValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String oldName = (String)object;
            if (!SpellCheckerManagerKt.access$isDic(oldName)) {
                this.loadCustomDictionaries(file);
            } else {
                Object object2 = event.getNewValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
                String newName = (String)object2;
                if (!SpellCheckerManagerKt.access$isDic(newName)) {
                    this.removeCustomDictionaries(file.getParent().getPath() + File.separator + oldName);
                }
            }
        }
    }

    private final void removeCustomDictionaries(String path2) {
        String string2 = FileUtilRt.toSystemDependentName((String)path2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        String systemDependentPath = string2;
        if (SpellCheckerManagerKt.access$affectCustomDictionaries(path2, this.project)) {
            SpellCheckerEngine spellCheckerEngine = this.manager.getSpellChecker();
            Intrinsics.checkNotNull((Object)spellCheckerEngine);
            spellCheckerEngine.removeDictionariesRecursively(systemDependentPath);
            SpellCheckerSettings.getInstance(this.project).getCustomDictionariesPaths().removeIf(arg_0 -> CustomDictFileListener.removeCustomDictionaries$lambda$0((Function1)new Function1<String, Boolean>(systemDependentPath){
                final /* synthetic */ String $systemDependentPath;
                {
                    this.$systemDependentPath = $systemDependentPath;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@Nullable String dict) {
                    String string2 = dict;
                    Intrinsics.checkNotNull((Object)string2);
                    return FileUtil.isAncestor((String)this.$systemDependentPath, (String)string2, (boolean)false);
                }
            }, arg_0));
            SpellCheckerManager.Companion.restartInspections();
        }
    }

    private final void loadCustomDictionaries(VirtualFile file) {
        String string2 = FileUtilRt.toSystemDependentName((String)file.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        String path2 = string2;
        if (!SpellCheckerManagerKt.access$affectCustomDictionaries(path2, this.project)) {
            return;
        }
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>(this, optionArray){
            final /* synthetic */ CustomDictFileListener this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean visitFile(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                boolean isDirectory = file.isDirectory();
                String string2 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                String filePath = string2;
                if (!isDirectory && SpellCheckerSettings.getInstance(CustomDictFileListener.access$getProject$p(this.this$0)).getCustomDictionariesPaths().contains(filePath)) {
                    CustomDictFileListener.access$getManager$p(this.this$0).loadDictionary$intellij_spellchecker(filePath);
                    SpellCheckerManager.Companion.restartInspections();
                }
                return isDirectory;
            }
        }));
    }

    private static final boolean removeCustomDictionaries$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(CustomDictFileListener $this) {
        return $this.project;
    }

    public static final /* synthetic */ SpellCheckerManager access$getManager$p(CustomDictFileListener $this) {
        return $this.manager;
    }
}

