/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.HorizontalScrollBarEditorCustomization;
import com.intellij.ui.OneLineEditorCustomization;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 62\u00020\u0001:\u000267B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013J\u0010\u0010.\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0012\u0010/\u001a\u00020,2\b\u00100\u001a\u0004\u0018\u00010\u0013H\u0016J\u0017\u00101\u001a\u00020,2\r\u00102\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b3H$J\u0012\u00104\u001a\u00020,2\b\u00100\u001a\u0004\u0018\u00010\u0013H\u0014J\b\u00105\u001a\u00020,H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f*\u0004\b\n\u0010\u000bR\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u0010\u0010\u001c\u001a\u00020\u001d8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00068"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel;", "Lcom/intellij/ui/components/panels/Wrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "additionalControlsPanel", "Ljavax/swing/JPanel;", "<set-?>", "", "changeListName", "getChangeListName$delegate", "(Lcom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel;)Ljava/lang/Object;", "getChangeListName", "()Ljava/lang/String;", "setChangeListName", "(Ljava/lang/String;)V", "consumers", "", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "content", "Ljavax/swing/JComponent;", "getContent", "()Ljavax/swing/JComponent;", "s", "description", "getDescription", "setDescription", "descriptionTextArea", "Lcom/intellij/ui/EditorTextField;", "makeActiveCheckBox", "Ljavax/swing/JCheckBox;", "getMakeActiveCheckBox", "()Ljavax/swing/JCheckBox;", "nameComponent", "Lcom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel$ComponentWithTextFieldWrapper;", "nameTextField", "preferredFocusedComponent", "getPreferredFocusedComponent", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildMainPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "changelistCreatedOrChanged", "", "list", "createComponentWithTextField", "init", "initial", "nameChanged", "errorMessage", "Lorg/jetbrains/annotations/Nls;", "nameChangedImpl", "requestFocus", "Companion", "ComponentWithTextFieldWrapper", "intellij.platform.vcs.impl"})
public abstract class NewEditChangelistPanel
extends Wrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorTextField nameTextField;
    @NotNull
    private final ComponentWithTextFieldWrapper nameComponent;
    @JvmField
    @NotNull
    protected final EditorTextField descriptionTextArea;
    @NotNull
    private final JPanel additionalControlsPanel;
    @NotNull
    private final JCheckBox makeActiveCheckBox;
    @NotNull
    private final List<Consumer<LocalChangeList>> consumers;

    public NewEditChangelistPanel(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.additionalControlsPanel = new JPanel(null);
        this.consumers = new ArrayList();
        this.nameComponent = this.createComponentWithTextField(this.project);
        this.nameTextField = this.nameComponent.getEditorTextField();
        this.nameTextField.setOneLineMode(true);
        String string2 = VcsBundle.message("changes.new.changelist", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String generateUniqueName = ChangeListUtil.createNameForChangeList(this.project, string2);
        this.nameTextField.setText(generateUniqueName);
        this.nameTextField.selectAll();
        this.descriptionTextArea = NewEditChangelistPanel.Companion.createEditorField(this.project, 4);
        this.descriptionTextArea.setOneLineMode(false);
        this.makeActiveCheckBox = new JCheckBox(VcsBundle.message("new.changelist.make.active.checkbox", new Object[0]));
        this.additionalControlsPanel.add(this.makeActiveCheckBox);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JCheckBox getMakeActiveCheckBox() {
        return this.makeActiveCheckBox;
    }

    public void init(@Nullable LocalChangeList initial) {
        this.makeActiveCheckBox.setSelected(VcsConfiguration.getInstance((Project)this.project).MAKE_NEW_CHANGELIST_ACTIVE);
        for (EditChangelistSupport support : EditChangelistSupport.EP_NAME.getExtensionList((AreaInstance)this.project)) {
            support.installSearch(this.nameTextField, this.descriptionTextArea);
            ContainerUtil.addIfNotNull((Collection)this.consumers, support.addControls(this.additionalControlsPanel, initial));
        }
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(this, initial){
            final /* synthetic */ NewEditChangelistPanel this$0;
            final /* synthetic */ LocalChangeList $initial;
            {
                this.this$0 = $receiver;
                this.$initial = $initial;
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.nameChangedImpl(this.$initial);
            }
        });
        this.nameChangedImpl(initial);
        this.setContent((JComponent)this.buildMainPanel());
        this.validate();
        this.repaint();
    }

    private final DialogPanel buildMainPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ NewEditChangelistPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                int gap = 3;
                String string2 = VcsBundle.message("edit.changelist.name", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0, gap){
                    final /* synthetic */ NewEditChangelistPanel this$0;
                    final /* synthetic */ int $gap;
                    {
                        this.this$0 = $receiver;
                        this.$gap = $gap;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell(NewEditChangelistPanel.access$getNameComponent$p(this.this$0).getMyComponent()).resizableColumn().align((Align)AlignX.FILL.INSTANCE).applyToComponent((Function1)new Function1<JComponent, Unit>(this.$gap){
                            final /* synthetic */ int $gap;
                            {
                                this.$gap = $gap;
                                super(1);
                            }

                            public final void invoke(@NotNull JComponent $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                $this$applyToComponent.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGapsKt.UnscaledGaps((int)this.$gap));
                            }
                        });
                    }
                }).bottomGap(BottomGap.SMALL);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, gap){
                    final /* synthetic */ NewEditChangelistPanel this$0;
                    final /* synthetic */ int $gap;
                    {
                        this.this$0 = $receiver;
                        this.$gap = $gap;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string2 = VcsBundle.message("edit.changelist.description", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        $this$row.label(string2).align((Align)AlignY.TOP.INSTANCE).gap(RightGap.SMALL);
                        $this$row.cell((JComponent)this.this$0.descriptionTextArea).resizableColumn().align(Align.FILL).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)this.$gap, (int)0, (int)this.$gap, (int)5, null));
                    }
                }), (int)1, null).resizableRow().layout(RowLayout.PARENT_GRID).bottomGap(BottomGap.SMALL);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ NewEditChangelistPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Component[] componentArray = NewEditChangelistPanel.access$getAdditionalControlsPanel$p(this.this$0).getComponents();
                        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                        Object[] $this$forEach$iv = componentArray;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Component it = (Component)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                            $this$row.cell((JComponent)it);
                        }
                    }
                }), (int)1, null);
            }
        }));
    }

    protected void nameChangedImpl(@Nullable LocalChangeList initial) {
        String name = this.getChangeListName();
        if (StringsKt.isBlank((CharSequence)name)) {
            this.nameChanged(VcsBundle.message("new.changelist.empty.name.error", new Object[0]));
        } else if (!(initial != null && Intrinsics.areEqual((Object)name, (Object)initial.getName()) || ChangeListManager.getInstance(this.project).findChangeList(name) == null)) {
            this.nameChanged(VcsBundle.message("new.changelist.duplicate.name.error", new Object[0]));
        } else {
            this.nameChanged(null);
        }
    }

    public final void changelistCreatedOrChanged(@NotNull LocalChangeList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        for (Consumer<LocalChangeList> consumer2 : this.consumers) {
            consumer2.consume((Object)list2);
        }
    }

    @NotNull
    public final String getChangeListName() {
        return this.nameTextField.getText();
    }

    public final void setChangeListName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.nameTextField.setText(string2);
    }

    private static Object getChangeListName$delegate(NewEditChangelistPanel newEditChangelistPanel) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)newEditChangelistPanel.nameTextField, EditorTextField.class, "text", "getText()Ljava/lang/String;", 2)));
    }

    @Nullable
    public final String getDescription() {
        return this.descriptionTextArea.getText();
    }

    public final void setDescription(@Nullable String s) {
        this.descriptionTextArea.setText(s);
    }

    @NotNull
    public final JComponent getContent() {
        return (JComponent)((Object)this);
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> NewEditChangelistPanel.requestFocus$lambda$0(this));
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        return (JComponent)this.nameTextField;
    }

    protected abstract void nameChanged(@Nullable String var1);

    @NotNull
    protected ComponentWithTextFieldWrapper createComponentWithTextField(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        EditorTextField editorTextField = NewEditChangelistPanel.Companion.createEditorField(project2, 1);
        return new ComponentWithTextFieldWrapper(editorTextField){
            final /* synthetic */ EditorTextField $editorTextField;
            {
                this.$editorTextField = $editorTextField;
                super((JComponent)$editorTextField);
            }

            @NotNull
            public EditorTextField getEditorTextField() {
                return this.$editorTextField;
            }
        };
    }

    private static final void requestFocus$lambda$0(NewEditChangelistPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this$0.nameTextField, true);
    }

    public static final /* synthetic */ ComponentWithTextFieldWrapper access$getNameComponent$p(NewEditChangelistPanel $this) {
        return $this.nameComponent;
    }

    public static final /* synthetic */ JPanel access$getAdditionalControlsPanel$p(NewEditChangelistPanel $this) {
        return $this.additionalControlsPanel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel$Companion;", "", "()V", "createEditorField", "Lcom/intellij/ui/EditorTextField;", "project", "Lcom/intellij/openapi/project/Project;", "defaultLines", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final EditorTextField createEditorField(Project project2, int defaultLines) {
            Set editorFeatures = new HashSet();
            ContainerUtil.addIfNotNull((Collection)editorFeatures, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
            if (defaultLines == 1) {
                HorizontalScrollBarEditorCustomization horizontalScrollBarEditorCustomization = HorizontalScrollBarEditorCustomization.DISABLED;
                Intrinsics.checkNotNullExpressionValue((Object)horizontalScrollBarEditorCustomization, (String)"DISABLED");
                editorFeatures.add(horizontalScrollBarEditorCustomization);
                OneLineEditorCustomization oneLineEditorCustomization = OneLineEditorCustomization.ENABLED;
                Intrinsics.checkNotNullExpressionValue((Object)oneLineEditorCustomization, (String)"ENABLED");
                editorFeatures.add(oneLineEditorCustomization);
            } else {
                SoftWrapsEditorCustomization softWrapsEditorCustomization = SoftWrapsEditorCustomization.ENABLED;
                Intrinsics.checkNotNullExpressionValue((Object)softWrapsEditorCustomization, (String)"ENABLED");
                editorFeatures.add(softWrapsEditorCustomization);
            }
            EditorTextField editorTextField = EditorTextFieldProvider.getInstance().getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project2, (Iterable)editorFeatures);
            Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"getEditorField(...)");
            EditorTextField editorField = editorTextField;
            if (defaultLines > 1) {
                editorField.addSettingsProvider(Companion::createEditorField$lambda$0);
                editorField.setMinimumSize((Dimension)new JBDimension(200, 1));
                editorField.setPreferredSize((Dimension)new JBDimension(200, 1));
            }
            return editorField;
        }

        private static final void createEditorField$lambda$0(EditorEx editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            editor.getContentComponent().setBorder((Border)JBUI.Borders.empty((int)3, (int)5));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b$\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel$ComponentWithTextFieldWrapper;", "", "myComponent", "Ljavax/swing/JComponent;", "(Ljavax/swing/JComponent;)V", "editorTextField", "Lcom/intellij/ui/EditorTextField;", "getEditorTextField", "()Lcom/intellij/ui/EditorTextField;", "getMyComponent", "()Ljavax/swing/JComponent;", "intellij.platform.vcs.impl"})
    protected static abstract class ComponentWithTextFieldWrapper {
        @NotNull
        private final JComponent myComponent;

        public ComponentWithTextFieldWrapper(@NotNull JComponent myComponent) {
            Intrinsics.checkNotNullParameter((Object)myComponent, (String)"myComponent");
            this.myComponent = myComponent;
        }

        @NotNull
        public final JComponent getMyComponent() {
            return this.myComponent;
        }

        @NotNull
        public abstract EditorTextField getEditorTextField();
    }
}

