/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ChangesViewPanel;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitWorkflow;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitMode;
import com.intellij.vcs.commit.CommitModeManager;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class ChangesViewWorkflowManager
implements Disposable {
    @Topic.ProjectLevel
    public static final Topic<ChangesViewWorkflowListener> TOPIC = new Topic(ChangesViewWorkflowListener.class, Topic.BroadcastDirection.NONE, true);
    @NotNull
    private final Project myProject;
    @Nullable
    private ChangesViewCommitWorkflowHandler myCommitWorkflowHandler;
    private boolean myInitialized;

    @NotNull
    public static ChangesViewWorkflowManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ChangesViewWorkflowManager.$$$reportNull$$$0(0);
        }
        ChangesViewWorkflowManager changesViewWorkflowManager = (ChangesViewWorkflowManager)project2.getService(ChangesViewWorkflowManager.class);
        if (changesViewWorkflowManager == null) {
            ChangesViewWorkflowManager.$$$reportNull$$$0(1);
        }
        return changesViewWorkflowManager;
    }

    public ChangesViewWorkflowManager(@NotNull Project project2) {
        if (project2 == null) {
            ChangesViewWorkflowManager.$$$reportNull$$$0(2);
        }
        this.myInitialized = false;
        this.myProject = project2;
        MessageBusConnection busConnection = project2.getMessageBus().connect((Disposable)this);
        CommitModeManager.subscribeOnCommitModeChange((SimpleMessageBusConnection)busConnection, () -> this.updateCommitWorkflowHandler());
        ApplicationManager.getApplication().invokeLater(() -> this.updateCommitWorkflowHandler(), ModalityState.nonModal(), this.myProject.getDisposed());
    }

    @Nullable
    public ChangesViewCommitWorkflowHandler getCommitWorkflowHandler() {
        if (ApplicationManager.getApplication().isDispatchThread() && !this.myInitialized) {
            this.updateCommitWorkflowHandler();
        }
        return this.myCommitWorkflowHandler;
    }

    @RequiresEdt
    private void updateCommitWorkflowHandler() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myInitialized = true;
        boolean isNonModal = CommitModeManager.getInstance(this.myProject).getCurrentCommitMode() instanceof CommitMode.NonModalCommitMode;
        if (isNonModal) {
            if (this.myCommitWorkflowHandler == null) {
                Activity activity2 = StartUpMeasurer.startActivity((String)"ChangesViewWorkflowManager initialization");
                ChangesViewPanel changesPanel = ((ChangesViewManager)ChangesViewManager.getInstance(this.myProject)).initChangesPanel();
                ChangesViewCommitWorkflow workflow = new ChangesViewCommitWorkflow(this.myProject);
                ChangesViewCommitPanel commitPanel2 = new ChangesViewCommitPanel(this.myProject, changesPanel);
                this.myCommitWorkflowHandler = new ChangesViewCommitWorkflowHandler(workflow, commitPanel2);
                ((ChangesViewWorkflowListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).commitWorkflowChanged();
                activity2.end();
            } else {
                this.myCommitWorkflowHandler.resetActivation();
            }
        } else if (this.myCommitWorkflowHandler != null) {
            Disposer.dispose((Disposable)this.myCommitWorkflowHandler);
            this.myCommitWorkflowHandler = null;
            ((ChangesViewWorkflowListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).commitWorkflowChanged();
        }
    }

    public void dispose() {
        if (this.myCommitWorkflowHandler != null) {
            Disposer.dispose((Disposable)this.myCommitWorkflowHandler);
            this.myCommitWorkflowHandler = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewWorkflowManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewWorkflowManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    public static interface ChangesViewWorkflowListener
    extends EventListener {
        public void commitWorkflowChanged();
    }
}

