/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.impl.VcsSelectionHistoryDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionUtil;
import com.intellij.vcsUtil.VcsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedBlockHistoryAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    private static boolean isEnabled(@Nullable Project project2, @Nullable VcsSelection selection) {
        if (project2 == null || selection == null) {
            return false;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(selection.getDocument());
        if (file == null) {
            return false;
        }
        FilePath filePath = VcsUtil.getFilePath(file);
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance(project2).getVcsFor(file);
        if (activeVcs == null) {
            return false;
        }
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        if (provider == null) {
            return false;
        }
        return AbstractVcs.fileInVcsByFileStatus(project2, filePath);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(1);
        }
        Project project2 = event.getProject();
        assert (project2 != null);
        VcsSelection selection = VcsSelectionUtil.getSelection((AnAction)this, event);
        assert (selection != null);
        VirtualFile file = FileDocumentManager.getInstance().getFile(selection.getDocument());
        assert (file != null);
        AbstractVcs activeVcs = ProjectLevelVcsManager.getInstance(project2).getVcsFor(file);
        assert (activeVcs != null);
        VcsHistoryProvider provider = activeVcs.getVcsBlockHistoryProvider();
        assert (provider != null);
        int selectionStart = selection.getSelectionStartLineNumber();
        int selectionEnd = selection.getSelectionEndLineNumber();
        VcsSelectionHistoryDialog dialog = new VcsSelectionHistoryDialog(project2, file, selection.getDocument(), provider, activeVcs, Math.min(selectionStart, selectionEnd), Math.max(selectionStart, selectionEnd), selection.getDialogTitle());
        dialog.show();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectedBlockHistoryAction.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = event.getPresentation();
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        VcsSelection selection = VcsSelectionUtil.getSelection((AnAction)this, event);
        presentation2.setEnabled(SelectedBlockHistoryAction.isEnabled(project2, selection));
        if (selection != null) {
            presentation2.setText(selection.getActionName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/SelectedBlockHistoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2 -> new IllegalArgumentException(string2);
        };
    }
}

