/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.google.common.collect.Iterables;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.GitPatchParser;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchFileHeaderInfo;
import com.intellij.openapi.diff.impl.patch.PatchFileHeaderParser;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.vcsUtil.VcsFileUtil;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchReader {
    @NonNls
    public static final String NO_NEWLINE_SIGNATURE = "\\ No newline at end of file";
    private final List<String> myLines;
    private final PatchContentParser myPatchContentParser;
    private final AdditionalInfoParser myAdditionalInfoParser;
    private List<FilePatch> myPatches;
    private PatchFileHeaderInfo myPatchFileInfo;
    @NonNls
    private static final String CONTEXT_HUNK_PREFIX = "***************";
    @NonNls
    private static final String CONTEXT_FILE_PREFIX = "*** ";
    @NonNls
    private static final String UNIFIED_BEFORE_HUNK_PREFIX = "--- ";
    @NonNls
    private static final String UNIFIED_AFTER_HUNK_PREFIX = "+++ ";
    @NonNls
    private static final String DIFF_GIT_HEADER_LINE = "diff --git";
    @NonNls
    static final String HASH_PATTERN = "[0-9a-fA-F]+";
    @NonNls
    private static final Pattern ourUnifiedHunkStartPattern = Pattern.compile("@@ -(\\d+)(,(\\d+))? \\+(\\d+)(,(\\d+))? @@.*");
    @NonNls
    private static final Pattern ourContextBeforeHunkStartPattern = Pattern.compile("\\*\\*\\* (\\d+),(\\d+) \\*\\*\\*\\*");
    @NonNls
    private static final Pattern ourContextAfterHunkStartPattern = Pattern.compile("--- (\\d+),(\\d+) ----");
    @NonNls
    private static final Pattern ourEmptyRevisionInfoPattern = Pattern.compile("\\(\\s*revision\\s*\\)");
    @NonNls
    private static final Pattern ourGitHeaderLinePattern = Pattern.compile("diff --git\\s+(\\S+)\\s+(\\S+).*");

    public PatchReader(CharSequence patchContent) {
        this(patchContent, true);
    }

    public PatchReader(@NotNull Path file) {
        if (file == null) {
            PatchReader.$$$reportNull$$$0(0);
        }
        this(PathKt.readChars((Path)file), true);
    }

    public PatchReader(CharSequence patchContent, boolean saveHunks) {
        this.myLines = LineTokenizer.tokenizeIntoList((CharSequence)patchContent, (boolean)false);
        this.myAdditionalInfoParser = new AdditionalInfoParser(!saveHunks);
        this.myPatchContentParser = new PatchContentParser(saveHunks);
    }

    @NotNull
    public List<TextFilePatch> readTextPatches() throws PatchSyntaxException {
        this.parseAllPatches();
        List<TextFilePatch> list2 = this.getTextPatches();
        if (list2 == null) {
            PatchReader.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    public CharSequence getBaseRevision(@NotNull String relativeFilePath) {
        Map<String, CharSequence> inner;
        Map<String, Map<String, CharSequence>> map2;
        if (relativeFilePath == null) {
            PatchReader.$$$reportNull$$$0(2);
        }
        if (!(map2 = this.myAdditionalInfoParser.getResultMap()).isEmpty() && (inner = map2.get(relativeFilePath)) != null) {
            BaseRevisionTextPatchEP baseRevisionTextPatchEP = (BaseRevisionTextPatchEP)PatchEP.EP_NAME.findExtensionOrFail(BaseRevisionTextPatchEP.class);
            return inner.get(baseRevisionTextPatchEP.getName());
        }
        return null;
    }

    @NotNull
    public List<TextFilePatch> getTextPatches() {
        List list2 = ContainerUtil.findAll(this.myPatches, TextFilePatch.class);
        if (list2 == null) {
            PatchReader.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public List<FilePatch> getAllPatches() {
        List<FilePatch> list2 = this.myPatches;
        if (list2 == null) {
            PatchReader.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void parseAllPatches() throws PatchSyntaxException {
        ListIterator<String> iterator = this.myLines.listIterator();
        if (!iterator.hasNext()) {
            this.myPatches = Collections.emptyList();
            return;
        }
        boolean containsAdditional = false;
        boolean isHeaderLine = true;
        int headerLineNum = 0;
        while (iterator.hasNext()) {
            String next = iterator.next();
            boolean containsAdditionalNow = this.myAdditionalInfoParser.testIsStart(next);
            if (containsAdditionalNow && containsAdditional) {
                this.myAdditionalInfoParser.acceptError(new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.contains.additional.information.without.patch.itself", new Object[0])));
            }
            if (containsAdditionalNow) {
                isHeaderLine = false;
                containsAdditional = true;
                this.myAdditionalInfoParser.parse(next, iterator);
                if (!iterator.hasNext()) {
                    this.myAdditionalInfoParser.acceptError(new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.contains.additional.information.without.patch.itself", new Object[0])));
                    break;
                }
                next = iterator.next();
            }
            if (this.myPatchContentParser.testIsStart(next)) {
                isHeaderLine = false;
                this.myPatchContentParser.parse(next, iterator);
                if (containsAdditional) {
                    String lastName = this.myPatchContentParser.getLastName();
                    if (lastName == null) {
                        this.myAdditionalInfoParser.acceptError(new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.contains.additional.information.without.patch.itself", new Object[0])));
                    } else {
                        this.myAdditionalInfoParser.copyToResult(lastName);
                    }
                }
                containsAdditional = false;
            }
            if (!isHeaderLine) continue;
            ++headerLineNum;
        }
        this.myPatches = this.myPatchContentParser.getResult();
        this.myPatchFileInfo = PatchFileHeaderParser.parseHeader(Iterables.limit(this.myLines, (int)headerLineNum).iterator());
    }

    @NotNull
    public ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> getAdditionalInfo(@Nullable Set<String> paths) {
        PatchSyntaxException e = this.myAdditionalInfoParser.getSyntaxException();
        if (e != null) {
            ThrowableComputable throwableComputable = () -> {
                throw e;
            };
            if (throwableComputable == null) {
                PatchReader.$$$reportNull$$$0(5);
            }
            return throwableComputable;
        }
        ThrowableComputable throwableComputable = () -> ContainerUtil.filter(this.myAdditionalInfoParser.getResultMap(), path2 -> paths == null || paths.contains(path2));
        if (throwableComputable == null) {
            PatchReader.$$$reportNull$$$0(6);
        }
        return throwableComputable;
    }

    public PatchFileHeaderInfo getPatchFileInfo() {
        return this.myPatchFileInfo;
    }

    public static boolean isPatchContent(@Nullable String content) {
        String line;
        if (content == null) {
            return false;
        }
        List lines = LineTokenizer.tokenizeIntoList((CharSequence)content, (boolean)false);
        ListIterator iterator = lines.listIterator();
        DiffFormat currentFormat = null;
        while (iterator.hasNext()) {
            line = (String)iterator.next();
            if (line.startsWith(CONTEXT_HUNK_PREFIX)) {
                currentFormat = DiffFormat.CONTEXT;
                continue;
            }
            if (currentFormat == DiffFormat.CONTEXT && ourContextBeforeHunkStartPattern.matcher(line).matches()) break;
            if (line.startsWith(UNIFIED_BEFORE_HUNK_PREFIX) && currentFormat == null) {
                currentFormat = DiffFormat.UNIFIED;
                continue;
            }
            if (currentFormat != DiffFormat.UNIFIED || !line.startsWith(UNIFIED_AFTER_HUNK_PREFIX)) continue;
            break;
        }
        if (currentFormat == null) {
            return false;
        }
        while (iterator.hasNext()) {
            line = (String)iterator.next();
            if (!(currentFormat == DiffFormat.CONTEXT ? ourContextAfterHunkStartPattern.matcher(line).matches() : ourUnifiedHunkStartPattern.matcher(line).matches())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/PatchReader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/PatchReader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readTextPatches";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextPatches";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPatches";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBaseRevision";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 4, 5, 6 -> new IllegalStateException(string2);
        };
    }

    private static final class AdditionalInfoParser
    implements Parser {
        private final Map<String, Map<String, CharSequence>> myResultMap;
        private final boolean myIgnoreMode;
        private Map<String, CharSequence> myAddMap;
        private PatchSyntaxException mySyntaxException;

        private AdditionalInfoParser(boolean ignore) {
            this.myIgnoreMode = ignore;
            this.myAddMap = new HashMap<String, CharSequence>();
            this.myResultMap = new HashMap<String, Map<String, CharSequence>>();
        }

        public PatchSyntaxException getSyntaxException() {
            return this.mySyntaxException;
        }

        public Map<String, Map<String, CharSequence>> getResultMap() {
            return this.myResultMap;
        }

        public void copyToResult(String filePath) {
            if (this.myAddMap != null && !this.myAddMap.isEmpty()) {
                this.myResultMap.put(filePath, this.myAddMap);
                this.myAddMap = new HashMap<String, CharSequence>();
            }
        }

        @Override
        public boolean testIsStart(String start2) {
            if (this.myIgnoreMode || this.mySyntaxException != null) {
                return false;
            }
            return start2 != null && start2.contains("IDEA additional info:");
        }

        @Override
        public void parse(String start2, ListIterator<String> iterator) {
            if (this.myIgnoreMode) {
                return;
            }
            if (!iterator.hasNext()) {
                this.mySyntaxException = new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.empty.additional.info.header", new Object[0]));
                return;
            }
            block0: while (true) {
                String header;
                int idxHead;
                if ((idxHead = (header = iterator.next()).indexOf("Subsystem: ")) == -1) {
                    if (this.myAddMap.isEmpty()) {
                        this.mySyntaxException = new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.empty.additional.info.header", new Object[0]));
                    }
                    iterator.previous();
                    return;
                }
                String subsystem = header.substring(idxHead + "Subsystem: ".length()).trim();
                if (!iterator.hasNext()) {
                    this.mySyntaxException = new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.empty.0.data.section", subsystem));
                    return;
                }
                StringBuilder sb = new StringBuilder();
                this.myAddMap.put(subsystem, sb);
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    String line = iterator.next();
                    if (!line.startsWith("<+>")) {
                        iterator.previous();
                        continue block0;
                    }
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(StringUtil.unescapeStringCharacters((String)line.substring("<+>".length())));
                }
                break;
            }
        }

        public void acceptError(PatchSyntaxException e) {
            this.mySyntaxException = e;
        }
    }

    static final class PatchContentParser
    implements Parser {
        private final boolean mySaveHunks;
        private DiffFormat myDiffFormat = null;
        private final List<FilePatch> myPatches;
        private boolean myGitDiffFormat;

        PatchContentParser(boolean saveHunks) {
            this.mySaveHunks = saveHunks;
            this.myPatches = new SmartList();
        }

        @Override
        public boolean testIsStart(String start2) {
            if (start2.startsWith(PatchReader.DIFF_GIT_HEADER_LINE)) {
                this.myGitDiffFormat = true;
                return true;
            }
            if (start2.startsWith(PatchReader.UNIFIED_BEFORE_HUNK_PREFIX) && (this.myDiffFormat == null || this.myDiffFormat == DiffFormat.UNIFIED)) {
                this.myDiffFormat = DiffFormat.UNIFIED;
                return true;
            }
            if (start2.startsWith(PatchReader.CONTEXT_FILE_PREFIX) && (this.myDiffFormat == null || this.myDiffFormat == DiffFormat.CONTEXT)) {
                this.myDiffFormat = DiffFormat.CONTEXT;
                return true;
            }
            return false;
        }

        @Override
        public void parse(String start2, ListIterator<String> iterator) throws PatchSyntaxException {
            if (this.myGitDiffFormat) {
                this.addPatchAndResetSettings(GitPatchParser.parse(start2, iterator, this.mySaveHunks));
            } else {
                this.addPatchAndResetSettings(this.readTextPatch(start2, iterator));
            }
        }

        private void addPatchAndResetSettings(@Nullable FilePatch patch) {
            if (patch != null) {
                this.myPatches.add(patch);
            }
            this.myGitDiffFormat = false;
        }

        public List<FilePatch> getResult() {
            return this.myPatches;
        }

        TextFilePatch readTextPatch(String curLine, ListIterator<String> iterator) throws PatchSyntaxException {
            PatchHunk hunk;
            String secondNamePrefix;
            TextFilePatch curPatch = this.mySaveHunks ? new TextFilePatch(null) : new EmptyTextFilePatch();
            PatchContentParser.extractFileName(curLine, curPatch, true);
            if (!iterator.hasNext()) {
                throw new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.second.file.name.expected", new Object[0]));
            }
            curLine = iterator.next();
            String string2 = secondNamePrefix = this.myDiffFormat == DiffFormat.UNIFIED ? PatchReader.UNIFIED_AFTER_HUNK_PREFIX : PatchReader.UNIFIED_BEFORE_HUNK_PREFIX;
            if (!curLine.startsWith(secondNamePrefix)) {
                throw new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.second.file.name.expected", new Object[0]));
            }
            PatchContentParser.extractFileName(curLine, curPatch, false);
            while (iterator.hasNext() && (hunk = this.myDiffFormat == DiffFormat.UNIFIED ? PatchContentParser.readNextHunkUnified(iterator) : PatchContentParser.readNextHunkContext(iterator)) != null) {
                curPatch.addHunk(hunk);
            }
            if (curPatch.getBeforeName() == null) {
                curPatch.setBeforeName(curPatch.getAfterName());
            }
            if (curPatch.getAfterName() == null) {
                curPatch.setAfterName(curPatch.getBeforeName());
            }
            return curPatch;
        }

        @Nullable
        private static PatchHunk readNextHunkUnified(@NotNull ListIterator<String> iterator) throws PatchSyntaxException {
            if (iterator == null) {
                PatchContentParser.$$$reportNull$$$0(0);
            }
            String curLine = null;
            int numIncrements = 0;
            while (iterator.hasNext()) {
                curLine = iterator.next();
                ++numIncrements;
                if (curLine.startsWith(PatchReader.UNIFIED_BEFORE_HUNK_PREFIX) || ourGitHeaderLinePattern.matcher(curLine).matches()) {
                    for (int i = 0; i < numIncrements; ++i) {
                        iterator.previous();
                    }
                    return null;
                }
                if (!curLine.startsWith("@@ ")) continue;
            }
            if (!iterator.hasNext()) {
                return null;
            }
            Matcher m = ourUnifiedHunkStartPattern.matcher(curLine);
            if (!m.matches()) {
                throw new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.unknown.hunk.start.syntax", new Object[0]));
            }
            int startLineBefore = Integer.parseInt(m.group(1));
            String linesBeforeText = m.group(3);
            int linesBefore = linesBeforeText == null ? 1 : Integer.parseInt(linesBeforeText);
            int startLineAfter = Integer.parseInt(m.group(4));
            String linesAfterText = m.group(6);
            int linesAfter = linesAfterText == null ? 1 : Integer.parseInt(linesAfterText);
            PatchHunk hunk = new PatchHunk(startLineBefore - 1, startLineBefore + linesBefore - 1, startLineAfter - 1, startLineAfter + linesAfter - 1);
            PatchLine lastLine = null;
            int before2 = 0;
            int after = 0;
            while (iterator.hasNext()) {
                String hunkCurLine = iterator.next();
                if (lastLine != null && hunkCurLine.startsWith(PatchReader.NO_NEWLINE_SIGNATURE)) {
                    lastLine.setSuppressNewLine(true);
                    continue;
                }
                lastLine = PatchContentParser.parsePatchLine(hunkCurLine, 1, before2 < linesBefore || after < linesAfter);
                if (lastLine == null) {
                    iterator.previous();
                    break;
                }
                switch (lastLine.getType()) {
                    case CONTEXT: {
                        ++before2;
                        ++after;
                        break;
                    }
                    case ADD: {
                        ++after;
                        break;
                    }
                    case REMOVE: {
                        ++before2;
                    }
                }
                hunk.addLine(lastLine);
            }
            return hunk;
        }

        @Nullable
        public String getLastName() {
            if (this.myPatches.isEmpty()) {
                return null;
            }
            FilePatch patch = this.myPatches.get(this.myPatches.size() - 1);
            return patch.getBeforeName() == null ? patch.getAfterName() : patch.getBeforeName();
        }

        @Nullable
        private static PatchLine parsePatchLine(String line, int prefixLength) {
            return PatchContentParser.parsePatchLine(line, prefixLength, true);
        }

        @Nullable
        private static PatchLine parsePatchLine(String line, int prefixLength, boolean expectMeaningfulLines) {
            PatchLine.Type type2;
            if (!expectMeaningfulLines) {
                return null;
            }
            if (line.startsWith("+")) {
                type2 = PatchLine.Type.ADD;
            } else if (line.startsWith("-")) {
                type2 = PatchLine.Type.REMOVE;
            } else if (line.isEmpty() || line.startsWith(" ")) {
                type2 = PatchLine.Type.CONTEXT;
            } else {
                return null;
            }
            String lineText = line.length() < prefixLength ? "" : line.substring(prefixLength);
            return new PatchLine(type2, lineText);
        }

        @Nullable
        private static PatchHunk readNextHunkContext(ListIterator<String> iterator) throws PatchSyntaxException {
            while (iterator.hasNext()) {
                String curLine = iterator.next();
                if (curLine.startsWith(PatchReader.CONTEXT_FILE_PREFIX)) {
                    iterator.previous();
                    return null;
                }
                if (!curLine.startsWith(PatchReader.CONTEXT_HUNK_PREFIX)) continue;
                break;
            }
            if (!iterator.hasNext()) {
                return null;
            }
            Matcher beforeMatcher = ourContextBeforeHunkStartPattern.matcher(iterator.next());
            if (!beforeMatcher.matches()) {
                throw new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.unknown.before.hunk.start.syntax", new Object[0]));
            }
            List<String> beforeLines = PatchContentParser.readContextDiffLines(iterator);
            if (!iterator.hasNext()) {
                throw new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.missing.after.hunk", new Object[0]));
            }
            Matcher afterMatcher = ourContextAfterHunkStartPattern.matcher(iterator.next());
            if (!afterMatcher.matches()) {
                throw new PatchSyntaxException(iterator.previousIndex(), VcsBundle.message("patch.unknown.after.hunk.start.syntax", new Object[0]));
            }
            List<String> afterLines = PatchContentParser.readContextDiffLines(iterator);
            int startLineBefore = Integer.parseInt(beforeMatcher.group(1));
            int endLineBefore = Integer.parseInt(beforeMatcher.group(2));
            int startLineAfter = Integer.parseInt(afterMatcher.group(1));
            int endLineAfter = Integer.parseInt(afterMatcher.group(2));
            PatchHunk hunk = new PatchHunk(startLineBefore - 1, endLineBefore - 1, startLineAfter - 1, endLineAfter - 1);
            int beforeLineIndex = 0;
            int afterLineIndex = 0;
            PatchLine lastBeforePatchLine = null;
            PatchLine lastAfterPatchLine = null;
            if (beforeLines.size() == 0) {
                for (String line : afterLines) {
                    hunk.addLine(PatchContentParser.parsePatchLine(line, 2));
                }
            } else if (afterLines.size() == 0) {
                for (String line : beforeLines) {
                    hunk.addLine(PatchContentParser.parsePatchLine(line, 2));
                }
            } else {
                while (beforeLineIndex < beforeLines.size() || afterLineIndex < afterLines.size()) {
                    String afterLine;
                    String beforeLine = beforeLineIndex >= beforeLines.size() ? null : beforeLines.get(beforeLineIndex);
                    String string2 = afterLine = afterLineIndex >= afterLines.size() ? null : afterLines.get(afterLineIndex);
                    if (PatchContentParser.startsWith(beforeLine, PatchReader.NO_NEWLINE_SIGNATURE) && lastBeforePatchLine != null) {
                        lastBeforePatchLine.setSuppressNewLine(true);
                        ++beforeLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(afterLine, PatchReader.NO_NEWLINE_SIGNATURE) && lastAfterPatchLine != null) {
                        lastAfterPatchLine.setSuppressNewLine(true);
                        ++afterLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(beforeLine, " ") && (PatchContentParser.startsWith(afterLine, " ") || afterLine == null)) {
                        PatchContentParser.addContextDiffLine(hunk, beforeLine, PatchLine.Type.CONTEXT);
                        ++beforeLineIndex;
                        ++afterLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(beforeLine, "-")) {
                        lastBeforePatchLine = PatchContentParser.addContextDiffLine(hunk, beforeLine, PatchLine.Type.REMOVE);
                        ++beforeLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(afterLine, "+")) {
                        lastAfterPatchLine = PatchContentParser.addContextDiffLine(hunk, afterLine, PatchLine.Type.ADD);
                        ++afterLineIndex;
                        continue;
                    }
                    if (PatchContentParser.startsWith(beforeLine, "!") && PatchContentParser.startsWith(afterLine, "!")) {
                        while (beforeLineIndex < beforeLines.size() && beforeLines.get(beforeLineIndex).startsWith("! ")) {
                            lastBeforePatchLine = PatchContentParser.addContextDiffLine(hunk, beforeLines.get(beforeLineIndex), PatchLine.Type.REMOVE);
                            ++beforeLineIndex;
                        }
                        while (afterLineIndex < afterLines.size() && afterLines.get(afterLineIndex).startsWith("! ")) {
                            lastAfterPatchLine = PatchContentParser.addContextDiffLine(hunk, afterLines.get(afterLineIndex), PatchLine.Type.ADD);
                            ++afterLineIndex;
                        }
                        continue;
                    }
                    throw new PatchSyntaxException(-1, VcsBundle.message("patch.unknown.line.prefix", new Object[0]));
                }
            }
            return hunk;
        }

        private static boolean startsWith(@Nullable String line, String prefix) {
            return line != null && line.startsWith(prefix);
        }

        private static PatchLine addContextDiffLine(PatchHunk hunk, String line, PatchLine.Type type2) {
            PatchLine patchLine = new PatchLine(type2, line.length() < 2 ? "" : line.substring(2));
            hunk.addLine(patchLine);
            return patchLine;
        }

        private static List<String> readContextDiffLines(ListIterator<String> iterator) {
            ArrayList<String> result2 = new ArrayList<String>();
            while (iterator.hasNext()) {
                String line = iterator.next();
                if (!(line.startsWith(" ") || line.startsWith("+ ") || line.startsWith("- ") || line.startsWith("! ") || line.startsWith(PatchReader.NO_NEWLINE_SIGNATURE))) {
                    iterator.previous();
                    break;
                }
                result2.add(line);
            }
            return result2;
        }

        private static void extractFileName(String curLine, FilePatch patch, boolean before2) {
            String newFileName;
            String fileName = curLine.substring(4);
            int pos = fileName.indexOf(9);
            if (pos < 0) {
                pos = fileName.indexOf(32);
            }
            if (pos >= 0) {
                @NlsSafe String versionId = fileName.substring(pos).trim();
                fileName = fileName.substring(0, pos);
                if (versionId.length() > 0 && !ourEmptyRevisionInfoPattern.matcher(versionId).matches()) {
                    if (before2) {
                        patch.setBeforeVersionId(versionId);
                    } else {
                        patch.setAfterVersionId(versionId);
                    }
                }
            }
            if ((newFileName = PatchContentParser.stripPatchNameIfNeeded(fileName = VcsFileUtil.unescapeGitPath(fileName), before2)) == null) {
                return;
            }
            if (before2) {
                patch.setBeforeName(newFileName);
            } else {
                patch.setAfterName(newFileName);
            }
        }

        @Nullable
        static String stripPatchNameIfNeeded(@NotNull String fileName, boolean before2) {
            if (fileName == null) {
                PatchContentParser.$$$reportNull$$$0(1);
            }
            if ("/dev/null".equals(fileName)) {
                return null;
            }
            String prefix = before2 ? "a/" : "b/";
            return StringUtil.trimStart((String)fileName, (String)prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/patch/PatchReader$PatchContentParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readNextHunkUnified";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stripPatchNameIfNeeded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum DiffFormat {
        CONTEXT,
        UNIFIED;

    }

    private static class EmptyTextFilePatch
    extends TextFilePatch {
        private int myHunkCount = 0;
        private boolean myNew;
        private boolean myDeleted;

        EmptyTextFilePatch() {
            super((Charset)null);
        }

        @Override
        public void addHunk(PatchHunk hunk) {
            if (this.myHunkCount == 0) {
                if (hunk.isNewContent()) {
                    this.myNew = true;
                } else if (hunk.isDeletedContent()) {
                    this.myDeleted = true;
                }
            }
            ++this.myHunkCount;
        }

        @Override
        public boolean isNewFile() {
            return this.myHunkCount == 1 && this.myNew;
        }

        @Override
        public boolean isDeletedFile() {
            return this.myHunkCount == 1 && this.myDeleted;
        }
    }

    private static interface Parser {
        public boolean testIsStart(String var1);

        public void parse(String var1, ListIterator<String> var2) throws PatchSyntaxException;
    }
}

