/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.Nullable;

public abstract class FilePatch {
    @Nullable
    private String myBeforeName;
    @Nullable
    private String myAfterName;
    @Nullable
    private String myBeforeVersionId;
    @Nullable
    private String myAfterVersionId;
    private int myNewFileMode = -1;

    public String getBeforeName() {
        return this.myBeforeName;
    }

    public String getAfterName() {
        return this.myAfterName;
    }

    @Nullable
    public String getBeforeFileName() {
        if (this.myBeforeName == null) {
            return null;
        }
        String[] pathNameComponents = this.myBeforeName.split("/");
        return pathNameComponents[pathNameComponents.length - 1];
    }

    @Nullable
    public String getAfterFileName() {
        if (this.myAfterName == null) {
            return null;
        }
        String[] pathNameComponents = this.myAfterName.split("/");
        return pathNameComponents[pathNameComponents.length - 1];
    }

    public void setBeforeName(@Nullable String fileName) {
        this.myBeforeName = fileName;
    }

    public void setAfterName(@Nullable String fileName) {
        this.myAfterName = fileName;
    }

    @Nullable
    @NlsSafe
    public String getBeforeVersionId() {
        return this.myBeforeVersionId;
    }

    public void setBeforeVersionId(@Nullable @NlsSafe String beforeVersionId) {
        this.myBeforeVersionId = beforeVersionId;
    }

    @Nullable
    @NlsSafe
    public String getAfterVersionId() {
        return this.myAfterVersionId;
    }

    public void setAfterVersionId(@Nullable @NlsSafe String afterVersionId) {
        this.myAfterVersionId = afterVersionId;
    }

    public abstract boolean isNewFile();

    public abstract boolean isDeletedFile();

    public int getNewFileMode() {
        return this.myNewFileMode;
    }

    public void setNewFileMode(int newFileMode) {
        this.myNewFileMode = newFileMode;
    }

    public String toString() {
        return "FilePatch{myBeforeName='" + this.myBeforeName + "', myAfterName='" + this.myAfterName + "', myBeforeVersionId='" + this.myBeforeVersionId + "', myAfterVersionId='" + this.myAfterVersionId + "'}";
    }
}

