/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StartUseVcsDialog
extends DialogWrapper {
    @NonNls
    private static final String GIT = "Git";
    private final ComboBox<AbstractVcs> myVcsCombo;
    @NotNull
    private final String myTargetDirectory;
    private static final Comparator<AbstractVcs> VCS_COMPARATOR = Comparator.comparingInt(vcs -> GIT.equals(vcs.getName()) ? -1 : 0).thenComparing(vcs -> vcs.getDisplayName(), String.CASE_INSENSITIVE_ORDER);

    public StartUseVcsDialog(@NotNull Project project2, @NotNull String targetDirectory) {
        if (project2 == null) {
            StartUseVcsDialog.$$$reportNull$$$0(0);
        }
        if (targetDirectory == null) {
            StartUseVcsDialog.$$$reportNull$$$0(1);
        }
        super(project2, true);
        this.myTargetDirectory = targetDirectory;
        Object[] vcses = ProjectLevelVcsManager.getInstance(project2).getAllSupportedVcss();
        ContainerUtil.sort((Object[])vcses, VCS_COMPARATOR);
        this.myVcsCombo = new ComboBox(vcses);
        this.myVcsCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", AbstractVcs::getDisplayName));
        this.setTitle(VcsBundle.message("dialog.enable.version.control.integration.title", new Object[0]));
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myVcsCombo;
    }

    protected JComponent createCenterPanel() {
        JLabel selectText = new JLabel(VcsBundle.message("dialog.enable.version.control.integration.select.vcs.label.text", PathUtil.getFileName((String)this.myTargetDirectory)));
        selectText.setUI((LabelUI)new MultiLineLabelUI());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.insets((int)5), 0, 0);
        mainPanel.add((Component)selectText, gb);
        ++gb.gridx;
        mainPanel.add((Component)this.myVcsCombo, gb);
        String path2 = SystemInfo.isMac ? VcsBundle.message("vcs.settings.path.mac", new Object[0]) : VcsBundle.message("vcs.settings.path", new Object[0]);
        JLabel helpText = new JLabel(VcsBundle.message("dialog.enable.version.control.integration.hint.text", new Object[0]) + path2);
        helpText.setUI((LabelUI)new MultiLineLabelUI());
        helpText.setForeground(NamedColorUtil.getInactiveTextColor());
        gb.anchor = 18;
        gb.gridx = 0;
        ++gb.gridy;
        gb.gridwidth = 2;
        mainPanel.add((Component)helpText, gb);
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBInsets.emptyInsets(), 0, 0);
        wrapper.add((Component)mainPanel, gbc);
        return wrapper;
    }

    protected String getHelpId() {
        return "reference.version.control.enable.version.control.integration";
    }

    @NotNull
    public AbstractVcs getVcs() {
        AbstractVcs abstractVcs = (AbstractVcs)this.myVcsCombo.getItem();
        if (abstractVcs == null) {
            StartUseVcsDialog.$$$reportNull$$$0(2);
        }
        return abstractVcs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/StartUseVcsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/StartUseVcsDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2 -> new IllegalStateException(string2);
        };
    }
}

