/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.revisions.Revision;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.text.DateFormatUtil;

public final class RecentChange {
    private final Revision myBefore;
    private final Revision myAfter;

    public RecentChange(Revision before2, Revision after) {
        this.myBefore = before2;
        this.myAfter = after;
    }

    public Revision getRevisionBefore() {
        return this.myBefore;
    }

    public Revision getRevisionAfter() {
        return this.myAfter;
    }

    @NlsContexts.Label
    public String getChangeName() {
        return this.myAfter.getChangeSetName();
    }

    public long getTimestamp() {
        return this.myAfter.getTimestamp();
    }

    public String toString() {
        return this.getChangeName() + "[" + DateFormatUtil.formatDateTime((long)this.getTimestamp()) + "]";
    }
}

