/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.Paths;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Difference {
    private final boolean myIsFile;
    private final Entry myLeft;
    private final Entry myRight;
    private final boolean myRightContentCurrent;

    public Difference(boolean isFile, Entry left, Entry right) {
        this(isFile, left, right, false);
    }

    public Difference(boolean isFile, @Nullable Entry left, @Nullable Entry right, boolean isRightContentCurrent) {
        this.myIsFile = isFile;
        this.myLeft = left;
        this.myRight = right;
        this.myRightContentCurrent = isRightContentCurrent;
    }

    public boolean isFile() {
        return this.myIsFile;
    }

    public Entry getLeft() {
        return this.myLeft;
    }

    public Entry getRight() {
        return this.myRight;
    }

    public ContentRevision getLeftContentRevision(IdeaGateway gw) {
        return Difference.createContentRevision(this.getLeft(), gw);
    }

    public ContentRevision getRightContentRevision(IdeaGateway gw) {
        VirtualFile file;
        Entry entry2 = this.getRight();
        if (this.myRightContentCurrent && entry2 != null && (file = gw.findVirtualFile(entry2.getPath())) != null) {
            return new CurrentContentRevision(Paths.createDvcsFilePath(file));
        }
        return Difference.createContentRevision(entry2, gw);
    }

    private static ContentRevision createContentRevision(final @Nullable Entry e, final IdeaGateway gw) {
        if (e == null) {
            return null;
        }
        return new ByteBackedContentRevision(){

            @Override
            @Nullable
            public String getContent() {
                if (e.isDirectory()) {
                    return null;
                }
                return e.getContent().getString(e, gw);
            }

            @Override
            public byte @Nullable [] getContentAsBytes() {
                if (e.isDirectory()) {
                    return null;
                }
                return e.getContent().getBytes();
            }

            @Override
            @NotNull
            public FilePath getFile() {
                FilePath filePath = Paths.createDvcsFilePath(e.getPath(), e.isDirectory());
                if (filePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                return filePath;
            }

            @Override
            @NotNull
            public VcsRevisionNumber getRevisionNumber() {
                VcsRevisionNumber vcsRevisionNumber = VcsRevisionNumber.NULL;
                if (vcsRevisionNumber == null) {
                    1.$$$reportNull$$$0(1);
                }
                return vcsRevisionNumber;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/history/core/revisions/Difference$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRevisionNumber";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }
}

