/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CoverageAnnotator {
    @Nullable
    @Nls
    default public String getDirCoverageInformationString(@NotNull PsiDirectory psiDirectory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        if (psiDirectory == null) {
            CoverageAnnotator.$$$reportNull$$$0(0);
        }
        if (currentSuite == null) {
            CoverageAnnotator.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            CoverageAnnotator.$$$reportNull$$$0(2);
        }
        return this.getDirCoverageInformationString(psiDirectory.getProject(), psiDirectory.getVirtualFile(), currentSuite, manager);
    }

    @Nullable
    @Nls
    default public String getDirCoverageInformationString(@NotNull Project project2, @NotNull VirtualFile directory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        PsiDirectory psiDirectory;
        if (project2 == null) {
            CoverageAnnotator.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            CoverageAnnotator.$$$reportNull$$$0(4);
        }
        if (currentSuite == null) {
            CoverageAnnotator.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            CoverageAnnotator.$$$reportNull$$$0(6);
        }
        if ((psiDirectory = PsiManager.getInstance((Project)project2).findDirectory(directory)) == null) {
            return null;
        }
        return this.getDirCoverageInformationString(psiDirectory, currentSuite, manager);
    }

    @Nullable
    @Nls
    default public String getFileCoverageInformationString(@NotNull PsiFile psiFile2, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        if (psiFile2 == null) {
            CoverageAnnotator.$$$reportNull$$$0(7);
        }
        if (currentSuite == null) {
            CoverageAnnotator.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            CoverageAnnotator.$$$reportNull$$$0(9);
        }
        VirtualFile file = psiFile2.getVirtualFile();
        VirtualFile virtualFile = Objects.requireNonNullElse(file.getCanonicalFile(), file);
        return this.getFileCoverageInformationString(psiFile2.getProject(), virtualFile, currentSuite, manager);
    }

    @Nullable
    @Nls
    default public String getFileCoverageInformationString(@NotNull Project project2, @NotNull VirtualFile file, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        PsiFile psiFile2;
        if (project2 == null) {
            CoverageAnnotator.$$$reportNull$$$0(10);
        }
        if (file == null) {
            CoverageAnnotator.$$$reportNull$$$0(11);
        }
        if (currentSuite == null) {
            CoverageAnnotator.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            CoverageAnnotator.$$$reportNull$$$0(13);
        }
        if ((psiFile2 = PsiManager.getInstance((Project)project2).findFile(file)) == null) {
            return null;
        }
        return this.getFileCoverageInformationString(psiFile2, currentSuite, manager);
    }

    public void onSuiteChosen(@Nullable CoverageSuitesBundle var1);

    public void renewCoverageData(@NotNull CoverageSuitesBundle var1, @NotNull CoverageDataManager var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/CoverageAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirCoverageInformationString";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileCoverageInformationString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

