/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.stemmer;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.langs.utils.NamesKt;
import ai.grazie.nlp.stemmer.Stemmer;
import ai.grazie.nlp.stemmer.snowball.SnowballProgram;
import ai.grazie.nlp.stemmer.snowball.ext.EnglishStemmer;
import ai.grazie.nlp.stemmer.snowball.ext.GermanStemmer;
import ai.grazie.nlp.stemmer.snowball.ext.RussianStemmer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\b'\u0018\u0000 \b2\u00020\u00012\u00020\u0002:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H%J\u0010\u0010\u0004\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lai/grazie/nlp/stemmer/SnowballStemmer;", "Lai/grazie/nlp/stemmer/snowball/SnowballProgram;", "Lai/grazie/nlp/stemmer/Stemmer;", "()V", "stem", "", "", "word", "Companion", "nlp-stemmer"})
public abstract class SnowballStemmer
extends SnowballProgram
implements Stemmer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected abstract boolean stem();

    @Override
    @NotNull
    public synchronized String stem(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        this.setCurrent(word);
        this.stem();
        return this.getCurrent();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lai/grazie/nlp/stemmer/SnowballStemmer$Companion;", "", "()V", "load", "Lai/grazie/nlp/stemmer/Stemmer;", "language", "Lai/grazie/nlp/langs/Language;", "loadOrNull", "nlp-stemmer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Stemmer load(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Stemmer stemmer = this.loadOrNull(language);
            if (stemmer == null) {
                throw new IllegalStateException(("Language " + NamesKt.getEnglishName(language) + " is not supported by Snowball stemmer").toString());
            }
            return stemmer;
        }

        @Nullable
        public final Stemmer loadOrNull(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            return switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
                case 1 -> new RussianStemmer();
                case 2 -> new EnglishStemmer();
                case 3 -> new GermanStemmer();
                default -> null;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Language.values().length];
                try {
                    nArray[Language.RUSSIAN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Language.ENGLISH.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Language.GERMAN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

