/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader$special$;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderContent;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownImage;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownInlineLink;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkText;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElement;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElementType;
import org.intellij.plugins.markdown.structureView.MarkdownStructureColors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u001e\u001a\u00020\u001cH\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0015\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010'0&H\u0016\u00a2\u0006\u0002\u0010(J*\u0010)\u001a\u00020\u00172\n\u0010*\u001a\u00060+j\u0002`,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020 0.2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\u0018\u0010/\u001a\u00020\u0017*\u00060+j\u0002`,2\u0006\u00100\u001a\u000201H\u0002R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00063"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderImpl;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;", "type", "Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;", "(Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElement;Lorg/intellij/plugins/markdown/lang/stubs/impl/MarkdownHeaderStubElementType;)V", "anchorText", "", "getAnchorText", "()Ljava/lang/String;", "contentElement", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderContent;", "getContentElement", "()Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeaderContent;", "level", "", "getLevel", "()I", "accept", "", "visitor", "Lcom/intellij/psi/PsiElementVisitor;", "buildRawAnchorText", "includeStartingHash", "", "buildVisibleText", "hideImages", "findContentHolder", "Lcom/intellij/psi/PsiElement;", "getHeaderText", "getName", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getReferences", "", "Lcom/intellij/psi/PsiReference;", "()[Lcom/intellij/psi/PsiReference;", "traverseNameText", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "elements", "Lkotlin/sequences/Sequence;", "processInlineLink", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownInlineLink;", "Companion", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownHeader.kt\norg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,253:1\n473#2:254\n*S KotlinDebug\n*F\n+ 1 MarkdownHeader.kt\norg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader\n*L\n66#1:254\n*E\n"})
public final class MarkdownHeader
extends MarkdownHeaderImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex garbageRegex = new Regex("[^\\p{IsAlphabetic}\\d\\-_ ]");
    @NotNull
    private static final Regex ENTITY_REGEX = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));");

    public MarkdownHeader(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
    }

    public MarkdownHeader(@NotNull MarkdownHeaderStubElement stub, @NotNull MarkdownHeaderStubElementType type) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(stub, type);
    }

    public final int getLevel() {
        return this.calculateHeaderLevel();
    }

    @Nullable
    public final String getAnchorText() {
        return Companion.obtainAnchorText(this);
    }

    @Nullable
    public final MarkdownHeaderContent getContentElement() {
        PsiElement psiElement = (PsiElement)this;
        TokenSet tokenSet = MarkdownTokenTypeSets.HEADER_CONTENT;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"HEADER_CONTENT");
        Sequence<PsiElement> $this$filterIsInstance$iv = PsiUtilsKt.childrenOfType(psiElement, tokenSet);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)special$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (MarkdownHeaderContent)SequencesKt.firstOrNull((Sequence)sequence);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2 instanceof MarkdownElementVisitor) {
            ((MarkdownElementVisitor)visitor2).visitHeader(this);
        } else {
            super.accept(visitor2);
        }
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)((PsiElement)this));
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferencesFromProviders(...)");
        return psiReferenceArray;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        String headerText = this.getHeaderText();
        Object object = headerText;
        if (object == null) {
            object = "Invalid header: " + this.getText();
        }
        String text2 = object;
        return (ItemPresentation)new ColoredItemPresentation(this, text2){
            final /* synthetic */ MarkdownHeader this$0;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$text = $text;
            }

            @NotNull
            public String getPresentableText() {
                PsiElement prevSibling = this.this$0.getPrevSibling();
                if (Registry.is((String)"markdown.structure.view.list.visibility") && MarkdownTokenTypeSets.LIST_MARKERS.contains(PsiTreeUtilKt.getElementType((PsiElement)prevSibling))) {
                    return prevSibling.getText() + this.$text;
                }
                return this.$text;
            }

            @Nullable
            public Icon getIcon(boolean open) {
                return null;
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                return this.this$0.getLevel() == 1 ? MarkdownStructureColors.MARKDOWN_HEADER_BOLD : MarkdownStructureColors.MARKDOWN_HEADER;
            }
        };
    }

    @Nullable
    public String getName() {
        return this.getHeaderText();
    }

    private final PsiElement findContentHolder() {
        return this.findChildByType(MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES);
    }

    private final String getHeaderText() {
        if (!this.isValid()) {
            return null;
        }
        PsiElement psiElement = this.findContentHolder();
        if (psiElement == null) {
            return null;
        }
        PsiElement contentHolder = psiElement;
        return StringUtil.trim((String)contentHolder.getText());
    }

    @ApiStatus.Experimental
    @Nullable
    public final String buildVisibleText(boolean hideImages) {
        PsiElement psiElement = this.findContentHolder();
        if (psiElement == null) {
            return null;
        }
        PsiElement contentHolder = psiElement;
        StringBuilder builder = new StringBuilder();
        Sequence children2 = SequencesKt.dropWhile(PsiUtilsKt.children(contentHolder), (Function1)buildVisibleText.children.1.INSTANCE);
        this.traverseNameText(builder, (Sequence<? extends PsiElement>)children2, hideImages);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        char[] cArray = new char[]{' '};
        return StringsKt.trim((String)string, (char[])cArray);
    }

    public static /* synthetic */ String buildVisibleText$default(MarkdownHeader markdownHeader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return markdownHeader.buildVisibleText(bl);
    }

    private final void traverseNameText(StringBuilder builder, Sequence<? extends PsiElement> elements2, boolean hideImages) {
        for (PsiElement child2 : elements2) {
            PsiElement psiElement = child2;
            if (psiElement instanceof LeafPsiElement) {
                builder.append(((LeafPsiElement)child2).getText());
                continue;
            }
            if (psiElement instanceof MarkdownInlineLink) {
                MarkdownLinkText markdownLinkText = ((MarkdownInlineLink)child2).getLinkText();
                Object object = markdownLinkText != null ? markdownLinkText.getContentElements() : null;
                if (object == null) {
                    object = SequencesKt.emptySequence();
                }
                this.traverseNameText(builder, (Sequence<? extends PsiElement>)object, hideImages);
                continue;
            }
            if (psiElement instanceof MarkdownImage) {
                if (hideImages) continue;
                builder.append(((MarkdownImage)child2).getText());
                continue;
            }
            this.traverseNameText(builder, PsiUtilsKt.children(child2), hideImages);
        }
    }

    private final String buildRawAnchorText(boolean includeStartingHash) {
        String string;
        StringBuilder stringBuilder;
        PsiElement psiElement = this.findContentHolder();
        if (psiElement == null) {
            return null;
        }
        PsiElement contentHolder = psiElement;
        Sequence children2 = SequencesKt.dropWhile(PsiUtilsKt.children(contentHolder), (Function1)buildRawAnchorText.children.1.INSTANCE);
        StringBuilder $this$buildRawAnchorText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (includeStartingHash) {
            $this$buildRawAnchorText_u24lambda_u240.append("#");
        }
        int count = 0;
        for (PsiElement child2 : children2) {
            TokenSet tokenSet = MarkdownTokenTypeSets.WHITE_SPACES;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"WHITE_SPACES");
            if (PsiUtilsKt.hasType(child2, tokenSet)) {
                $this$buildRawAnchorText_u24lambda_u240.append(" ");
                continue;
            }
            PsiElement psiElement2 = child2;
            if (psiElement2 instanceof MarkdownImage) {
                $this$buildRawAnchorText_u24lambda_u240.append("");
            } else if (psiElement2 instanceof MarkdownInlineLink) {
                this.processInlineLink($this$buildRawAnchorText_u24lambda_u240, (MarkdownInlineLink)child2);
            } else {
                $this$buildRawAnchorText_u24lambda_u240.append(child2.getText());
            }
            ++count;
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String text2 = string2;
        String string3 = Companion.replaceEntities(text2).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        CharSequence charSequence = string3;
        Regex regex = garbageRegex;
        String string4 = "";
        String replaced = StringsKt.replace$default((String)regex.replace(charSequence, string4), (String)" ", (String)"-", (boolean)false, (int)4, null);
        if (AdvancedSettings.Companion.getBoolean("markdown.squash.multiple.dashes.in.header.anchors")) {
            charSequence = replaced;
            regex = new Regex("-{2,}");
            string4 = "-";
            string = regex.replace(charSequence, string4);
        } else {
            string = replaced;
        }
        return string;
    }

    static /* synthetic */ String buildRawAnchorText$default(MarkdownHeader markdownHeader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return markdownHeader.buildRawAnchorText(bl);
    }

    private final void processInlineLink(StringBuilder $this$processInlineLink, MarkdownInlineLink element2) {
        MarkdownLinkText markdownLinkText = element2.getLinkText();
        Object object = markdownLinkText != null ? markdownLinkText.getContentElements() : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        Sequence contentElements2 = object;
        Sequence withoutWhitespaces2 = SequencesKt.filterNot((Sequence)contentElements2, (Function1)processInlineLink.withoutWhitespaces.1.INSTANCE);
        SequencesKt.joinTo$default((Sequence)withoutWhitespaces2, (Appendable)$this$processInlineLink, (CharSequence)" ", null, null, (int)0, null, (Function1)processInlineLink.1.INSTANCE, (int)60, null);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final String createUniqueAnchorText(@NotNull String rawAnchorText, int occurenceNumber) {
        return Companion.createUniqueAnchorText(rawAnchorText, occurenceNumber);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader$Companion;", "", "()V", "ENTITY_REGEX", "Lkotlin/text/Regex;", "garbageRegex", "getGarbageRegex$intellij_markdown_core", "()Lkotlin/text/Regex;", "buildUniqueAnchorText", "", "header", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "calculateUniqueNumber", "", "rawAnchorText", "createUniqueAnchorText", "occurenceNumber", "obtainAnchorText", "obtainRawAnchorText", "replaceEntities", "text", "", "intellij.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nMarkdownHeader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownHeader.kt\norg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n766#2:254\n857#2,2:255\n959#2,7:257\n800#2,11:264\n*S KotlinDebug\n*F\n+ 1 MarkdownHeader.kt\norg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader$Companion\n*L\n207#1:254\n207#1:255,2\n208#1:257,7\n204#1:264,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getGarbageRegex$intellij_markdown_core() {
            return garbageRegex;
        }

        private final String buildUniqueAnchorText(MarkdownHeader header) {
            String string = this.obtainRawAnchorText(header);
            if (string == null) {
                return null;
            }
            String anchorText = string;
            int number = this.calculateUniqueNumber(header, anchorText);
            return this.createUniqueAnchorText(anchorText, number);
        }

        /*
         * WARNING - void declaration
         */
        private final int calculateUniqueNumber(MarkdownHeader header, String rawAnchorText) {
            void $this$filterTo$iv$iv;
            PsiFile psiFile = header.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiFile file = psiFile;
            List headers2 = (List)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file), () -> Companion.calculateUniqueNumber$lambda$0(file));
            Intrinsics.checkNotNull((Object)headers2);
            Iterable $this$filter$iv = headers2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MarkdownHeader it = (MarkdownHeader)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)Companion.obtainRawAnchorText(it), (Object)rawAnchorText)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sameHeaders2 = (List)destination$iv$iv;
            Iterable $this$takeWhile$iv = sameHeaders2;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                MarkdownHeader it = (MarkdownHeader)item$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)header))) break;
                list$iv.add(item$iv);
            }
            return ((Collection)list$iv).size();
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final String createUniqueAnchorText(@NotNull String rawAnchorText, int occurenceNumber) {
            Intrinsics.checkNotNullParameter((Object)rawAnchorText, (String)"rawAnchorText");
            return occurenceNumber == 0 ? rawAnchorText : rawAnchorText + "-" + occurenceNumber;
        }

        @Nullable
        public final String obtainAnchorText(@NotNull MarkdownHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            return (String)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)header), () -> Companion.obtainAnchorText$lambda$3(header));
        }

        private final String obtainRawAnchorText(MarkdownHeader header) {
            return (String)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)header), () -> Companion.obtainRawAnchorText$lambda$4(header));
        }

        @NotNull
        public final String replaceEntities(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return ENTITY_REGEX.replace(text2, (Function1)replaceEntities.1.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        private static final CachedValueProvider.Result calculateUniqueNumber$lambda$0(PsiFile $file) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)$file));
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
            Iterable $this$filterIsInstance$iv = (Iterable)syntaxTraverser;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MarkdownHeader)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)((List)destination$iv$iv), (Object[])objectArray);
        }

        private static final CachedValueProvider.Result obtainAnchorText$lambda$3(MarkdownHeader $header) {
            Intrinsics.checkNotNullParameter((Object)$header, (String)"$header");
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)Companion.buildUniqueAnchorText($header), (Object[])objectArray);
        }

        private static final CachedValueProvider.Result obtainRawAnchorText$lambda$4(MarkdownHeader $header) {
            Intrinsics.checkNotNullParameter((Object)$header, (String)"$header");
            Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)$header.buildRawAnchorText(false), (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

