/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang;

import com.intellij.lang.Language;
import com.intellij.psi.tree.IElementType;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.MarkdownLazyElementType;
import org.intellij.plugins.markdown.lang.stubs.impl.MarkdownHeaderStubElementType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownElementType
extends IElementType {
    @NotNull
    private static final Map<org.intellij.markdown.IElementType, IElementType> markdownToPlatformTypeMap = new ConcurrentHashMap<org.intellij.markdown.IElementType, IElementType>();
    @NotNull
    private static final Map<IElementType, org.intellij.markdown.IElementType> platformToMarkdownTypeMap = new ConcurrentHashMap<IElementType, org.intellij.markdown.IElementType>();

    public MarkdownElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            MarkdownElementType.$$$reportNull$$$0(0);
        }
        super(debugName, (Language)MarkdownLanguage.INSTANCE);
    }

    public String toString() {
        return MessageFormat.format("Markdown:{0}", super.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null -> null; !null -> !null")
    public static IElementType platformType(@Nullable org.intellij.markdown.IElementType markdownType) {
        if (markdownType == null) {
            return null;
        }
        if (markdownToPlatformTypeMap.containsKey(markdownType)) {
            return markdownToPlatformTypeMap.get(markdownType);
        }
        Map<IElementType, org.intellij.markdown.IElementType> map = platformToMarkdownTypeMap;
        synchronized (map) {
            return markdownToPlatformTypeMap.computeIfAbsent(markdownType, type -> {
                Object result2 = type == MarkdownElementTypes.PARAGRAPH || type == MarkdownTokenTypes.ATX_CONTENT || type == MarkdownTokenTypes.SETEXT_CONTENT || type == GFMTokenTypes.CELL ? new MarkdownLazyElementType(type.toString()) : (MarkdownElementType.isHeaderElementType(type) ? new MarkdownHeaderStubElementType(type.toString()) : new MarkdownElementType(type.toString()));
                platformToMarkdownTypeMap.put((IElementType)result2, (org.intellij.markdown.IElementType)type);
                return result2;
            });
        }
    }

    @ApiStatus.Internal
    public static boolean isHeaderElementType(@NotNull org.intellij.markdown.IElementType markdownType) {
        if (markdownType == null) {
            MarkdownElementType.$$$reportNull$$$0(1);
        }
        return markdownType == MarkdownElementTypes.ATX_1 || markdownType == MarkdownElementTypes.ATX_2 || markdownType == MarkdownElementTypes.ATX_3 || markdownType == MarkdownElementTypes.ATX_4 || markdownType == MarkdownElementTypes.ATX_5 || markdownType == MarkdownElementTypes.ATX_6 || markdownType == MarkdownElementTypes.SETEXT_1 || markdownType == MarkdownElementTypes.SETEXT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="!null -> !null")
    public static org.intellij.markdown.IElementType markdownType(@Nullable IElementType platformType) {
        if (platformType == null) {
            return null;
        }
        org.intellij.markdown.IElementType result2 = platformToMarkdownTypeMap.get(platformType);
        if (result2 != null) {
            return result2;
        }
        Map<IElementType, org.intellij.markdown.IElementType> map = platformToMarkdownTypeMap;
        synchronized (map) {
            return platformToMarkdownTypeMap.get(platformType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markdownType";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/lang/MarkdownElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isHeaderElementType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

