/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cef.misc.CefPdfPrintSettings;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionFormat;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownFileEditorUtils;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0016J0\u0010\u0011\u001a\u00020\b*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownPdfExportProvider;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "()V", "formatDescription", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormatDescription", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "exportFile", "", "project", "Lcom/intellij/openapi/project/Project;", "mdFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "outputFile", "", "validate", "file", "savePdf", "Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;", "path", "resultCallback", "Ljava/util/function/BiConsumer;", "", "Companion", "intellij.markdown.core"})
public final class MarkdownPdfExportProvider
implements MarkdownExportProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MarkdownFileActionFormat format = new MarkdownFileActionFormat("PDF", "pdf");

    @Override
    @NotNull
    public MarkdownFileActionFormat getFormatDescription() {
        return format;
    }

    @Override
    public void exportFile(@NotNull Project project, @NotNull VirtualFile mdFile, @NotNull String outputFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mdFile, (String)"mdFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        MarkdownPreviewFileEditor markdownPreviewFileEditor = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, mdFile, true);
        if (markdownPreviewFileEditor == null) {
            return;
        }
        MarkdownPreviewFileEditor preview = markdownPreviewFileEditor;
        Object object = (WeakReference)preview.getUserData(MarkdownPreviewFileEditor.PREVIEW_BROWSER);
        if (object == null || (object = (MarkdownHtmlPanel)((Reference)object).get()) == null) {
            return;
        }
        Object htmlPanel = object;
        if (htmlPanel instanceof MarkdownJCEFHtmlPanel) {
            this.savePdf((MarkdownJCEFHtmlPanel)htmlPanel, outputFile, project, (arg_0, arg_1) -> MarkdownPdfExportProvider.exportFile$lambda$0(project, arg_0, arg_1));
        }
    }

    @Override
    @Nullable
    public String validate(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MarkdownPreviewFileEditor preview = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, file, true);
        if (preview == null || !MarkdownImportExportUtils.INSTANCE.isJCEFPanelOpen(preview)) {
            Object[] objectArray = new Object[]{this.getFormatDescription().getFormatName()};
            return MarkdownBundle.message("markdown.export.validation.failure.msg", objectArray);
        }
        return null;
    }

    private final void savePdf(MarkdownJCEFHtmlPanel $this$savePdf, String path, Project project, BiConsumer<String, Boolean> resultCallback) {
        $this$savePdf.getCefBrowser().printToPDF(path, new CefPdfPrintSettings(), (arg_0, arg_1) -> MarkdownPdfExportProvider.savePdf$lambda$1(path, project, resultCallback, arg_0, arg_1));
    }

    private static final void exportFile$lambda$0(Project $project, String path, Boolean ok) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)ok, (String)"ok");
        if (ok.booleanValue()) {
            VirtualFile file = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
            if (file != null) {
                MarkdownImportExportUtils.INSTANCE.notifyAndRefreshIfExportSuccess(file, $project);
            }
        } else {
            Object[] objectArray = new Object[]{new File(path).getName()};
            String string = MarkdownBundle.message("markdown.export.failure.msg", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, $project, "markdown.export.failed", null, string, 4, null);
        }
    }

    private static final void savePdf$lambda$1(String $path, Project $project, BiConsumer $resultCallback, String string, boolean ok) {
        VirtualFile dirToExport;
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$resultCallback, (String)"$resultCallback");
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File($path), (boolean)false);
        Object object = dirToExport = virtualFile != null ? virtualFile.getParent() : null;
        if (dirToExport != null) {
            String string2 = dirToExport.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            MarkdownImportExportUtils.INSTANCE.refreshProjectDirectory($project, string2);
        }
        $resultCallback.accept($path, ok);
    }

    @NotNull
    public static final MarkdownFileActionFormat getFormat() {
        return Companion.getFormat();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownPdfExportProvider$Companion;", "", "()V", "format", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormat$annotations", "getFormat", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarkdownFileActionFormat getFormat() {
            return format;
        }

        @JvmStatic
        public static /* synthetic */ void getFormat$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

