/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.highlighter;

import com.intellij.lang.Language;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.text.TextRangeUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.extensions.common.highlighter.HighlightedRange;
import org.intellij.plugins.markdown.lang.psi.util.MarkdownAstUtilsKt;
import org.intellij.plugins.markdown.ui.preview.html.ASTUtilsKt;
import org.intellij.plugins.markdown.ui.preview.html.DefaultCodeFenceGeneratingProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\u001aF\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bH\u0000\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a;\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00012 \b\u0004\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u0012H\u0082\b\u001a&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0002\u001a\u00020\u00012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002\u001aJ\u0010\u001a\u001a\u00020\u00102\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bH\u0002\u001a\u001c\u0010 \u001a\u00060\u001cj\u0002`\u001d*\u00060\u001cj\u0002`\u001d2\u0006\u0010!\u001a\u00020\u0016H\u0002\u001a\u0016\u0010\u0019\u001a\u00020\"*\u00020\"2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0014\u0010#\u001a\u00020\"*\u00020\"2\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180%*\u00020&2\b\b\u0002\u0010'\u001a\u00020\tH\u0002\u001a\u0014\u0010(\u001a\u00020\"*\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006)"}, d2={"buildHighlightedFenceContent", "", "text", "highlightedRanges", "", "Lorg/intellij/plugins/markdown/extensions/common/highlighter/HighlightedRange;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "useAbsoluteOffsets", "", "additionalLineProcessor", "Lkotlin/Function1;", "collectHighlightedChunks", "language", "Lcom/intellij/lang/Language;", "collectHighlights", "", "consumer", "Lkotlin/Function3;", "Lkotlin/ranges/IntRange;", "Ljava/awt/Color;", "createSpan", "Lcom/intellij/openapi/util/text/HtmlChunk;", "range", "Lcom/intellij/openapi/util/TextRange;", "color", "processLines", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "contentOffset", "", "appendChunk", "chunk", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "escapedText", "lineRanges", "Lkotlin/sequences/Sequence;", "", "includeDelimiter", "sourceRange", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nFenceHighlighting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FenceHighlighting.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/FenceHighlightingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n22#1,6:158\n1#2:164\n179#3,2:165\n766#4:167\n857#4,2:168\n*S KotlinDebug\n*F\n+ 1 FenceHighlighting.kt\norg/intellij/plugins/markdown/extensions/common/highlighter/FenceHighlightingKt\n*L\n40#1:158,6\n67#1:165,2\n88#1:167\n88#1:168,2\n*E\n"})
public final class FenceHighlightingKt {
    private static final void collectHighlights(Language language, String text2, Function3<? super String, ? super IntRange, ? super Color, Unit> consumer) {
        boolean $i$f$collectHighlights = false;
        HtmlSyntaxHighlighter.Companion.parseContent(null, language, text2, (Function3)new Function3<String, IntRange, Color, Unit>(consumer){
            final /* synthetic */ Function3<String, IntRange, Color, Unit> $consumer;
            {
                this.$consumer = $consumer;
                super(3);
            }

            public final void invoke(@NotNull String content2, @NotNull IntRange range, @Nullable Color color) {
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                if (color != null) {
                    this.$consumer.invoke((Object)content2, (Object)range, (Object)color);
                }
            }
        });
    }

    @NotNull
    public static final List<HighlightedRange> collectHighlightedChunks(@NotNull Language language, @NotNull String text2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List $this$collectHighlightedChunks_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        boolean $i$f$collectHighlights = false;
        HtmlSyntaxHighlighter.Companion.parseContent(null, language, text2, (Function3)new Function3<String, IntRange, Color, Unit>($this$collectHighlightedChunks_u24lambda_u241){
            final /* synthetic */ List $this_buildList$inlined;
            {
                this.$this_buildList$inlined = list2;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String content2, @NotNull IntRange range, @Nullable Color color) {
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                if (color != null) {
                    void color2;
                    Color color3 = color;
                    IntRange range2 = range;
                    boolean bl = false;
                    this.$this_buildList$inlined.add(new HighlightedRange(new TextRange(range2.getFirst(), range2.getLast()), (Color)color2));
                }
            }
        });
        return CollectionsKt.build((List)list2);
    }

    @NotNull
    public static final String buildHighlightedFenceContent(@NotNull String text2, @NotNull List<HighlightedRange> highlightedRanges, @NotNull ASTNode node, boolean useAbsoluteOffsets, @Nullable Function1<? super String, String> additionalLineProcessor) {
        Object v0;
        StringBuilder builder;
        block6: {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(highlightedRanges, (String)"highlightedRanges");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            int contentBaseOffset = DefaultCodeFenceGeneratingProvider.Companion.calculateCodeFenceContentBaseOffset$intellij_markdown_core(node);
            if (!(contentBaseOffset >= node.getStartOffset())) {
                boolean $i$a$-check-FenceHighlightingKt$buildHighlightedFenceContent$32 = false;
                String $i$a$-check-FenceHighlightingKt$buildHighlightedFenceContent$32 = "Content base offset should not be before fence start";
                throw new IllegalStateException($i$a$-check-FenceHighlightingKt$buildHighlightedFenceContent$32.toString());
            }
            builder = new StringBuilder();
            int fenceStartOffset = useAbsoluteOffsets ? node.getStartOffset() : 0;
            int contentOffset = useAbsoluteOffsets ? contentBaseOffset : contentBaseOffset - node.getStartOffset();
            if (!(contentOffset >= fenceStartOffset)) {
                boolean $i$a$-check-FenceHighlightingKt$buildHighlightedFenceContent$42 = false;
                String $i$a$-check-FenceHighlightingKt$buildHighlightedFenceContent$42 = "Content offset should not be before fence start";
                throw new IllegalStateException($i$a$-check-FenceHighlightingKt$buildHighlightedFenceContent$42.toString());
            }
            FenceHighlightingKt.appendChunk(builder, FenceHighlightingKt.createSpan$default(new TextRange(fenceStartOffset, contentOffset), null, null, 6, null));
            FenceHighlightingKt.processLines(builder, highlightedRanges, text2, contentOffset, additionalLineProcessor);
            Sequence<ASTNode> $this$firstOrNull$iv = ASTUtilsKt.children(node);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!MarkdownAstUtilsKt.hasType(it, MarkdownTokenTypes.CODE_FENCE_END)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        ASTNode closingDelimiter = v0;
        if (closingDelimiter != null) {
            TextRange textRange;
            TextRange range = MarkdownAstUtilsKt.getTextRange(closingDelimiter);
            if (useAbsoluteOffsets) {
                textRange = range;
            } else {
                TextRange textRange2 = range.shiftLeft(node.getStartOffset());
                textRange = textRange2;
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftLeft(...)");
            }
            TextRange actualRange = textRange;
            FenceHighlightingKt.appendChunk(builder, FenceHighlightingKt.createSpan$default(actualRange, null, null, 6, null));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String buildHighlightedFenceContent$default(String string, List list2, ASTNode aSTNode, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        return FenceHighlightingKt.buildHighlightedFenceContent(string, list2, aSTNode, bl, (Function1<? super String, String>)function1);
    }

    private static final void processLines(StringBuilder builder, List<HighlightedRange> highlightedRanges, String text2, int contentOffset, Function1<? super String, String> additionalLineProcessor) {
        for (TextRange lineRange : FenceHighlightingKt.lineRanges(text2, true)) {
            HighlightedRange $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = highlightedRanges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                HighlightedRange highlightedRange = (HighlightedRange)element$iv$iv;
                boolean bl = false;
                TextRange range = highlightedRange.component1();
                if (!lineRange.intersects(range)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List ranges2 = (List)destination$iv$iv;
            if (ranges2.isEmpty()) {
                TextRange textRange = lineRange.shiftRight(contentOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                String string = lineRange.substring(text2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                HtmlChunk span = FenceHighlightingKt.createSpan$default(textRange, string, null, 4, null);
                FenceHighlightingKt.appendChunk(builder, span);
                continue;
            }
            int left = lineRange.getStartOffset();
            for (HighlightedRange $this$filterTo$iv$iv2 : ranges2) {
                HtmlChunk span;
                TextRange range;
                TextRange range2 = $this$filterTo$iv$iv2.component1();
                Color color = $this$filterTo$iv$iv2.component2();
                int start = Math.max(left, range2.getStartOffset());
                int end = Math.min(lineRange.getEndOffset(), range2.getEndOffset());
                if (start != left) {
                    range = new TextRange(left, start);
                    TextRange textRange = range.shiftRight(contentOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                    String string = range.substring(text2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    span = FenceHighlightingKt.createSpan$default(textRange, string, null, 4, null);
                    FenceHighlightingKt.appendChunk(builder, span);
                }
                if (end - start > 0 && !(range = new TextRange(start, end)).isEmpty()) {
                    TextRange textRange = range.shiftRight(contentOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                    String string = range.substring(text2);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    span = FenceHighlightingKt.createSpan(textRange, string, color);
                    FenceHighlightingKt.appendChunk(builder, span);
                }
                left = end;
            }
            if (left != lineRange.getEndOffset()) {
                TextRange range = new TextRange(left, lineRange.getEndOffset());
                TextRange textRange = range.shiftRight(contentOffset);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
                String string = range.substring(text2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                HtmlChunk span = FenceHighlightingKt.createSpan$default(textRange, string, null, 4, null);
                FenceHighlightingKt.appendChunk(builder, span);
            }
            if (additionalLineProcessor == null) continue;
            String string = lineRange.substring(text2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String processed = (String)additionalLineProcessor.invoke((Object)string);
            builder.append(processed);
        }
    }

    static /* synthetic */ void processLines$default(StringBuilder stringBuilder, List list2, String string, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            function1 = null;
        }
        FenceHighlightingKt.processLines(stringBuilder, list2, string, n, (Function1<? super String, String>)function1);
    }

    private static final Sequence<TextRange> lineRanges(CharSequence $this$lineRanges, boolean includeDelimiter) {
        return TextRangeUtils.splitToTextRanges((CharSequence)$this$lineRanges, (String)"\n", (boolean)includeDelimiter);
    }

    static /* synthetic */ Sequence lineRanges$default(CharSequence charSequence, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return FenceHighlightingKt.lineRanges(charSequence, bl);
    }

    private static final HtmlChunk createSpan(TextRange range, String text2, Color color) {
        HtmlChunk.Element element2 = HtmlChunk.span();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"span(...)");
        HtmlChunk.Element span = FenceHighlightingKt.sourceRange(element2, range);
        if (((CharSequence)text2).length() == 0 && color == null) {
            return (HtmlChunk)span;
        }
        return (HtmlChunk)FenceHighlightingKt.color(FenceHighlightingKt.escapedText(span, text2), color);
    }

    static /* synthetic */ HtmlChunk createSpan$default(TextRange textRange, String string, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            color = null;
        }
        return FenceHighlightingKt.createSpan(textRange, string, color);
    }

    private static final StringBuilder appendChunk(StringBuilder $this$appendChunk, HtmlChunk chunk) {
        chunk.appendTo($this$appendChunk);
        return $this$appendChunk;
    }

    private static final HtmlChunk.Element sourceRange(HtmlChunk.Element $this$sourceRange, TextRange range) {
        HtmlChunk.Element element2 = $this$sourceRange.attr(HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME(), range.getStartOffset() + ".." + range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"attr(...)");
        return element2;
    }

    private static final HtmlChunk.Element escapedText(HtmlChunk.Element $this$escapedText, String text2) {
        HtmlChunk.Element element2 = $this$escapedText.addRaw(DefaultCodeFenceGeneratingProvider.Companion.escape$intellij_markdown_core(text2));
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"addRaw(...)");
        return element2;
    }

    private static final HtmlChunk.Element color(HtmlChunk.Element $this$color, Color color) {
        if (color == null) {
            return $this$color;
        }
        String string = ColorUtil.toHtmlColor((Color)color);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        String value = string;
        HtmlChunk.Element element2 = $this$color.style("color: " + value + ";");
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"style(...)");
        return element2;
    }
}

