/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/FontStyleExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "priority", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "getPriority", "()Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Priority;", "resourceProvider", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "styles", "", "", "getStyles", "()Ljava/util/List;", "canProvide", "", "resourceName", "dispose", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "Companion", "Provider", "intellij.markdown.core"})
public final class FontStyleExtension
implements MarkdownBrowserPreviewExtension,
ResourceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<String> styles;
    @NotNull
    private final ResourceProvider resourceProvider;

    public FontStyleExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.styles = CollectionsKt.listOf((Object)"font/font-settings.css");
        this.resourceProvider = this;
    }

    @Override
    @NotNull
    public MarkdownBrowserPreviewExtension.Priority getPriority() {
        return MarkdownBrowserPreviewExtension.Priority.AFTER_ALL;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.getStyles().contains(resourceName);
    }

    @Override
    @NotNull
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        String css;
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        MarkdownSettings settings = MarkdownSettings.Companion.getInstance(this.project);
        String string = settings.getFontFamily();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        String string3 = css = FontStyleExtension.Companion.getFontSizeCss(settings.getFontSize(), string);
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return new ResourceProvider.Resource(byArray, null, 2, null);
    }

    public void dispose() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/FontStyleExtension$Companion;", "", "()V", "getFontSizeCss", "", "fontSize", "", "fontFamily", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getFontSizeCss(int fontSize, String fontFamily) {
            return StringsKt.trimIndent((String)("\n        div { \n          font-size: " + fontSize + "px !important; \n          font-family: " + fontFamily + " !important; \n        }\n      "));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/FontStyleExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "()V", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.markdown.core"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @Override
        @Nullable
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            Project project = panel2.getProject();
            if (project == null) {
                return null;
            }
            Project project2 = project;
            return new FontStyleExtension(project2);
        }
    }
}

