/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.AbstractGradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.AllInPackageGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public class AllInDirectoryGradleConfigurationProducer
extends AbstractGradleTestRunConfigurationProducer<PsiElement, PsiElement> {
    @Override
    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (other == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(1);
        }
        return !other.isProducedBy(AllInPackageGradleConfigurationProducer.class) && super.isPreferredConfiguration(self, other);
    }

    @Override
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (other == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(3);
        }
        return !other.isProducedBy(AllInPackageGradleConfigurationProducer.class) && super.shouldReplace(self, other);
    }

    @Override
    @Nullable
    protected PsiElement getElement(@NotNull ConfigurationContext context) {
        PsiElement psiElement;
        if (context == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((psiElement = context.getPsiLocation()) instanceof PsiFileSystemItem && ((PsiFileSystemItem)psiElement).isDirectory()) {
            return psiElement;
        }
        return null;
    }

    @Override
    @NotNull
    protected String getLocationName(@NotNull ConfigurationContext context, @NotNull PsiElement element) {
        if (context == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (element == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(6);
        }
        Module module2 = Objects.requireNonNull(context.getModule());
        String string = String.format("'%s'", module2.getName());
        if (string == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected String suggestConfigurationName(@NotNull ConfigurationContext context, @NotNull PsiElement element, @NotNull List<? extends PsiElement> chosenElements) {
        if (context == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (element == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (chosenElements == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(10);
        }
        Module module2 = Objects.requireNonNull(context.getModule());
        String string = ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{module2.getName()});
        if (string == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    protected void chooseSourceElements(@NotNull ConfigurationContext context, @NotNull PsiElement element, @NotNull Consumer<List<PsiElement>> onElementsChosen) {
        if (context == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (element == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (onElementsChosen == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(14);
        }
        onElementsChosen.accept(Collections.emptyList());
    }

    @Override
    @NotNull
    protected List<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> getAllTestsTaskToRun(@NotNull ConfigurationContext context, @NotNull PsiElement element, @NotNull List<? extends PsiElement> chosenElements) {
        if (context == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (element == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (chosenElements == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(17);
        }
        Project project = Objects.requireNonNull(context.getProject());
        Module module2 = Objects.requireNonNull(context.getModule());
        VirtualFile directory = ((PsiFileSystemItem)element).getVirtualFile();
        List<VirtualFile> sources = AllInDirectoryGradleConfigurationProducer.findTestSourcesUnderDirectory(module2, directory);
        String testFilter = GradleExecutionSettingsUtil.createTestWildcardFilter();
        ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> testsTasksToRun = new ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun>();
        for (VirtualFile source : sources) {
            testsTasksToRun.addAll(ContainerUtil.map(AllInDirectoryGradleConfigurationProducer.findAllTestsTaskToRun(source, project), it -> new AbstractGradleTestRunConfigurationProducer.TestTasksToRun((TasksToRun)it, testFilter)));
        }
        ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> arrayList = testsTasksToRun;
        if (arrayList == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static List<VirtualFile> findTestSourcesUnderDirectory(@NotNull Module module2, @NotNull VirtualFile directory) {
        DataNode moduleDataNode;
        if (module2 == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(19);
        }
        if (directory == null) {
            AllInDirectoryGradleConfigurationProducer.$$$reportNull$$$0(20);
        }
        if ((moduleDataNode = GradleUtil.findGradleModuleData((Module)module2)) == null) {
            return Collections.emptyList();
        }
        String rootPath = directory.getPath();
        return ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TEST).stream().map(DataNode::getData).flatMap(it -> it.getSourceFolders().stream()).filter(it -> FileUtil.isAncestor((String)rootPath, (String)it, (boolean)false)).map(it -> VfsUtil.findFile((Path)Paths.get(it, new String[0]), (boolean)false)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/AllInDirectoryGradleConfigurationProducer";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenElements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onElementsChosen";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/AllInDirectoryGradleConfigurationProducer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestConfigurationName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTestsTaskToRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPreferredConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocationName";
                break;
            }
            case 7: 
            case 11: 
            case 18: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "chooseSourceElements";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllTestsTaskToRun";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findTestSourcesUnderDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 18 -> new IllegalStateException(string);
        };
    }
}

