/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.task.ExecuteRunConfigurationTask;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.GradleBaseApplicationEnvironmentProvider;
import org.jetbrains.plugins.gradle.execution.build.GradleInitScriptParameters;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider;", "Lcom/intellij/execution/application/ApplicationConfiguration;", "()V", "generateInitScript", "", "params", "Lorg/jetbrains/plugins/gradle/execution/build/GradleInitScriptParameters;", "isApplicable", "", "task", "Lcom/intellij/task/ExecuteRunConfigurationTask;", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleApplicationEnvironmentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleApplicationEnvironmentProvider.kt\norg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,206:1\n10#2:207\n*S KotlinDebug\n*F\n+ 1 GradleApplicationEnvironmentProvider.kt\norg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider\n*L\n203#1:207\n*E\n"})
public class GradleApplicationEnvironmentProvider
extends GradleBaseApplicationEnvironmentProvider<ApplicationConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public boolean isApplicable(@NotNull ExecuteRunConfigurationTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return task.getRunProfile() instanceof ApplicationConfiguration;
    }

    @Override
    @Nullable
    public String generateInitScript(@NotNull GradleInitScriptParameters params) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        ShortenCommandLine shortenCommandLine = params.getConfiguration().getShortenCommandLine();
        boolean useManifestJar = shortenCommandLine == ShortenCommandLine.MANIFEST;
        boolean useArgsFile = shortenCommandLine == ShortenCommandLine.ARGS_FILE;
        boolean useClasspathFile = shortenCommandLine == ShortenCommandLine.CLASSPATH_FILE;
        String intelliJRtPath = null;
        if (useClasspathFile) {
            try {
                intelliJRtPath = FileUtil.toCanonicalPath((String)PathManager.getJarPathForClass(Class.forName("com.intellij.rt.execution.CommandLineWrapper")));
            }
            catch (Throwable t) {
                LOG.warn("Unable to use classpath file", t);
                useClasspathFile = false;
            }
        }
        String initScript = "\n    def gradlePath = '" + params.getGradleTaskPath() + "'\n    def runAppTaskName = '" + params.getRunAppTaskName() + "'\n    def mainClassToRun = '" + params.getMainClass() + "'\n    def javaExePath = mapPath('" + params.getJavaExePath() + "')\n    def _workingDir = " + (String)((charSequence = (CharSequence)params.getWorkingDirectory()) == null || charSequence.length() == 0 ? "null\n" : "mapPath('" + params.getWorkingDirectory() + "')\n") + "\n    def sourceSetName = '" + params.getSourceSetName() + "'\n    def javaModuleName = " + (String)(params.getJavaModuleName() == null ? "null\n" : "'" + params.getJavaModuleName() + "'\n") + "\n    def isOlderThan64 = GradleVersion.current().baseVersion < GradleVersion.version(\"6.4\")\n    def isOlderThan33 = GradleVersion.current().baseVersion < GradleVersion.version(\"3.3\")\n    " + (useManifestJar ? "gradle.addListener(new ManifestTaskActionListener(runAppTaskName))\n" : "") + "\n    " + (useArgsFile ? "gradle.addListener(new ArgFileTaskActionListener(runAppTaskName))\n" : "") + "\n    " + (String)(useClasspathFile && intelliJRtPath != null ? "gradle.addListener(new ClasspathFileTaskActionListener(runAppTaskName, mainClassToRun, mapPath('" + intelliJRtPath + "')))\n " : "") + "\n\n    import org.gradle.util.GradleVersion\n\n    allprojects {\n      afterEvaluate { project ->\n        def projectPath\n        if (isOlderThan33) {\n          projectPath = project.path\n        } else {\n          projectPath = project.identityPath.toString()\n        }\n        if(projectPath == gradlePath && project?.convention?.findPlugin(JavaPluginConvention)) {\n          def overwrite = project.tasks.findByName(runAppTaskName) != null\n          project.tasks.create(name: runAppTaskName, overwrite: overwrite, type: JavaExec) {\n            if (javaExePath) executable = javaExePath\n            if (isOlderThan64) {\n              main = mainClassToRun\n            } else {\n              mainClass = mainClassToRun\n            }\n            " + params.getParams() + "\n            if (_workingDir) workingDir = _workingDir\n            standardInput = System.in\n            if (javaModuleName) {\n              classpath = tasks[sourceSets[sourceSetName].jarTaskName].outputs.files + project.sourceSets[sourceSetName].runtimeClasspath;\n              if (isOlderThan64) {\n                doFirst {\n                  jvmArgs += [\n                    '--module-path', classpath.asPath,\n                    '--module', javaModuleName + '/' + mainClassToRun\n                  ]\n                  classpath = files()\n                }\n              } else {\n                mainModule = javaModuleName\n              }\n            } else {\n              classpath = project.sourceSets[sourceSetName].runtimeClasspath\n            }\n          }\n        }\n      }\n    }\n    " + (useManifestJar || useArgsFile || useClasspathFile ? "\n    import org.gradle.api.execution.TaskActionListener\n    import org.gradle.api.Task\n    import org.gradle.api.tasks.JavaExec\n    abstract class RunAppTaskActionListener implements TaskActionListener {\n      String myTaskName\n      File myClasspathFile\n      RunAppTaskActionListener(String taskName) {\n        myTaskName = taskName\n      }\n      void beforeActions(Task task) {\n        if(!(task instanceof JavaExec) || task.name != myTaskName) return\n        myClasspathFile = patchTaskClasspath(task)\n      }\n      void afterActions(Task task) {\n        if(myClasspathFile != null) { myClasspathFile.delete() }\n      }\n      abstract File patchTaskClasspath(JavaExec task)\n    }\n    " : "") + (useManifestJar ? "\n\n    import org.gradle.api.tasks.JavaExec\n    import java.util.jar.Attributes\n    import java.util.jar.JarOutputStream\n    import java.util.jar.Manifest\n    import java.util.zip.ZipEntry\n    class ManifestTaskActionListener extends RunAppTaskActionListener {\n      ManifestTaskActionListener(String taskName) {\n         super(taskName)\n      }\n      File patchTaskClasspath(JavaExec task) {\n        Manifest manifest = new Manifest()\n        Attributes attributes = manifest.getMainAttributes()\n        attributes.put(Attributes.Name.MANIFEST_VERSION, '1.0')\n        attributes.putValue('Class-Path', task.classpath.files.collect {it.toURI().toURL().toString()}.join(' '))\n        File file = File.createTempFile('generated-', '-manifest')\n        def oStream = new JarOutputStream(new FileOutputStream(file), manifest)\n        oStream.putNextEntry(new ZipEntry('META-INF/'))\n        oStream.close()\n        task.classpath = task.project.files(file.getAbsolutePath())\n        return file\n      }\n    }\n    " : "") + (useArgsFile ? "\n\n    import org.gradle.api.tasks.JavaExec\n    import org.gradle.process.CommandLineArgumentProvider\n    class ArgFileTaskActionListener extends RunAppTaskActionListener {\n      ArgFileTaskActionListener(String taskName) {\n         super(taskName)\n      }\n      File patchTaskClasspath(JavaExec task) {\n        File file = File.createTempFile('generated-', '-argFile')\n        def writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file), 'UTF-8'))\n        def lineSep = System.getProperty('line.separator')\n        writer.print('-classpath' + lineSep)\n        writer.print(quoteArg(task.classpath.asPath))\n        writer.print(lineSep)\n        writer.close()\n        task.jvmArgs('@' + file.absolutePath)\n        task.classpath = task.project.files([])\n        return file\n      }\n      private static String quoteArg(String arg) {\n        String specials = ' #\\'\\\"\\n\\r\\t\\f'\n        if (specials.find { arg.indexOf(it) != -1 } == null) return arg\n        StringBuilder sb = new StringBuilder(arg.length() * 2)\n        for (int i = 0; i < arg.length(); i++) {\n          char c = arg.charAt(i)\n          if (c == ' ' as char || c == '#' as char || c == '\\'' as char) sb.append('\"').append(c).append('\"')\n          else if (c == '\"' as char) sb.append(\"\\\"\\\\\\\"\\\"\")\n          else if (c == '\\n' as char) sb.append(\"\\\"\\\\n\\\"\")\n          else if (c == '\\r' as char) sb.append(\"\\\"\\\\r\\\"\")\n          else if (c == '\\t' as char) sb.append(\"\\\"\\\\t\\\"\")\n          else if (c == '\\f' as char) sb.append(\"\\\"\\\\f\\\"\")\n          else sb.append(c)\n        }\n        return sb.toString()\n      }}\n    " : "") + (useClasspathFile ? "\n\n    import org.gradle.api.tasks.JavaExec\n    import org.gradle.process.CommandLineArgumentProvider\n    class ClasspathFileTaskActionListener extends RunAppTaskActionListener {\n      String myMainClass\n      String myIntelliJRtPath\n      ClasspathFileTaskActionListener(String taskName, String mainClass, String intelliJRtPath) {\n         super(taskName)\n         myMainClass = mainClass\n         myIntelliJRtPath = intelliJRtPath\n      }\n      File patchTaskClasspath(JavaExec task) {\n        File file = File.createTempFile('generated-', '-classpathFile')\n        def writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file), 'UTF-8'))\n        task.classpath.files.each { writer.println(it.path) }\n        writer.close()\n        List args = [file.absolutePath, myMainClass] as List\n        args.addAll(task.args)\n        task.args = []\n        task.argumentProviders.add({ return args } as CommandLineArgumentProvider)\n        task.main = 'com.intellij.rt.execution.CommandLineWrapper'\n        task.classpath = task.project.files([myIntelliJRtPath])\n        return file\n      }\n    }\n    " : "");
        return initScript;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleApplicationEnvironmentProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/gradle/execution/build/GradleApplicationEnvironmentProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

