/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.tracker;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.completion.ml.personalization.session.CompletionSelectionTrackerImpl;
import com.intellij.completion.ml.personalization.session.ElementSessionFactorsStorage;
import com.intellij.completion.ml.storage.LookupStorage;
import com.intellij.completion.ml.util.LookupElementExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/completion/ml/tracker/LookupSelectionTracker;", "Lcom/intellij/codeInsight/lookup/LookupListener;", "storage", "Lcom/intellij/completion/ml/storage/LookupStorage;", "(Lcom/intellij/completion/ml/storage/LookupStorage;)V", "currentElementStorage", "Lcom/intellij/completion/ml/personalization/session/ElementSessionFactorsStorage;", "currentItemChanged", "", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "lookupShown", "selectionChanged", "intellij.completionMlRanking"})
public final class LookupSelectionTracker
implements LookupListener {
    @NotNull
    private final LookupStorage storage;
    @Nullable
    private ElementSessionFactorsStorage currentElementStorage;

    public LookupSelectionTracker(@NotNull LookupStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
    }

    public void lookupShown(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.selectionChanged(event);
    }

    public void currentItemChanged(@NotNull LookupEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.selectionChanged(event);
    }

    private final void selectionChanged(LookupEvent event) {
        LookupElement lookupElement = event.getItem();
        if (lookupElement != null) {
            ElementSessionFactorsStorage elementStorage = this.storage.getItemStorage(LookupElementExtensionsKt.idString(lookupElement)).getSessionFactors();
            if (Intrinsics.areEqual((Object)elementStorage, (Object)this.currentElementStorage)) {
                return;
            }
            elementStorage.getSelectionTracker().itemSelected();
            Object object = this.currentElementStorage;
            if (object != null && (object = ((ElementSessionFactorsStorage)object).getSelectionTracker()) != null) {
                ((CompletionSelectionTrackerImpl)object).itemUnselected();
            }
            this.currentElementStorage = elementStorage;
        }
    }
}

