/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.ranker.local;

import com.intellij.completion.ml.ranker.local.DecisionFunctionWithLanguages;
import com.intellij.completion.ml.ranker.local.LocalZipModelProvider;
import com.intellij.internal.ml.DecisionFunction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.io.Closeable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsLoader;", "", "registryPathKey", "", "(Ljava/lang/String;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "localModel", "Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsLoader$LocalModalInfo;", "getModel", "Lcom/intellij/internal/ml/DecisionFunction;", "languageId", "synchronous", "", "initModelFromPathToZipSynchronously", "", "isPathToTheModelChanged", "isPathToTheModelSet", "loadModel", "pathToZip", "scheduleInitModel", "Ljava/util/concurrent/Future;", "Companion", "LocalModalInfo", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nMLCompletionLocalModelsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLCompletionLocalModelsLoader.kt\ncom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n10#2:80\n*S KotlinDebug\n*F\n+ 1 MLCompletionLocalModelsLoader.kt\ncom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsLoader\n*L\n76#1:80\n*E\n"})
public final class MLCompletionLocalModelsLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String registryPathKey;
    @NotNull
    private final ExecutorService executor;
    @Nullable
    private volatile LocalModalInfo localModel;
    @NotNull
    private static final Logger LOG;

    public MLCompletionLocalModelsLoader(@NotNull String registryPathKey) {
        Intrinsics.checkNotNullParameter((Object)registryPathKey, (String)"registryPathKey");
        this.registryPathKey = registryPathKey;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"MLCompletionTxtModelsUtil pool executor");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createSequentialApplicationPoolExecutor(...)");
        this.executor = executorService;
    }

    @Nullable
    public final DecisionFunction getModel(@NotNull String languageId, boolean synchronous) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        if (!this.isPathToTheModelSet()) {
            this.localModel = null;
            return null;
        }
        if (this.isPathToTheModelChanged()) {
            if (synchronous) {
                this.initModelFromPathToZipSynchronously();
                LocalModalInfo localModalInfo = this.localModel;
                return localModalInfo != null ? localModalInfo.getDecisionFunction() : null;
            }
            this.scheduleInitModel();
            return null;
        }
        LocalModalInfo localModalInfo = this.localModel;
        if (localModalInfo == null) {
            return null;
        }
        LocalModalInfo resLocalModel = localModalInfo;
        Set<String> set = resLocalModel.getLanguages();
        String string = languageId;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return set.contains(string2) ? resLocalModel.getDecisionFunction() : null;
    }

    public static /* synthetic */ DecisionFunction getModel$default(MLCompletionLocalModelsLoader mLCompletionLocalModelsLoader, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return mLCompletionLocalModelsLoader.getModel(string, bl);
    }

    private final Future<?> scheduleInitModel() {
        Future<?> future = this.executor.submit(() -> MLCompletionLocalModelsLoader.scheduleInitModel$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    private final boolean isPathToTheModelSet() {
        return Registry.get((String)this.registryPathKey).isChangedFromDefault();
    }

    private final boolean isPathToTheModelChanged() {
        LocalModalInfo localModalInfo = this.localModel;
        return !Intrinsics.areEqual((Object)Registry.stringValue((String)this.registryPathKey), (Object)(localModalInfo != null ? localModalInfo.getPath() : null));
    }

    private final void initModelFromPathToZipSynchronously() {
        this.localModel = null;
        long startTime = System.currentTimeMillis();
        String string = Registry.stringValue((String)this.registryPathKey);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        String pathToZip = string;
        this.localModel = this.loadModel(pathToZip);
        long endTime = System.currentTimeMillis();
        LOG.info("ML Completion local model initialization took: " + (endTime - startTime) + " ms.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LocalModalInfo loadModel(String pathToZip) {
        try {
            Closeable closeable = new ZipFile(pathToZip);
            Throwable throwable = null;
            try {
                LocalZipModelProvider localZipModelProvider;
                ZipFile file = (ZipFile)closeable;
                boolean bl = false;
                if (LocalZipModelProvider.Companion.findModelProvider(file) == null) {
                    LocalModalInfo localModalInfo = null;
                    return localModalInfo;
                }
                LocalZipModelProvider loader = localZipModelProvider;
                DecisionFunctionWithLanguages decisionFunctionWithLanguages = loader.loadModel(file);
                DecisionFunction decisionFunction = decisionFunctionWithLanguages.component1();
                List<String> languages = decisionFunctionWithLanguages.component2();
                LocalModalInfo localModalInfo = new LocalModalInfo(decisionFunction, pathToZip, CollectionsKt.toSet((Iterable)languages));
                return localModalInfo;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Throwable t) {
            LOG.error(t);
            return null;
        }
    }

    private static final void scheduleInitModel$lambda$0(MLCompletionLocalModelsLoader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.initModelFromPathToZipSynchronously();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MLCompletionLocalModelsLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsLoader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.completionMlRanking"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/completion/ml/ranker/local/MLCompletionLocalModelsLoader$LocalModalInfo;", "", "decisionFunction", "Lcom/intellij/internal/ml/DecisionFunction;", "path", "", "languages", "", "(Lcom/intellij/internal/ml/DecisionFunction;Ljava/lang/String;Ljava/util/Set;)V", "getDecisionFunction", "()Lcom/intellij/internal/ml/DecisionFunction;", "getLanguages", "()Ljava/util/Set;", "getPath", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.completionMlRanking"})
    private static final class LocalModalInfo {
        @NotNull
        private final DecisionFunction decisionFunction;
        @NotNull
        private final String path;
        @NotNull
        private final Set<String> languages;

        public LocalModalInfo(@NotNull DecisionFunction decisionFunction, @NotNull String path, @NotNull Set<String> languages) {
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            this.decisionFunction = decisionFunction;
            this.path = path;
            this.languages = languages;
        }

        @NotNull
        public final DecisionFunction getDecisionFunction() {
            return this.decisionFunction;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Set<String> getLanguages() {
            return this.languages;
        }

        @NotNull
        public final DecisionFunction component1() {
            return this.decisionFunction;
        }

        @NotNull
        public final String component2() {
            return this.path;
        }

        @NotNull
        public final Set<String> component3() {
            return this.languages;
        }

        @NotNull
        public final LocalModalInfo copy(@NotNull DecisionFunction decisionFunction, @NotNull String path, @NotNull Set<String> languages) {
            Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(languages, (String)"languages");
            return new LocalModalInfo(decisionFunction, path, languages);
        }

        public static /* synthetic */ LocalModalInfo copy$default(LocalModalInfo localModalInfo, DecisionFunction decisionFunction, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                decisionFunction = localModalInfo.decisionFunction;
            }
            if ((n & 2) != 0) {
                string = localModalInfo.path;
            }
            if ((n & 4) != 0) {
                set = localModalInfo.languages;
            }
            return localModalInfo.copy(decisionFunction, string, set);
        }

        @NotNull
        public String toString() {
            return "LocalModalInfo(decisionFunction=" + this.decisionFunction + ", path=" + this.path + ", languages=" + this.languages + ")";
        }

        public int hashCode() {
            int result = this.decisionFunction.hashCode();
            result = result * 31 + this.path.hashCode();
            result = result * 31 + ((Object)this.languages).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocalModalInfo)) {
                return false;
            }
            LocalModalInfo localModalInfo = (LocalModalInfo)other;
            if (!Intrinsics.areEqual((Object)this.decisionFunction, (Object)localModalInfo.decisionFunction)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)localModalInfo.path)) {
                return false;
            }
            return Intrinsics.areEqual(this.languages, localModalInfo.languages);
        }
    }
}

