/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.experiment;

import com.intellij.completion.ml.experiment.ExperimentConfig;
import com.intellij.completion.ml.experiment.ExperimentGroupConfig;
import com.intellij.completion.ml.experiment.ExperimentInfo;
import com.intellij.completion.ml.experiment.ExperimentLanguageConfig;
import com.intellij.completion.ml.experiment.ExperimentStatus;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.ResourceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/completion/ml/experiment/ClientExperimentStatus;", "Lcom/intellij/completion/ml/experiment/ExperimentStatus;", "()V", "experimentConfig", "Lcom/intellij/completion/ml/experiment/ExperimentConfig;", "experimentGroupRegistryValue", "", "Ljava/lang/Integer;", "isDisabledByEvaluation", "", "languageToGroup", "", "", "Lcom/intellij/completion/ml/experiment/ExperimentInfo;", "disable", "", "findMatchingLanguage", "language", "Lcom/intellij/lang/Language;", "forLanguage", "getBucketsMapping", "", "seed", "", "(Ljava/lang/Long;)Ljava/util/List;", "isDisabled", "setDisabled", "value", "Companion", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nClientExperimentStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientExperimentStatus.kt\ncom/intellij/completion/ml/experiment/ClientExperimentStatus\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1#2:118\n766#3:119\n857#3,2:120\n1747#3,3:122\n*S KotlinDebug\n*F\n+ 1 ClientExperimentStatus.kt\ncom/intellij/completion/ml/experiment/ClientExperimentStatus\n*L\n107#1:119\n107#1:120,2\n109#1:122,3\n*E\n"})
public final class ClientExperimentStatus
implements ExperimentStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExperimentConfig experimentConfig = Companion.loadExperimentInfo();
    @NotNull
    private final Map<String, ExperimentInfo> languageToGroup = new HashMap();
    private final boolean isDisabledByEvaluation;
    @Nullable
    private Integer experimentGroupRegistryValue;
    @NotNull
    private static final String EXPERIMENT_DISABLED_PROPERTY_KEY = "ml.completion.experiment.disabled";
    @NotNull
    private static final String EXPERIMENT_DISABLED_BY_EVALUATION_ENV = "EVALUATION_ML_EXPERIMENT_DISABLED";

    public ClientExperimentStatus() {
        Object object = System.getenv(EXPERIMENT_DISABLED_BY_EVALUATION_ENV);
        this.isDisabledByEvaluation = object != null && (object = StringsKt.toBooleanStrictOrNull((String)object)) != null ? (Boolean)object : false;
        List<Integer> bucketsMapping = this.getBucketsMapping(this.experimentConfig.getSeed());
        EventLogConfiguration eventLogConfiguration = EventLogConfiguration.Companion.getInstance();
        for (ExperimentLanguageConfig languageSettings : this.experimentConfig.getLanguages()) {
            Object v1;
            block2: {
                int bucket = ((Number)bucketsMapping.get(eventLogConfiguration.getBucket())).intValue() % languageSettings.getExperimentBucketsCount();
                int groupNumber = languageSettings.getIncludeGroups().size() > bucket ? ((Number)languageSettings.getIncludeGroups().get(bucket)).intValue() : this.experimentConfig.getVersion();
                Iterable iterable = this.experimentConfig.getGroups();
                for (Object t : iterable) {
                    ExperimentGroupConfig it = (ExperimentGroupConfig)t;
                    boolean bl = false;
                    if (!(it.getNumber() == groupNumber)) continue;
                    v1 = t;
                    break block2;
                }
                v1 = null;
            }
            ExperimentGroupConfig group = v1;
            ExperimentInfo groupInfo = group == null ? new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, false, 60, null) : new ExperimentInfo(true, group.getNumber(), group.getUseMLRanking(), group.getShowArrows(), group.getCalculateFeatures(), languageSettings.getShouldLogElementFeatures());
            this.languageToGroup.put(languageSettings.getId(), groupInfo);
        }
    }

    @Override
    @NotNull
    public ExperimentInfo forLanguage(@NotNull Language language) {
        ExperimentInfo experimentInfo;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (ApplicationManager.getApplication().isUnitTestMode() || this.isDisabledByEvaluation) {
            return new ExperimentInfo(false, 0, false, false, false, false, 60, null);
        }
        String string = this.findMatchingLanguage(language);
        if (string == null) {
            return new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, false, 60, null);
        }
        String matchingLanguage = string;
        RegistryValue registryValue = Registry.get((String)"completion.ml.override.experiment.group.number");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"get(...)");
        RegistryValue experimentGroupRegistry = registryValue;
        if (experimentGroupRegistry.isChangedFromDefault() && !experimentGroupRegistry.isChangedSinceAppStart()) {
            this.experimentGroupRegistryValue = experimentGroupRegistry.asInteger();
        }
        if (this.experimentGroupRegistryValue != null) {
            Object v3;
            block7: {
                Iterable iterable = this.experimentConfig.getGroups();
                for (Object t : iterable) {
                    ExperimentGroupConfig it = (ExperimentGroupConfig)t;
                    boolean bl = false;
                    Integer n = this.experimentGroupRegistryValue;
                    if (!(n != null && it.getNumber() == n.intValue())) continue;
                    v3 = t;
                    break block7;
                }
                v3 = null;
            }
            ExperimentGroupConfig group = v3;
            if (group != null) {
                this.setDisabled(false);
                return new ExperimentInfo(true, group.getNumber(), group.getUseMLRanking(), group.getShowArrows(), group.getCalculateFeatures(), true);
            }
        }
        if ((experimentInfo = this.languageToGroup.get(matchingLanguage)) == null) {
            experimentInfo = new ExperimentInfo(false, this.experimentConfig.getVersion(), false, false, false, false, 60, null);
        }
        return experimentInfo;
    }

    @Override
    public void disable() {
        if (ApplicationManager.getApplication().isEAP()) {
            this.setDisabled(true);
        }
    }

    @Override
    public boolean isDisabled() {
        return PropertiesComponent.getInstance().isTrueValue(EXPERIMENT_DISABLED_PROPERTY_KEY) || this.isDisabledByEvaluation;
    }

    private final void setDisabled(boolean value) {
        PropertiesComponent.getInstance().setValue(EXPERIMENT_DISABLED_PROPERTY_KEY, value);
    }

    /*
     * WARNING - void declaration
     */
    private final String findMatchingLanguage(Language language) {
        Object v2;
        block6: {
            void $this$filterTo$iv$iv;
            Collection collection = Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Language it = (Language)element$iv$iv;
                boolean bl = false;
                if (!language.isKindOf(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List baseLanguages = (List)destination$iv$iv;
            Iterable iterable2 = this.languageToGroup.keySet();
            for (Object e : iterable2) {
                boolean bl;
                block5: {
                    String languageId = (String)e;
                    boolean bl2 = false;
                    Iterable $this$any$iv = baseLanguages;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Language it = (Language)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.equals((String)languageId, (String)it.getID(), (boolean)true)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = e;
                break block6;
            }
            v2 = null;
        }
        return v2;
    }

    private final List<Integer> getBucketsMapping(Long seed) {
        IntRange buckets = RangesKt.until((int)0, (int)256);
        return seed == null ? CollectionsKt.toList((Iterable)((Iterable)buckets)) : CollectionsKt.shuffled((Iterable)((Iterable)buckets), (Random)new Random(seed));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ml/experiment/ClientExperimentStatus$Companion;", "", "()V", "EXPERIMENT_DISABLED_BY_EVALUATION_ENV", "", "EXPERIMENT_DISABLED_PROPERTY_KEY", "checkExperimentGroups", "", "experimentInfo", "Lcom/intellij/completion/ml/experiment/ExperimentConfig;", "loadExperimentInfo", "intellij.completionMlRanking"})
    @SourceDebugExtension(value={"SMAP\nClientExperimentStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientExperimentStatus.kt\ncom/intellij/completion/ml/experiment/ClientExperimentStatus$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n10#2:118\n1#3:119\n1726#4,2:120\n1747#4,3:122\n1728#4:125\n*S KotlinDebug\n*F\n+ 1 ClientExperimentStatus.kt\ncom/intellij/completion/ml/experiment/ClientExperimentStatus$Companion\n*L\n33#1:118\n46#1:120,2\n47#1:122,3\n46#1:125\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExperimentConfig loadExperimentInfo() {
            try {
                if (!ApplicationManager.getApplication().isEAP()) {
                    return ExperimentConfig.Companion.disabledExperiment();
                }
                byte[] byArray = ResourceUtil.getResourceAsBytes((String)"experiment.json", (ClassLoader)ClientExperimentStatus.class.getClassLoader());
                Intrinsics.checkNotNull((Object)byArray);
                byte[] data = byArray;
                ExperimentConfig experimentInfo = (ExperimentConfig)Json.Default.decodeFromString((DeserializationStrategy)ExperimentConfig.Companion.serializer(), new String(data, Charsets.UTF_8));
                this.checkExperimentGroups(experimentInfo);
                return experimentInfo;
            }
            catch (Throwable e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ClientExperimentStatus.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Error on loading ML Completion experiment info", e);
                return ExperimentConfig.Companion.disabledExperiment();
            }
        }

        private final void checkExperimentGroups(ExperimentConfig experimentInfo) {
            boolean bl;
            for (ExperimentGroupConfig group : experimentInfo.getGroups()) {
                if (group.getShowArrows()) {
                    bl = group.getUseMLRanking();
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$42 = false;
                        String $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$42 = "Showing arrows requires ML ranking";
                        throw new AssertionError((Object)$i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$42);
                    }
                }
                if (!group.getUseMLRanking()) continue;
                bl = group.getCalculateFeatures();
                if (!_Assertions.ENABLED || bl) continue;
                boolean $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$62 = false;
                String $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$62 = "ML ranking requires calculating features";
                throw new AssertionError((Object)$i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$62);
            }
            for (ExperimentLanguageConfig language : experimentInfo.getLanguages()) {
                block12: {
                    boolean bl2 = bl = language.getIncludeGroups().size() <= language.getExperimentBucketsCount();
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$72 = false;
                        String $i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$72 = "Groups count must be less than the total number of buckets (" + language.getId() + ")";
                        throw new AssertionError((Object)$i$a$-assert-ClientExperimentStatus$Companion$checkExperimentGroups$72);
                    }
                    Iterable $this$all$iv = language.getIncludeGroups();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v1 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            boolean bl3;
                            block11: {
                                int number = ((Number)element$iv).intValue();
                                boolean bl4 = false;
                                Iterable $this$any$iv = experimentInfo.getGroups();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl3 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv) {
                                        ExperimentGroupConfig it = (ExperimentGroupConfig)element$iv2;
                                        boolean bl5 = false;
                                        if (!(it.getNumber() == number)) continue;
                                        bl3 = true;
                                        break block11;
                                    }
                                    bl3 = false;
                                }
                            }
                            if (bl3) continue;
                            v1 = false;
                            break block12;
                        }
                        v1 = bl = true;
                    }
                }
                if (!_Assertions.ENABLED || bl) continue;
                boolean bl6 = false;
                String string = "Group included for language (" + language.getId() + ") should be among general list of groups";
                throw new AssertionError((Object)string);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

