/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u001f\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/completion/ml/common/LocationFeaturesUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "indentLevel", "", "line", "", "tabSize", "linesDiff", "completionParameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "completionElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/codeInsight/completion/CompletionParameters;Lcom/intellij/psi/PsiElement;)Ljava/lang/Integer;", "intellij.completionMlRanking"})
public final class LocationFeaturesUtil {
    @NotNull
    public static final LocationFeaturesUtil INSTANCE = new LocationFeaturesUtil();
    @NotNull
    private static final Logger LOG;

    private LocationFeaturesUtil() {
    }

    public final int indentLevel(@NotNull String line, int tabSize) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (tabSize <= 0) {
            return 0;
        }
        int indentLevel = 0;
        int spaces = 0;
        int n = line.length();
        for (int i = 0; i < n; ++i) {
            char ch = line.charAt(i);
            if (spaces == tabSize) {
                ++indentLevel;
                spaces = 0;
            }
            if (ch == '\t') {
                ++indentLevel;
                spaces = 0;
                continue;
            }
            if (ch != ' ') break;
            ++spaces;
        }
        return indentLevel;
    }

    @Nullable
    public final Integer linesDiff(@NotNull CompletionParameters completionParameters, @Nullable PsiElement completionElement) {
        Intrinsics.checkNotNullParameter((Object)completionParameters, (String)"completionParameters");
        if (completionElement == null) {
            return null;
        }
        try {
            Integer elementOffset;
            PsiFile psiFile = completionElement.getContainingFile();
            if (Intrinsics.areEqual((Object)psiFile, (Object)completionParameters.getPosition().getContainingFile())) {
                int n;
                if (completionElement.getTextOffset() >= completionParameters.getPosition().getTextOffset()) {
                    int completionDiff = completionElement.getContainingFile().getTextLength() - completionParameters.getOriginalFile().getTextLength();
                    n = completionElement.getTextOffset() - completionDiff;
                } else {
                    n = completionElement.getTextOffset();
                }
                v1 = n;
            } else {
                v1 = elementOffset = Intrinsics.areEqual((Object)psiFile, (Object)completionParameters.getOriginalFile()) ? Integer.valueOf(completionElement.getTextOffset()) : null;
            }
            if (elementOffset == null || elementOffset < 0) {
                return null;
            }
            int completionLine = completionParameters.getEditor().getCaretModel().getPrimaryCaret().getLogicalPosition().line;
            int elementLine = completionParameters.getEditor().getDocument().getLineNumber(elementOffset.intValue());
            return completionLine - elementLine;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("Error while calculating lines diff", e);
            return null;
        }
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

