/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.DeprecatedProjectBuilderForImport;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectOpenProcessor;
import icons.OpenapiIcons;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.project.actions.LookForNestedToggleAction;
import org.jetbrains.idea.maven.utils.FileFinder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenProjectAsyncBuilder;
import org.jetbrains.idea.maven.wizards.MavenProjectOpenProcessor;

public final class MavenProjectBuilder
extends ProjectImportBuilder<MavenProject>
implements DeprecatedProjectBuilderForImport {
    private static final Logger LOG = Logger.getInstance(MavenProjectBuilder.class);
    private Parameters myParameters;

    @NotNull
    public String getName() {
        String string = MavenProjectBundle.message("maven.name", new Object[0]);
        if (string == null) {
            MavenProjectBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    public void cleanup() {
        this.myParameters = null;
        super.cleanup();
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    private Parameters getParameters() {
        if (this.myParameters == null) {
            this.myParameters = new Parameters();
        }
        return this.myParameters;
    }

    public VirtualFile getProjectFileToImport() {
        VirtualFile projectFile = this.getParameters().myImportProjectFile;
        if (null != projectFile) {
            return projectFile;
        }
        Path importRootDirectory = this.getParameters().myImportRootDirectory;
        if (null != importRootDirectory) {
            return VirtualFileManager.getInstance().findFileByNioPath(importRootDirectory);
        }
        return null;
    }

    private List<Module> commitWithAsyncBuilder(Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        VirtualFile projectFile = this.getProjectFileToImport();
        if (null == projectFile) {
            LOG.warn("Project file missing");
            return List.of();
        }
        IdeUIModifiableModelsProvider modelsProvider = null;
        if (model != null) {
            modelsProvider = new IdeUIModifiableModelsProvider(project2, model, (ModulesConfigurator)modulesProvider, artifactModel);
        }
        return new MavenProjectAsyncBuilder().commitSync(project2, projectFile, (IdeModifiableModelsProvider)modelsProvider);
    }

    public List<Module> commit(Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        return this.commitWithAsyncBuilder(project2, model, modulesProvider, artifactModel);
    }

    @Deprecated(forRemoval=true)
    public boolean setRootDirectory(@Nullable Project projectToUpdate, @NotNull String root) {
        if (root == null) {
            MavenProjectBuilder.$$$reportNull$$$0(1);
        }
        return this.setRootDirectory(projectToUpdate, Paths.get(root, new String[0]));
    }

    public boolean setRootDirectory(@Nullable Project projectToUpdate, final @NotNull Path root) {
        if (root == null) {
            MavenProjectBuilder.$$$reportNull$$$0(2);
        }
        this.getParameters().myFiles = null;
        this.getParameters().myMavenProjectTree = null;
        this.getParameters().myProjectToUpdate = projectToUpdate != null ? projectToUpdate : ProjectManager.getInstance().getDefaultProject();
        return MavenProjectBuilder.runConfigurationProcess(MavenProjectBundle.message("maven.scanning.projects", new Object[0]), new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                indicator.setText(MavenProjectBundle.message("maven.locating.files", new Object[0]));
                MavenProjectBuilder.this.getParameters().myImportRootDirectory = root;
                if (MavenProjectBuilder.this.getParameters().myImportRootDirectory == null) {
                    throw new MavenProcessCanceledException();
                }
                MavenProjectBuilder.this.getParameters().myFiles = MavenProjectBuilder.this.getProjectFiles(indicator);
                MavenProjectBuilder.this.readMavenProjectTree(indicator);
                indicator.setText("");
                indicator.setText2("");
            }
        });
    }

    private static boolean runConfigurationProcess(@NlsContexts.DialogTitle String message, MavenTask p) {
        try {
            MavenUtil.run(message, p);
        }
        catch (MavenProcessCanceledException e) {
            return false;
        }
        return true;
    }

    private void readMavenProjectTree(MavenProgressIndicator process) {
        MavenProjectsTree tree = new MavenProjectsTree(this.getProjectOrDefault());
        tree.addManagedFilesWithProfiles(this.getParameters().myFiles, MavenExplicitProfiles.NONE);
        tree.updateAll(false, this.getGeneralSettings(), process.getIndicator());
        this.getParameters().myMavenProjectTree = tree;
        this.getParameters().mySelectedProjects = tree.getRootProjects();
    }

    public List<MavenProject> getList() {
        return this.getParameters().myMavenProjectTree.getRootProjects();
    }

    public void setList(List<MavenProject> projects) {
        this.getParameters().mySelectedProjects = projects;
    }

    public boolean isMarked(MavenProject element) {
        return this.getParameters().mySelectedProjects.contains(element);
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().myOpenModulesConfigurator;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
        this.getParameters().myOpenModulesConfigurator = on;
    }

    private MavenGeneralSettings getGeneralSettings() {
        if (this.getParameters().myGeneralSettingsCache == null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                this.getParameters().myGeneralSettingsCache = this.getDirectProjectsSettings().getGeneralSettings().clone();
                List<VirtualFile> rootFiles = this.getParameters().myFiles;
                if (rootFiles == null) {
                    rootFiles = Collections.singletonList(LocalFileSystem.getInstance().findFileByNioFile(this.getRootPath()));
                }
                this.getParameters().myGeneralSettingsCache.updateFromMavenConfig(rootFiles);
            });
        }
        return this.getParameters().myGeneralSettingsCache;
    }

    public MavenImportingSettings getImportingSettings() {
        if (this.getParameters().myImportingSettingsCache == null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                this.getParameters().myImportingSettingsCache = this.getDirectProjectsSettings().getImportingSettings().clone();
            });
        }
        return this.getParameters().myImportingSettingsCache;
    }

    private MavenWorkspaceSettings getDirectProjectsSettings() {
        Project project2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project3 = project2 = this.isUpdate() ? this.getProjectToUpdate() : null;
        if (project2 == null || project2.isDisposed()) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return MavenWorkspaceSettingsComponent.getInstance(project2).getSettings();
    }

    public void setFiles(List<VirtualFile> files2) {
        this.getParameters().myFiles = files2;
    }

    @Nullable
    public Project getProjectToUpdate() {
        if (this.getParameters().myProjectToUpdate == null) {
            this.getParameters().myProjectToUpdate = MavenProjectBuilder.getCurrentProject();
        }
        return this.getParameters().myProjectToUpdate;
    }

    @NotNull
    public Project getProjectOrDefault() {
        Project project2 = this.getProjectToUpdate();
        if (project2 == null || project2.isDisposed()) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        Project project3 = project2;
        if (project3 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(3);
        }
        return project3;
    }

    @Nullable
    public Path getRootPath() {
        if (this.getParameters().myImportRootDirectory == null && this.isUpdate()) {
            Project project2 = this.getProjectToUpdate();
            this.getParameters().myImportRootDirectory = project2 == null ? null : Paths.get(Objects.requireNonNull(project2.getBasePath()), new String[0]);
        }
        return this.getParameters().myImportRootDirectory;
    }

    public void setFileToImport(@NotNull String path2) {
        if (path2 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(4);
        }
        this.setFileToImport(Paths.get(path2, new String[0]));
    }

    public void setFileToImport(@NotNull Path path2) {
        if (path2 == null) {
            MavenProjectBuilder.$$$reportNull$$$0(5);
        }
        this.getParameters().myImportRootDirectory = Files.isDirectory(path2, new LinkOption[0]) ? path2 : path2.getParent();
    }

    public void setFileToImport(@NotNull VirtualFile file) {
        if (file == null) {
            MavenProjectBuilder.$$$reportNull$$$0(6);
        }
        if (!file.isDirectory()) {
            this.getParameters().myImportProjectFile = file;
        }
        this.getParameters().myImportRootDirectory = file.isDirectory() ? file.toNioPath() : file.getParent().toNioPath();
    }

    @Nullable
    public Project createProject(String name, String path2) {
        Project project2 = super.createProject(name, path2);
        if (project2 != null) {
            ExternalProjectsManagerImpl.setupCreatedProject((Project)project2);
            project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)true);
        }
        return project2;
    }

    @NotNull
    public ProjectOpenProcessor getProjectOpenProcessor() {
        ProjectOpenProcessor projectOpenProcessor = (ProjectOpenProcessor)ProjectOpenProcessor.EXTENSION_POINT_NAME.findExtensionOrFail(MavenProjectOpenProcessor.class);
        if (projectOpenProcessor == null) {
            MavenProjectBuilder.$$$reportNull$$$0(7);
        }
        return projectOpenProcessor;
    }

    private List<VirtualFile> getProjectFiles(@NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        VirtualFile virtualFile;
        if (indicator == null) {
            MavenProjectBuilder.$$$reportNull$$$0(8);
        }
        if (this.getParameters().myImportProjectFile != null) {
            return Collections.singletonList(this.getParameters().myImportProjectFile);
        }
        Path file = this.getRootPath();
        VirtualFile virtualFile2 = virtualFile = file == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)file.toString()));
        if (virtualFile == null) {
            throw new MavenProcessCanceledException();
        }
        return FileFinder.findPomFiles(virtualFile.getChildren(), LookForNestedToggleAction.isSelected(), indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/wizards/MavenProjectBuilder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/wizards/MavenProjectBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOrDefault";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOpenProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRootDirectory";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFileToImport";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProjectFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 8 -> new IllegalArgumentException(string);
        };
    }

    private static class Parameters {
        private Project myProjectToUpdate;
        private MavenGeneralSettings myGeneralSettingsCache;
        private MavenImportingSettings myImportingSettingsCache;
        private Path myImportRootDirectory;
        private VirtualFile myImportProjectFile;
        private List<VirtualFile> myFiles;
        private MavenProjectsTree myMavenProjectTree;
        private List<MavenProject> mySelectedProjects;
        private boolean myOpenModulesConfigurator;

        private Parameters() {
        }
    }
}

