/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.DownloadArtifactEvent;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenPullDownloadListener;
import org.jetbrains.idea.maven.server.MavenPullServerLogger;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnectorBase;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.ServerLogEvent;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenServerConnectorImpl
extends MavenServerConnectorBase {
    public static final Logger LOG = Logger.getInstance(MavenServerConnectorImpl.class);
    private final ScheduledExecutorService myExecutor;
    private final AtomicInteger myLoggerConnectFailedCount;
    private final AtomicInteger myDownloadConnectFailedCount;
    private ScheduledFuture<?> myPullingLoggerFuture;
    private ScheduledFuture<?> myPullingDownloadFuture;

    public MavenServerConnectorImpl(@NotNull Project project2, @NotNull Sdk jdk2, @NotNull String vmOptions, @Nullable Integer debugPort, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
        if (project2 == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(0);
        }
        if (jdk2 == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(1);
        }
        if (vmOptions == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(2);
        }
        if (mavenDistribution == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(3);
        }
        if (multimoduleDirectory == null) {
            MavenServerConnectorImpl.$$$reportNull$$$0(4);
        }
        super(project2, jdk2, vmOptions, mavenDistribution, multimoduleDirectory, debugPort);
        this.myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Maven connector pulling", (int)2);
        this.myLoggerConnectFailedCount = new AtomicInteger(0);
        this.myDownloadConnectFailedCount = new AtomicInteger(0);
        this.myPullingLoggerFuture = null;
        this.myPullingDownloadFuture = null;
    }

    @Override
    public boolean isCompatibleWith(Sdk jdk2, String vmOptions, MavenDistribution distribution) {
        if (!this.myDistribution.compatibleWith(distribution)) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myJdk.getName(), (CharSequence)jdk2.getName())) {
            return false;
        }
        return StringUtil.equals((CharSequence)vmOptions, (CharSequence)this.myVmOptions);
    }

    @Override
    @NotNull
    protected StartServerTask newStartServerTask() {
        return new StartServerTask();
    }

    @Override
    protected void cleanUpFutures() {
        try {
            int count;
            MavenServerConnectorImpl.cancelFuture(this.myPullingDownloadFuture);
            MavenServerConnectorImpl.cancelFuture(this.myPullingLoggerFuture);
            if (!this.myExecutor.isShutdown()) {
                this.myExecutor.shutdownNow();
            }
            if ((count = this.myLoggerConnectFailedCount.get()) != 0) {
                MavenLog.LOG.warn("Maven pulling logger failed: " + count + " times");
            }
            if ((count = this.myDownloadConnectFailedCount.get()) != 0) {
                MavenLog.LOG.warn("Maven pulling download listener failed: " + count + " times");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void cancelFuture(ScheduledFuture<?> future) {
        if (future != null) {
            try {
                future.cancel(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public String getSupportType() {
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support = this.mySupport;
        return support == null ? "???" : support.type();
    }

    private void startPullingDownloadListener(MavenServer server) throws RemoteException {
        MavenPullDownloadListener listener2 = server.createPullDownloadListener(MavenRemoteObjectWrapper.ourToken);
        if (listener2 == null) {
            return;
        }
        this.myPullingDownloadFuture = this.myExecutor.scheduleWithFixedDelay(() -> {
            try {
                List artifactEvents = listener2.pull();
                for (DownloadArtifactEvent e : artifactEvents) {
                    ((MavenServerDownloadListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DOWNLOAD_LISTENER_TOPIC)).artifactDownloaded(new File(e.getFile()), e.getPath());
                }
                this.myDownloadConnectFailedCount.set(0);
            }
            catch (RemoteException e) {
                if (!Thread.currentThread().isInterrupted()) {
                    this.myDownloadConnectFailedCount.incrementAndGet();
                }
                MavenLog.LOG.warn("Maven pulling download listener stopped");
                this.myPullingDownloadFuture.cancel(true);
            }
        }, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void startPullingLogger(MavenServer server) throws RemoteException {
        MavenPullServerLogger logger = server.createPullLogger(MavenRemoteObjectWrapper.ourToken);
        if (logger == null) {
            return;
        }
        this.myPullingLoggerFuture = this.myExecutor.scheduleWithFixedDelay(() -> {
            try {
                List logEvents = logger.pull();
                for (ServerLogEvent e : logEvents) {
                    switch (e.getType()) {
                        case DEBUG: {
                            MavenLog.LOG.debug(e.getMessage());
                            break;
                        }
                        case PRINT: 
                        case INFO: {
                            MavenLog.LOG.info(e.getMessage());
                            break;
                        }
                        case WARN: 
                        case ERROR: {
                            MavenLog.LOG.warn(e.getMessage());
                        }
                    }
                }
                this.myLoggerConnectFailedCount.set(0);
            }
            catch (RemoteException e) {
                if (!Thread.currentThread().isInterrupted()) {
                    this.myLoggerConnectFailedCount.incrementAndGet();
                }
                MavenLog.LOG.warn("Maven pulling logger stopped");
                this.myPullingLoggerFuture.cancel(true);
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "jdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "vmOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "mavenDistribution";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "multimoduleDirectory";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/server/MavenServerConnectorImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class StartServerTask
    implements Runnable {
        private StartServerTask() {
        }

        @Override
        public void run() {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            String dirForLogs = (String)MavenServerConnectorImpl.this.myMultimoduleDirectories.iterator().next();
            MavenLog.LOG.debug("Connecting maven connector in " + dirForLogs);
            try {
                if (MavenServerConnectorImpl.this.myDebugPort != null) {
                    System.out.println("Listening for transport dt_socket at address: " + MavenServerConnectorImpl.this.myDebugPort);
                }
                MavenRemoteProcessSupportFactory factory = MavenRemoteProcessSupportFactory.forProject(MavenServerConnectorImpl.this.myProject);
                MavenServerConnectorImpl.this.mySupport = factory.create(MavenServerConnectorImpl.this.myJdk, MavenServerConnectorImpl.this.myVmOptions, MavenServerConnectorImpl.this.myDistribution, MavenServerConnectorImpl.this.myProject, MavenServerConnectorImpl.this.myDebugPort);
                MavenServerConnectorImpl.this.mySupport.onTerminate(e -> {
                    MavenLog.LOG.debug("[connector] terminate " + MavenServerConnectorImpl.this);
                    MavenServerManager mavenServerManager = (MavenServerManager)ApplicationManager.getApplication().getServiceIfCreated(MavenServerManager.class);
                    if (mavenServerManager != null) {
                        mavenServerManager.shutdownConnector(MavenServerConnectorImpl.this, false);
                    }
                });
                try (AccessToken ignored = ThreadContext.resetThreadContext();){
                    MavenServer server = (MavenServer)MavenServerConnectorImpl.this.mySupport.acquire(this, "", (ProgressIndicator)indicator);
                    MavenServerConnectorImpl.this.startPullingDownloadListener(server);
                    MavenServerConnectorImpl.this.startPullingLogger(server);
                    MavenServerConnectorImpl.this.myServerPromise.setResult((Object)server);
                }
                MavenLog.LOG.debug("[connector] in " + dirForLogs + " has been connected " + MavenServerConnectorImpl.this);
            }
            catch (Throwable e2) {
                MavenLog.LOG.warn("[connector] cannot connect in " + dirForLogs, e2);
                MavenServerConnectorImpl.this.myServerPromise.setError(e2);
            }
        }
    }
}

