/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerStatus;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;

public interface MavenServerConnector
extends Disposable {
    @Topic.AppLevel
    public static final Topic<MavenServerDownloadListener> DOWNLOAD_LISTENER_TOPIC = new Topic(MavenServerDownloadListener.class.getSimpleName(), MavenServerDownloadListener.class);

    public boolean isCompatibleWith(Sdk var1, String var2, MavenDistribution var3);

    @ApiStatus.Internal
    public boolean isNew();

    @ApiStatus.Internal
    public void connect();

    public boolean addMultimoduleDir(String var1);

    public MavenServerEmbedder createEmbedder(MavenEmbedderSettings var1) throws RemoteException;

    public MavenServerIndexer createIndexer() throws RemoteException;

    @NotNull
    public MavenModel interpolateAndAlignModel(@NotNull MavenModel var1, @NotNull Path var2, @NotNull Path var3);

    public MavenModel assembleInheritance(MavenModel var1, MavenModel var2);

    public ProfileApplicationResult applyProfiles(MavenModel var1, Path var2, MavenExplicitProfiles var3, Collection<String> var4);

    @ApiStatus.Internal
    public boolean ping();

    public String getSupportType();

    public State getState();

    public boolean checkConnected();

    @ApiStatus.Internal
    public void stop(boolean var1);

    @NotNull
    public Sdk getJdk();

    @NotNull
    public MavenDistribution getMavenDistribution();

    public String getVMOptions();

    @Nullable
    public Project getProject();

    public List<String> getMultimoduleDirectories();

    public MavenServerStatus getDebugStatus(boolean var1);

    public static enum State {
        STARTING,
        RUNNING,
        FAILED,
        STOPPED;

    }
}

