/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.nio.file.Path;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.server.MavenBuildPathsChange;
import org.jetbrains.idea.maven.server.MavenCoreInitializationException;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.MavenServerStatus;
import org.jetbrains.idea.maven.server.MisconfiguredPlexusDummyEmbedder;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;

public abstract class AbstractMavenServerConnector
implements MavenServerConnector {
    public static final Logger LOG = Logger.getInstance(AbstractMavenServerConnector.class);
    protected final Project myProject;
    @NotNull
    protected final MavenDistribution myDistribution;
    protected final Sdk myJdk;
    protected final Set<String> myMultimoduleDirectories;
    private final Object embedderLock;
    protected final String myVmOptions;

    public AbstractMavenServerConnector(@Nullable Project project2, @NotNull Sdk jdk2, @NotNull String vmOptions, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
        if (jdk2 == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(0);
        }
        if (vmOptions == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(1);
        }
        if (mavenDistribution == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(2);
        }
        if (multimoduleDirectory == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(3);
        }
        this.myMultimoduleDirectories = ConcurrentHashMap.newKeySet();
        this.embedderLock = new Object();
        this.myProject = project2;
        this.myDistribution = mavenDistribution;
        this.myVmOptions = vmOptions;
        this.myJdk = jdk2;
        this.myMultimoduleDirectories.add(multimoduleDirectory);
    }

    @Override
    public boolean addMultimoduleDir(String multimoduleDirectory) {
        return this.myMultimoduleDirectories.add(multimoduleDirectory);
    }

    @NotNull
    protected abstract MavenServer getServer();

    @Override
    public MavenServerEmbedder createEmbedder(MavenEmbedderSettings settings) throws RemoteException {
        Object object = this.embedderLock;
        synchronized (object) {
            try {
                return this.getServer().createEmbedder(settings, MavenRemoteObjectWrapper.ourToken);
            }
            catch (Exception e) {
                MavenCoreInitializationException cause = (MavenCoreInitializationException)ExceptionUtil.findCause((Throwable)e, MavenCoreInitializationException.class);
                if (cause != null) {
                    return new MisconfiguredPlexusDummyEmbedder(this.myProject, cause.getMessage(), this.myMultimoduleDirectories, this.getMavenDistribution().getVersion(), cause.getUnresolvedExtensionId());
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MavenServerIndexer createIndexer() throws RemoteException {
        Object object = this.embedderLock;
        synchronized (object) {
            return this.getServer().createIndexer(MavenRemoteObjectWrapper.ourToken);
        }
    }

    @Override
    @NotNull
    public MavenModel interpolateAndAlignModel(@NotNull MavenModel model, @NotNull Path basedir, @NotNull Path pomDir) {
        if (model == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(4);
        }
        if (basedir == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(5);
        }
        if (pomDir == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(6);
        }
        MavenModel mavenModel = (MavenModel)this.perform(() -> {
            RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(this.myProject);
            File targetBasedir = new File(transformer.toRemotePathOrSelf(basedir.toString()));
            File targetPomDir = new File(transformer.toRemotePathOrSelf(pomDir.toString()));
            MavenModel m = this.getServer().interpolateAndAlignModel(model, targetBasedir, targetPomDir, MavenRemoteObjectWrapper.ourToken);
            if (transformer != RemotePathTransformerFactory.Transformer.ID) {
                new MavenBuildPathsChange((Function1<? super String, String>)((Function1)s -> transformer.toIdePath((String)s)), (Function1<? super String, Boolean>)((Function1)s -> transformer.canBeRemotePath((String)s))).perform(m);
            }
            return m;
        });
        if (mavenModel == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(7);
        }
        return mavenModel;
    }

    @Override
    public MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) {
        return (MavenModel)this.perform(() -> this.getServer().assembleInheritance(model, parentModel, MavenRemoteObjectWrapper.ourToken));
    }

    @Override
    public ProfileApplicationResult applyProfiles(MavenModel model, Path basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        return (ProfileApplicationResult)this.perform(() -> {
            RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(this.myProject);
            File targetBasedir = new File(transformer.toRemotePathOrSelf(basedir.toString()));
            return this.getServer().applyProfiles(model, targetBasedir, explicitProfiles, new HashSet(alwaysOnProfiles), MavenRemoteObjectWrapper.ourToken);
        });
    }

    protected abstract <R, E extends Exception> R perform(Retriable<R, E> var1) throws E;

    public void dispose() {
        MavenServerManager.getInstance().shutdownConnector(this, true);
    }

    @Override
    @NotNull
    public Sdk getJdk() {
        Sdk sdk = this.myJdk;
        if (sdk == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(8);
        }
        return sdk;
    }

    @Override
    @NotNull
    public MavenDistribution getMavenDistribution() {
        MavenDistribution mavenDistribution = this.myDistribution;
        if (mavenDistribution == null) {
            AbstractMavenServerConnector.$$$reportNull$$$0(9);
        }
        return mavenDistribution;
    }

    @Override
    public String getVMOptions() {
        return this.myVmOptions;
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public List<String> getMultimoduleDirectories() {
        return new ArrayList<String>(this.myMultimoduleDirectories);
    }

    @Override
    public MavenServerStatus getDebugStatus(boolean clean) {
        return (MavenServerStatus)this.perform(() -> this.getServer().getDebugStatus(clean));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + Integer.toHexString(this.hashCode()) + ", myDistribution=" + this.myDistribution.getMavenHome() + ", myJdk=" + this.myJdk.getName() + ", myMultimoduleDirectories=" + this.myMultimoduleDirectories + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDistribution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multimoduleDirectory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basedir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomDir";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/AbstractMavenServerConnector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/AbstractMavenServerConnector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenDistribution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "interpolateAndAlignModel";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface Retriable<T, E extends Exception>
    extends RemoteObjectWrapper.Retriable<T, E> {
    }
}

