/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.navigator.MavenNavigationUtil;
import org.jetbrains.idea.maven.project.MavenDependencyAnalyzerContributor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0011\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0012"}, d2={"getArtifactFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "dependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "getMavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "getModule", "Lcom/intellij/openapi/module/Module;", "data", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data$Module;", "getParentModule", "dependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "getUnifiedCoordinates", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data$Artifact;", "intellij.maven"})
public final class MavenDependencyAnalazyerUtilKt {
    @Nullable
    public static final VirtualFile getArtifactFile(@NotNull Project project2, @Nullable DependencyAnalyzerDependency.Data dependencyData) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MavenId mavenId2 = MavenDependencyAnalazyerUtilKt.getMavenId(dependencyData);
        if (mavenId2 == null) {
            return null;
        }
        MavenId mavenId3 = mavenId2;
        MavenProject mavenProject2 = MavenProjectsManager.getInstance(project2).findProject(mavenId3);
        MavenProject mavenProject3 = mavenProject2;
        if (mavenProject3 == null || (mavenProject3 = mavenProject3.getFile()) == null) {
            mavenProject3 = MavenNavigationUtil.getArtifactFile(project2, mavenId3);
        }
        return mavenProject3;
    }

    @Nullable
    public static final MavenId getMavenId(@Nullable DependencyAnalyzerDependency.Data dependencyData) {
        DependencyAnalyzerDependency.Data data2 = dependencyData;
        return data2 instanceof DependencyAnalyzerDependency.Data.Artifact ? new MavenId(((DependencyAnalyzerDependency.Data.Artifact)dependencyData).getGroupId(), ((DependencyAnalyzerDependency.Data.Artifact)dependencyData).getArtifactId(), ((DependencyAnalyzerDependency.Data.Artifact)dependencyData).getVersion()) : (data2 instanceof DependencyAnalyzerDependency.Data.Module ? (MavenId)((DependencyAnalyzerDependency.Data.Module)dependencyData).getUserData(MavenDependencyAnalyzerContributor.Companion.getMAVEN_ARTIFACT_ID()) : null);
    }

    @Nullable
    public static final UnifiedCoordinates getUnifiedCoordinates(@NotNull DependencyAnalyzerDependency dependency) {
        UnifiedCoordinates unifiedCoordinates;
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        DependencyAnalyzerDependency.Data data2 = dependency.getData();
        if (data2 instanceof DependencyAnalyzerDependency.Data.Artifact) {
            unifiedCoordinates = MavenDependencyAnalazyerUtilKt.getUnifiedCoordinates((DependencyAnalyzerDependency.Data.Artifact)data2);
        } else if (data2 instanceof DependencyAnalyzerDependency.Data.Module) {
            unifiedCoordinates = MavenDependencyAnalazyerUtilKt.getUnifiedCoordinates((DependencyAnalyzerDependency.Data.Module)data2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return unifiedCoordinates;
    }

    @NotNull
    public static final UnifiedCoordinates getUnifiedCoordinates(@NotNull DependencyAnalyzerDependency.Data.Artifact data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        return new UnifiedCoordinates(data2.getGroupId(), data2.getArtifactId(), data2.getVersion());
    }

    @Nullable
    public static final UnifiedCoordinates getUnifiedCoordinates(@NotNull DependencyAnalyzerDependency.Data.Module data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        MavenId mavenId2 = (MavenId)data2.getUserData(MavenDependencyAnalyzerContributor.Companion.getMAVEN_ARTIFACT_ID());
        if (mavenId2 == null) {
            return null;
        }
        MavenId mavenId3 = mavenId2;
        return new UnifiedCoordinates(mavenId3.getGroupId(), mavenId3.getArtifactId(), mavenId3.getVersion());
    }

    @Nullable
    public static final Module getParentModule(@NotNull Project project2, @NotNull DependencyAnalyzerDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        DependencyAnalyzerDependency dependencyAnalyzerDependency = dependency.getParent();
        DependencyAnalyzerDependency.Data data2 = dependencyAnalyzerDependency != null ? dependencyAnalyzerDependency.getData() : null;
        DependencyAnalyzerDependency.Data.Module module2 = data2 instanceof DependencyAnalyzerDependency.Data.Module ? (DependencyAnalyzerDependency.Data.Module)data2 : null;
        if (module2 == null) {
            return null;
        }
        DependencyAnalyzerDependency.Data.Module parentData = module2;
        return MavenDependencyAnalazyerUtilKt.getModule(project2, parentData);
    }

    @Nullable
    public static final Module getModule(@NotNull Project project2, @NotNull DependencyAnalyzerDependency.Data.Module data2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        MavenId mavenId2 = MavenDependencyAnalazyerUtilKt.getMavenId((DependencyAnalyzerDependency.Data)data2);
        if (mavenId2 == null) {
            return null;
        }
        MavenId mavenId3 = mavenId2;
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        MavenProject mavenProject2 = projectsManager.findProject(mavenId3);
        if (mavenProject2 == null) {
            return null;
        }
        MavenProject mavenProject3 = mavenProject2;
        return projectsManager.findModule(mavenProject3);
    }
}

