/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.actions.LookForNestedToggleAction;

public class MavenImportingSettingsForm {
    private JPanel myPanel;
    private JCheckBox mySearchRecursivelyCheckBox;
    private JBCheckBox myWorkspaceImportCheckBox;
    private JCheckBox mySeparateModulesDirCheckBox;
    private TextFieldWithBrowseButton mySeparateModulesDirChooser;
    private JCheckBox myCreateModulesForAggregators;
    private JComboBox<String> myUpdateFoldersOnImportPhaseComboBox;
    private JCheckBox myKeepSourceFoldersCheckBox;
    private JCheckBox myUseMavenOutputCheckBox;
    private JCheckBox myDownloadSourcesCheckBox;
    private JCheckBox myDownloadDocsCheckBox;
    private JCheckBox myDownloadAnnotationsCheckBox;
    private JPanel myAdditionalSettingsPanel;
    private JComboBox<MavenImportingSettings.GeneratedSourcesFolder> myGeneratedSourcesComboBox;
    private JCheckBox myExcludeTargetFolderCheckBox;
    private JTextField myDependencyTypes;
    private JCheckBox myStoreProjectFilesUnderProjectRoot;
    private JBLabel myStoreProjectFilesUnderProjectRootHint;
    private JBTextField myVMOptionsForImporter;
    private ExternalSystemJdkComboBox myJdkForImporterComboBox;
    private JLabel myImporterJdkWarning;
    private JCheckBox myAutoDetectCompilerCheckBox;
    private final ComponentValidator myImporterJdkValidator;
    private volatile boolean myMuteJdkValidation;

    public MavenImportingSettingsForm(Project project2, @NotNull Disposable disposable) {
        if (disposable == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(0);
        }
        this.myMuteJdkValidation = false;
        this.$$$setupUI$$$();
        this.myJdkForImporterComboBox.setProject(project2);
        this.mySearchRecursivelyCheckBox.setVisible(project2.isDefault());
        this.myWorkspaceImportCheckBox.addItemListener(e -> this.updateImportControls(project2));
        this.myStoreProjectFilesUnderProjectRoot.addItemListener(e -> {
            Icon icon = this.myStoreProjectFilesUnderProjectRoot.isSelected() ? AllIcons.General.Warning : null;
            this.myStoreProjectFilesUnderProjectRootHint.setIcon(icon);
        });
        this.mySeparateModulesDirCheckBox.addActionListener(e -> this.updateModuleDirControls());
        this.mySeparateModulesDirChooser.addBrowseFolderListener(MavenProjectBundle.message("maven.import.title.module.dir", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myUpdateFoldersOnImportPhaseComboBox.setModel(new DefaultComboBoxModel<String>(MavenImportingSettings.UPDATE_FOLDERS_PHASES));
        this.myGeneratedSourcesComboBox.setModel((ComboBoxModel<MavenImportingSettings.GeneratedSourcesFolder>)new EnumComboBoxModel(MavenImportingSettings.GeneratedSourcesFolder.class));
        this.myGeneratedSourcesComboBox.setRenderer((ListCellRenderer<MavenImportingSettings.GeneratedSourcesFolder>)SimpleListCellRenderer.create((String)"", value -> value.getTitle()));
        LabelTextReplacingUtil.replaceText((JComponent)this.myPanel);
        this.myAutoDetectCompilerCheckBox.setVisible(Registry.is((String)"maven.import.compiler.arguments", (boolean)true));
        this.myJdkForImporterComboBox.setHighlightInternalJdk(false);
        ActionListener validatorListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenImportingSettingsForm.this.validateImporterJDK();
            }
        };
        this.myJdkForImporterComboBox.addActionListener(validatorListener);
        this.myImporterJdkValidator = new ComponentValidator(disposable).withValidator(() -> {
            if (JavaSdkVersionUtil.isAtLeast((Sdk)this.myJdkForImporterComboBox.getSelectedJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_8)) {
                return null;
            }
            return new ValidationInfo(MavenConfigurableBundle.message("maven.settings.importing.jdk.too.old.error", new Object[0]), (JComponent)this.myJdkForImporterComboBox);
        }).installOn((JComponent)this.myJdkForImporterComboBox);
        this.myImporterJdkWarning.setVisible(false);
    }

    private void updateImportControls(@Nullable Project project2) {
        boolean isWorkspaceImport = this.myWorkspaceImportCheckBox.isSelected();
        this.myStoreProjectFilesUnderProjectRoot.setVisible(project2 != null && !isWorkspaceImport);
        this.myStoreProjectFilesUnderProjectRootHint.setVisible(project2 != null && !isWorkspaceImport);
        this.mySeparateModulesDirCheckBox.setVisible(!isWorkspaceImport);
        this.mySeparateModulesDirChooser.setVisible(!isWorkspaceImport);
        this.myKeepSourceFoldersCheckBox.setVisible(!isWorkspaceImport);
        this.myCreateModulesForAggregators.setVisible(!isWorkspaceImport);
    }

    private void updateModuleDirControls() {
        boolean useSeparateDir = this.mySeparateModulesDirCheckBox.isSelected();
        this.mySeparateModulesDirChooser.setEnabled(useSeparateDir);
        if (useSeparateDir && StringUtil.isEmptyOrSpaces((String)this.mySeparateModulesDirChooser.getText())) {
            this.mySeparateModulesDirChooser.setText(FileUtil.toSystemDependentName((String)this.getDefaultModuleDir()));
        }
        this.validateImporterJDK();
    }

    public String getDefaultModuleDir() {
        return "";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void getData(@NotNull MavenImportingSettings data2) {
        if (data2 == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(1);
        }
        data2.setWorkspaceImportEnabled(this.myWorkspaceImportCheckBox.isSelected());
        data2.setLookForNested(this.mySearchRecursivelyCheckBox.isSelected());
        LookForNestedToggleAction.setSelected(this.mySearchRecursivelyCheckBox.isSelected());
        data2.setDedicatedModuleDir(this.mySeparateModulesDirCheckBox.isSelected() ? this.mySeparateModulesDirChooser.getText() : "");
        data2.setCreateModulesForAggregators(this.myCreateModulesForAggregators.isSelected());
        data2.setKeepSourceFolders(this.myKeepSourceFoldersCheckBox.isSelected());
        data2.setExcludeTargetFolder(this.myExcludeTargetFolderCheckBox.isSelected());
        data2.setUseMavenOutput(this.myUseMavenOutputCheckBox.isSelected());
        data2.setUpdateFoldersOnImportPhase((String)this.myUpdateFoldersOnImportPhaseComboBox.getSelectedItem());
        data2.setGeneratedSourcesFolder((MavenImportingSettings.GeneratedSourcesFolder)((Object)this.myGeneratedSourcesComboBox.getSelectedItem()));
        data2.setDownloadSourcesAutomatically(this.myDownloadSourcesCheckBox.isSelected());
        data2.setDownloadDocsAutomatically(this.myDownloadDocsCheckBox.isSelected());
        data2.setDownloadAnnotationsAutomatically(this.myDownloadAnnotationsCheckBox.isSelected());
        data2.setAutoDetectCompiler(this.myAutoDetectCompilerCheckBox.isSelected());
        data2.setVmOptionsForImporter(this.myVMOptionsForImporter.getText());
        data2.setJdkForImporter(this.myJdkForImporterComboBox.getSelectedValue());
        data2.setDependencyTypes(this.myDependencyTypes.getText());
    }

    public void setData(MavenImportingSettings data2, @Nullable Project project2) {
        this.mySearchRecursivelyCheckBox.setSelected(LookForNestedToggleAction.isSelected());
        this.myWorkspaceImportCheckBox.setSelected(data2.isWorkspaceImportEnabled());
        this.mySeparateModulesDirCheckBox.setSelected(!StringUtil.isEmptyOrSpaces((String)data2.getDedicatedModuleDir()));
        this.mySeparateModulesDirChooser.setText(data2.getDedicatedModuleDir());
        this.myCreateModulesForAggregators.setSelected(data2.isCreateModulesForAggregators());
        this.myKeepSourceFoldersCheckBox.setSelected(data2.isKeepSourceFolders());
        this.myStoreProjectFilesUnderProjectRoot.setSelected(!MavenImportingSettingsForm.isCurrentlyStoredExternally(project2));
        this.myExcludeTargetFolderCheckBox.setSelected(data2.isExcludeTargetFolder());
        this.myUseMavenOutputCheckBox.setSelected(data2.isUseMavenOutput());
        this.myUpdateFoldersOnImportPhaseComboBox.setSelectedItem(data2.getUpdateFoldersOnImportPhase());
        this.myGeneratedSourcesComboBox.setSelectedItem((Object)data2.getGeneratedSourcesFolder());
        this.myDownloadSourcesCheckBox.setSelected(data2.isDownloadSourcesAutomatically());
        this.myDownloadDocsCheckBox.setSelected(data2.isDownloadDocsAutomatically());
        this.myDownloadAnnotationsCheckBox.setSelected(data2.isDownloadAnnotationsAutomatically());
        this.myAutoDetectCompilerCheckBox.setSelected(data2.isAutoDetectCompiler());
        this.myDependencyTypes.setText(data2.getDependencyTypes());
        this.myVMOptionsForImporter.setText(data2.getVmOptionsForImporter());
        this.skipValidationDuring(() -> this.myJdkForImporterComboBox.refreshData(data2.getJdkForImporter()));
        this.updateImportControls(project2);
        this.updateModuleDirControls();
    }

    private void skipValidationDuring(Runnable r) {
        this.myMuteJdkValidation = true;
        try {
            r.run();
        }
        finally {
            this.myMuteJdkValidation = false;
            this.validateImporterJDK();
        }
    }

    private static boolean isCurrentlyStoredExternally(@Nullable Project project2) {
        return project2 == null || ExternalStorageConfigurationManager.getInstance((Project)project2).isEnabled();
    }

    public boolean isModified(@NotNull MavenImportingSettings settings, @Nullable Project project2) {
        if (settings == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(2);
        }
        if (project2 != null && MavenImportingSettingsForm.isCurrentlyStoredExternally(project2) != this.isStoreExternally()) {
            return true;
        }
        MavenImportingSettings formData = new MavenImportingSettings();
        this.getData(formData);
        return !formData.equals(settings);
    }

    boolean isStoreExternally() {
        return !this.myStoreProjectFilesUnderProjectRoot.isSelected();
    }

    public JPanel getAdditionalSettingsPanel() {
        return this.myAdditionalSettingsPanel;
    }

    private void validateImporterJDK() {
        if (this.myMuteJdkValidation) {
            return;
        }
        this.myImporterJdkValidator.revalidate();
        if (this.myImporterJdkValidator.getValidationInfo() == null) {
            this.myImporterJdkWarning.setVisible(false);
        } else {
            this.myImporterJdkWarning.setVisible(true);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        ExternalSystemJdkComboBox externalSystemJdkComboBox;
        JBTextField jBTextField;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JBLabel jBLabel;
        JCheckBox jCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox4;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(25, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCreateModulesForAggregators = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.create.modules.for.aggregator"));
        jPanel2.add((Component)jCheckBox10, new GridConstraints(5, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.mySearchRecursivelyCheckBox = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.search.recursively"));
        jPanel2.add((Component)jCheckBox9, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myUseMavenOutputCheckBox = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.use.output.directories"));
        jCheckBox8.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.use.output.directories.tooltip"));
        jPanel2.add((Component)jCheckBox8, new GridConstraints(8, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.phase.for.source.updates.notes"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(12, 0, 1, 3, 0, 1, 3, 0, null, null, null, 3));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel3.setFocusable(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(14, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadSourcesCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download.sources"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDownloadDocsCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download.documentation"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBCheckBox jBCheckBox2 = new JBCheckBox();
        this.myDownloadAnnotationsCheckBox = jBCheckBox2;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.auto.download.annotations"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myKeepSourceFoldersCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.keep.folders.on.reimport"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(6, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myAdditionalSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(15, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(23, 0, 1, 3, 8, 2, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(14, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myWorkspaceImportCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.workspace.import"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.mySeparateModulesDirCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.files.keep.in"));
        jCheckBox4.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.files.keep.in.tooltip"));
        jPanel5.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySeparateModulesDirChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myStoreProjectFilesUnderProjectRoot = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.store.externally"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myStoreProjectFilesUnderProjectRootHint = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.store.externally.hint"));
        jPanel5.add((Component)jBLabel, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 0, null, null, null, 3));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(24, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(11, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myUpdateFoldersOnImportPhaseComboBox = jComboBox;
        jPanel6.add(jComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.phase.for.source.updates"));
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel6.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel2.add((Component)spacer5, new GridConstraints(10, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(1, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(9, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.generated.source.folders"));
        jPanel7.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel7.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myGeneratedSourcesComboBox = jComboBox2;
        jPanel7.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myExcludeTargetFolderCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.exclude.build.directory"));
        jCheckBox2.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.project.exclude.build.directory.tooltip"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(7, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type"));
        jLabel4.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type.tooltip"));
        jPanel2.add((Component)jLabel4, new GridConstraints(15, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDependencyTypes = jTextField = new JTextField();
        jTextField.setColumns(0);
        jTextField.setToolTipText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type.tooltip"));
        jPanel2.add((Component)jTextField, new GridConstraints(15, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel3.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel3.setHorizontalTextPosition(4);
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.dependency.type.tooltip"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(16, 1, 1, 2, 9, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel2.add((Component)spacer8, new GridConstraints(17, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer9 = new Spacer();
        jPanel2.add((Component)spacer9, new GridConstraints(13, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.vm.options"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(18, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMOptionsForImporter = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(18, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.jdk"));
        jPanel2.add((Component)jBLabel5, new GridConstraints(20, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJdkForImporterComboBox = externalSystemJdkComboBox = new ExternalSystemJdkComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        externalSystemJdkComboBox.setModel(defaultComboBoxModel);
        jPanel2.add((Component)externalSystemJdkComboBox, new GridConstraints(20, 1, 1, 2, 0, 1, 2, 2, null, null, null));
        this.myAutoDetectCompilerCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.detect.compiler"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel6.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel6.setHorizontalTextPosition(4);
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.vm.options.tooltip"));
        jPanel2.add((Component)jBLabel6, new GridConstraints(19, 1, 1, 2, 9, 0, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        this.myImporterJdkWarning = jBLabel7;
        jBLabel7.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel7.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenImportingSettingsForm.class).getString("maven.settings.importing.jdk.fallback.warning"));
        jPanel2.add((Component)jBLabel7, new GridConstraints(22, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel4.setLabelFor(jTextField);
        jBLabel3.setLabelFor(jTextField);
        jBLabel6.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenImportingSettingsForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

