/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DADependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAModule;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAOmitted;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAProject;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAScope;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAWarning;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerContributor;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerProject;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\bH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\b2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u001e\u0010\u001c\u001a\u00020\u00062\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerContributor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectDependency", "", "nodes", "", "Lorg/jetbrains/idea/maven/model/MavenArtifactNode;", "parentDependency", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency;", "result", "", "createDependencyList", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "getDependencies", "externalProject", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerProject;", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "mavenArtifactNode", "getDependencyScopes", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope;", "getProjects", "getStatus", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Status;", "whenDataChanged", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.maven"})
public final class MavenDependencyAnalyzerContributor
implements DependencyAnalyzerContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Key<MavenId> MAVEN_ARTIFACT_ID;

    public MavenDependencyAnalyzerContributor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public void whenDataChanged(@NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.project);
        projectsManager.addProjectsTreeListener(new MavenProjectsTree.Listener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
                Intrinsics.checkNotNullParameter(projectWithChanges, (String)"projectWithChanges");
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    @NotNull
    public List<DependencyAnalyzerProject> getProjects() {
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(this.project);
        ArrayList<DAProject> externalProjects = new ArrayList<DAProject>();
        for (MavenProject mavenProject2 : mavenProjectsManager.getProjects()) {
            Module module2;
            if ((Module)ActionsKt.runReadAction((Function0)((Function0)new Function0<Module>(mavenProjectsManager, mavenProject2){
                final /* synthetic */ MavenProjectsManager $mavenProjectsManager;
                final /* synthetic */ MavenProject $mavenProject;
                {
                    this.$mavenProjectsManager = $mavenProjectsManager;
                    this.$mavenProject = $mavenProject;
                    super(0);
                }

                @Nullable
                public final Module invoke() {
                    return this.$mavenProjectsManager.findModule(this.$mavenProject);
                }
            })) == null) continue;
            String string = mavenProject2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            externalProjects.add(new DAProject(module2, string));
        }
        return externalProjects;
    }

    @NotNull
    public List<DependencyAnalyzerDependency.Scope> getDependencyScopes(@NotNull DependencyAnalyzerProject externalProject) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        Object[] objectArray = new DAScope[]{Companion.scope("compile"), Companion.scope("provided"), Companion.scope("runtime"), Companion.scope("system"), Companion.scope("import"), Companion.scope("test")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<DependencyAnalyzerDependency> getDependencies(@NotNull DependencyAnalyzerProject externalProject) {
        Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.project);
        MavenProject mavenProject2 = projectsManager.findProject(externalProject.getModule());
        if (mavenProject2 == null) {
            return CollectionsKt.emptyList();
        }
        MavenProject mavenProject3 = mavenProject2;
        return this.createDependencyList(mavenProject3);
    }

    private final List<DependencyAnalyzerDependency> createDependencyList(MavenProject mavenProject2) {
        String string = mavenProject2.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        DAModule root = new DAModule(string);
        MavenId mavenId2 = mavenProject2.getMavenId();
        Intrinsics.checkNotNullExpressionValue((Object)mavenId2, (String)"getMavenId(...)");
        MavenId mavenId3 = mavenId2;
        root.putUserData(MAVEN_ARTIFACT_ID, (Object)new MavenId(mavenId3.getGroupId(), mavenId3.getArtifactId(), mavenId3.getVersion()));
        DADependency rootDependency = new DADependency((DependencyAnalyzerDependency.Data)root, (DependencyAnalyzerDependency.Scope)Companion.scope("compile"), null, CollectionsKt.emptyList());
        List result2 = new ArrayList();
        List<MavenArtifactNode> list = mavenProject2.getDependencyTree();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getDependencyTree(...)");
        this.collectDependency(list, (DependencyAnalyzerDependency)rootDependency, result2);
        return result2;
    }

    private final void collectDependency(List<? extends MavenArtifactNode> nodes, DependencyAnalyzerDependency parentDependency, List<DependencyAnalyzerDependency> result2) {
        for (MavenArtifactNode mavenArtifactNode : nodes) {
            DependencyAnalyzerDependency.Data data2 = this.getDependencyData(mavenArtifactNode);
            String string = mavenArtifactNode.getOriginalScope();
            if (string == null) {
                string = "compile";
            }
            DADependency dependency = new DADependency(data2, (DependencyAnalyzerDependency.Scope)Companion.scope(string), parentDependency, this.getStatus(mavenArtifactNode));
            result2.add((DependencyAnalyzerDependency)dependency);
            if (mavenArtifactNode.getDependencies() == null) continue;
            List list = mavenArtifactNode.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDependencies(...)");
            this.collectDependency(list, (DependencyAnalyzerDependency)dependency, result2);
        }
    }

    private final DependencyAnalyzerDependency.Data getDependencyData(MavenArtifactNode mavenArtifactNode) {
        MavenProject mavenProject2 = MavenProjectsManager.getInstance(this.project).findProject(mavenArtifactNode.getArtifact());
        String string = mavenArtifactNode.getArtifact().getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroupId(...)");
        String string2 = mavenArtifactNode.getArtifact().getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
        String string3 = mavenArtifactNode.getArtifact().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
        DAArtifact daArtifact = new DAArtifact(string, string2, string3);
        if (mavenProject2 != null) {
            String string4 = mavenProject2.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getDisplayName(...)");
            DAModule daModule = new DAModule(string4);
            daModule.putUserData(MAVEN_ARTIFACT_ID, (Object)new MavenId(daArtifact.getGroupId(), daArtifact.getArtifactId(), daArtifact.getVersion()));
            return (DependencyAnalyzerDependency.Data)daModule;
        }
        return (DependencyAnalyzerDependency.Data)daArtifact;
    }

    private final List<DependencyAnalyzerDependency.Status> getStatus(MavenArtifactNode mavenArtifactNode) {
        List status = new ArrayList();
        if (mavenArtifactNode.getState() == MavenArtifactState.CONFLICT) {
            status.add(DAOmitted.INSTANCE);
            Object object = mavenArtifactNode.getRelatedArtifact();
            if (object != null && (object = object.getVersion()) != null) {
                Object object2;
                Object it = object2 = object;
                boolean bl = false;
                Object[] objectArray = new Object[]{it};
                String message = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.version.conflict", (Object[])objectArray);
                Intrinsics.checkNotNull((Object)message);
                status.add(new DAWarning(message));
            }
        } else if (mavenArtifactNode.getState() == MavenArtifactState.DUPLICATE) {
            status.add(DAOmitted.INSTANCE);
        }
        if (!mavenArtifactNode.getArtifact().isResolvedArtifact()) {
            String string = ExternalSystemBundle.message((String)"external.system.dependency.analyzer.warning.unresolved", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            status.add(new DAWarning(string));
        }
        return status;
    }

    static {
        Key key = Key.create((String)"MavenDependencyAnalyzerContributor.MavenId");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MAVEN_ARTIFACT_ID = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eR$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/maven/project/MavenDependencyAnalyzerContributor$Companion;", "", "()V", "MAVEN_ARTIFACT_ID", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/maven/model/MavenId;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getMAVEN_ARTIFACT_ID", "()Lcom/intellij/openapi/util/Key;", "scope", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DAScope;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DAScope scope(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = StringUtil.toTitleCase((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toTitleCase(...)");
            return new DAScope(name, string);
        }

        @NotNull
        public final Key<MavenId> getMAVEN_ARTIFACT_ID() {
            return MAVEN_ARTIFACT_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

