/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.performancePlugin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityStorageSnapshot;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.workspaceModel.ide.JpsProjectLoadingManager;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.preimport.MavenProjectPreImporter;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ImportMavenProjectCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "runWhenMavenImportAndIndexingFinished", "", "runnable", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "waitForCurrentMavenImportActivities", "Companion", "intellij.maven"})
public final class ImportMavenProjectCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%importMavenProject";

    public ImportMavenProjectCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Project project2 = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        ImportMavenProjectCommand $this$_execute_u24lambda_u241 = this;
        boolean bl = false;
        ActionCallback actionCallback = (ActionCallback)new ActionCallbackProfilerStopper();
        $this$_execute_u24lambda_u241.runWhenMavenImportAndIndexingFinished(context2, () -> ImportMavenProjectCommand._execute$lambda$1$lambda$0(actionCallback), project3);
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final void runWhenMavenImportAndIndexingFinished(PlaybackContext context2, Runnable runnable, Project project2) {
        ExternalSystemProjectTrackerSettings projectTrackerSettings = ExternalSystemProjectTrackerSettings.Companion.getInstance(project2);
        ExternalSystemProjectTrackerSettings.AutoReloadType currentAutoReloadType = projectTrackerSettings.getAutoReloadType();
        projectTrackerSettings.setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.NONE);
        context2.message("Waiting for fully open and initialized maven project", this.getLine());
        ExternalProjectsManagerImpl.getInstance((Project)project2).runWhenInitialized(() -> ImportMavenProjectCommand.runWhenMavenImportAndIndexingFinished$lambda$5(project2, this, context2, projectTrackerSettings, currentAutoReloadType, runnable));
    }

    private final void waitForCurrentMavenImportActivities(PlaybackContext context2, Project project2) {
        context2.message("Waiting for current maven import activities", this.getLine());
        MavenProjectsManager.getInstance(project2).waitForImportCompletion();
        context2.message("Maven import activities completed", this.getLine());
    }

    private static final void _execute$lambda$1$lambda$0(ActionCallback $actionCallback) {
        Intrinsics.checkNotNullParameter((Object)$actionCallback, (String)"$actionCallback");
        $actionCallback.setDone();
    }

    private static final void runWhenMavenImportAndIndexingFinished$lambda$5$lambda$4$lambda$3$lambda$2(ImportMavenProjectCommand this$0, PlaybackContext $context, Project $project, ExternalSystemProjectTrackerSettings $projectTrackerSettings, ExternalSystemProjectTrackerSettings.AutoReloadType $currentAutoReloadType, Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$projectTrackerSettings, (String)"$projectTrackerSettings");
        Intrinsics.checkNotNullParameter((Object)$currentAutoReloadType, (String)"$currentAutoReloadType");
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        this$0.waitForCurrentMavenImportActivities($context, $project);
        $context.message("Import of the project has been started", this$0.getLine());
        MavenProjectsManager mavenManager = MavenProjectsManager.getInstance($project);
        CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Module>>, Object>(mavenManager, null){
            int label;
            final /* synthetic */ MavenProjectsManager $mavenManager;
            {
                this.$mavenManager = $mavenManager;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        MavenProjectPreImporter.Companion.setPreimport(false);
                        if (this.$mavenManager.isMavenizedProject()) break;
                        files = this.$mavenManager.collectAllAvailablePomFiles();
                        Intrinsics.checkNotNull(files);
                        var3_4 = MavenExplicitProfiles.NONE;
                        Intrinsics.checkNotNullExpressionValue((Object)var3_4, (String)"NONE");
                        this.label = 1;
                        v0 = this.$mavenManager.addManagedFilesWithProfilesAndUpdate(files, var3_4, null, null, (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        v1 = (List)v0;
                        ** GOTO lbl32
                    }
                }
                v2 = MavenImportSpec.EXPLICIT_IMPORT;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"EXPLICIT_IMPORT");
                this.label = 2;
                v3 = this.$mavenManager.updateAllMavenProjects(v2, (Continuation)this);
                if (v3 == var4_2) {
                    return var4_2;
                }
                ** GOTO lbl31
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl31:
                        // 2 sources

                        v1 = (List)v3;
lbl32:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends Module>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this$0.waitForCurrentMavenImportActivities($context, $project);
        $context.message("Import of the maven project has been finished", this$0.getLine());
        $projectTrackerSettings.setAutoReloadType($currentAutoReloadType);
        DumbService dumbService = DumbService.Companion.getInstance($project);
        Runnable runnable = DisposeAwareRunnable.create((Runnable)$runnable, (Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"create(...)");
        dumbService.runWhenSmart(runnable);
        long storageVersion = WorkspaceModel.Companion.getInstance($project).getEntityStorage().getVersion();
        EntityStorageSnapshot storage = WorkspaceModel.Companion.getInstance($project).getCurrentSnapshot();
        $context.message("Entity storage version: " + storageVersion + ", snapshot: " + storage, this$0.getLine());
    }

    private static final void runWhenMavenImportAndIndexingFinished$lambda$5$lambda$4$lambda$3(ImportMavenProjectCommand this$0, PlaybackContext $context, Project $project, ExternalSystemProjectTrackerSettings $projectTrackerSettings, ExternalSystemProjectTrackerSettings.AutoReloadType $currentAutoReloadType, Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$projectTrackerSettings, (String)"$projectTrackerSettings");
        Intrinsics.checkNotNullParameter((Object)$currentAutoReloadType, (String)"$currentAutoReloadType");
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        ApplicationManager.getApplication().executeOnPooledThread(() -> ImportMavenProjectCommand.runWhenMavenImportAndIndexingFinished$lambda$5$lambda$4$lambda$3$lambda$2(this$0, $context, $project, $projectTrackerSettings, $currentAutoReloadType, $runnable));
    }

    private static final void runWhenMavenImportAndIndexingFinished$lambda$5$lambda$4(Project $project, ImportMavenProjectCommand this$0, PlaybackContext $context, ExternalSystemProjectTrackerSettings $projectTrackerSettings, ExternalSystemProjectTrackerSettings.AutoReloadType $currentAutoReloadType, Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$projectTrackerSettings, (String)"$projectTrackerSettings");
        Intrinsics.checkNotNullParameter((Object)$currentAutoReloadType, (String)"$currentAutoReloadType");
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        JpsProjectLoadingManager.Companion.getInstance($project).jpsProjectLoaded(() -> ImportMavenProjectCommand.runWhenMavenImportAndIndexingFinished$lambda$5$lambda$4$lambda$3(this$0, $context, $project, $projectTrackerSettings, $currentAutoReloadType, $runnable));
    }

    private static final void runWhenMavenImportAndIndexingFinished$lambda$5(Project $project, ImportMavenProjectCommand this$0, PlaybackContext $context, ExternalSystemProjectTrackerSettings $projectTrackerSettings, ExternalSystemProjectTrackerSettings.AutoReloadType $currentAutoReloadType, Runnable $runnable) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$projectTrackerSettings, (String)"$projectTrackerSettings");
        Intrinsics.checkNotNullParameter((Object)$currentAutoReloadType, (String)"$currentAutoReloadType");
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        MavenUtil.runWhenInitialized($project, () -> ImportMavenProjectCommand.runWhenMavenImportAndIndexingFinished$lambda$5$lambda$4($project, this$0, $context, $projectTrackerSettings, $currentAutoReloadType, $runnable));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/performancePlugin/ImportMavenProjectCommand$Companion;", "", "()V", "PREFIX", "", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

