/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.workspaceModel;

import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.workspacemodel.BridgeUtilsKt;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0007H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0016J\u0006\u0010\u001d\u001a\u00020\tJ\u0016\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0016J\f\u0010#\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J#\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'H\u0016\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020\u0015H\u0016J+\u0010*\u001a\u00020+\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'2\b\u0010,\u001a\u0004\u0018\u0001H%H\u0016\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020\u0007H\u0016J\u0010\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020\u0015H\u0016J\u0010\u00102\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u00103\u001a\u00020+2\b\u00104\u001a\u0004\u0018\u00010\u0005H\u0016J\u001e\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020 2\f\u00107\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011H\u0016J\u0014\u00108\u001a\u00020+2\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\b\u0010:\u001a\u00020\u0005H\u0016R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/ImporterModifiableArtifact;", "Lcom/intellij/packaging/artifacts/ModifiableArtifact;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "artifactType", "Lcom/intellij/packaging/artifacts/ArtifactType;", "outputUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "rootElement", "Lcom/intellij/packaging/elements/CompositePackagingElement;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/packaging/artifacts/ArtifactType;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/packaging/elements/CompositePackagingElement;Lcom/intellij/openapi/roots/ProjectModelExternalSource;)V", "artifactProperties", "", "Lcom/intellij/packaging/artifacts/ArtifactProperties;", "contextData", "Lcom/intellij/openapi/util/UserDataHolderBase;", "includeInProjectBuild", "", "getArtifactType", "getExternalSource", "getName", "getOutputFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getOutputFilePath", "getOutputPath", "getOutputUrl", "getProperties", "propertiesProvider", "Lcom/intellij/packaging/artifacts/ArtifactPropertiesProvider;", "getPropertiesProviders", "", "getRootElement", "getUserData", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "isBuildOnMake", "putUserData", "", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "setArtifactType", "selected", "setBuildOnMake", "enabled", "setName", "setOutputPath", "outputPath", "setProperties", "provider", "properties", "setRootElement", "root", "toString", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nImporterModifiableArtifactModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImporterModifiableArtifactModel.kt\norg/jetbrains/idea/maven/importing/workspaceModel/ImporterModifiableArtifact\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1#2:234\n766#3:235\n857#3,2:236\n*S KotlinDebug\n*F\n+ 1 ImporterModifiableArtifactModel.kt\norg/jetbrains/idea/maven/importing/workspaceModel/ImporterModifiableArtifact\n*L\n78#1:235\n78#1:236,2\n*E\n"})
public final class ImporterModifiableArtifact
implements ModifiableArtifact {
    @NotNull
    private final Project project;
    @NotNull
    private String name;
    @NotNull
    private ArtifactType artifactType;
    @NotNull
    private VirtualFileUrl outputUrl;
    @NotNull
    private CompositePackagingElement<?> rootElement;
    @Nullable
    private final ProjectModelExternalSource externalSource;
    @NotNull
    private final Map<String, ArtifactProperties<?>> artifactProperties;
    private boolean includeInProjectBuild;
    @NotNull
    private final UserDataHolderBase contextData;

    public ImporterModifiableArtifact(@NotNull Project project2, @NotNull String name, @NotNull ArtifactType artifactType, @NotNull VirtualFileUrl outputUrl, @NotNull CompositePackagingElement<?> rootElement, @Nullable ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
        Intrinsics.checkNotNullParameter((Object)outputUrl, (String)"outputUrl");
        Intrinsics.checkNotNullParameter(rootElement, (String)"rootElement");
        this.project = project2;
        this.name = name;
        this.artifactType = artifactType;
        this.outputUrl = outputUrl;
        this.rootElement = rootElement;
        this.externalSource = externalSource;
        this.artifactProperties = new LinkedHashMap();
        this.contextData = new UserDataHolderBase();
        ArtifactEntity existingArtifact = (ArtifactEntity)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().resolve((SymbolicEntityId)new ArtifactId(this.name));
        if (existingArtifact != null) {
            this.includeInProjectBuild = existingArtifact.getIncludeInProjectBuild();
        }
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.contextData.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.contextData.putUserData(key, value);
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.externalSource;
    }

    @NotNull
    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public CompositePackagingElement<?> getRootElement() {
        return this.rootElement;
    }

    public boolean isBuildOnMake() {
        return this.includeInProjectBuild;
    }

    @Nullable
    public String getOutputPath() {
        String string;
        String string2 = this.outputUrl.getUrl();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = JpsPathUtil.urlToPath((String)it);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public VirtualFile getOutputFile() {
        return VirtualFileUrls.getVirtualFile((VirtualFileUrl)this.outputUrl);
    }

    @NotNull
    public final VirtualFileUrl getOutputUrl() {
        return this.outputUrl;
    }

    @Nullable
    public String getOutputFilePath() {
        Object object;
        String path2 = JpsPathUtil.urlToPath((String)this.outputUrl.getUrl());
        if (this.rootElement instanceof ArchivePackagingElement) {
            CompositePackagingElement<?> compositePackagingElement = this.rootElement;
            Intrinsics.checkNotNull(compositePackagingElement, (String)"null cannot be cast to non-null type com.intellij.packaging.impl.elements.ArchivePackagingElement");
            object = path2 + "/" + ((ArchivePackagingElement)compositePackagingElement).getArchiveFileName();
        } else {
            object = path2;
        }
        return object;
    }

    public void setBuildOnMake(boolean enabled) {
        this.includeInProjectBuild = enabled;
    }

    public void setOutputPath(@Nullable String outputPath) {
        VirtualFileUrl outputUrl;
        VirtualFileUrl virtualFileUrl;
        String string = outputPath;
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFileUrl = VirtualFileUrlManagerUtil.getInstance((VirtualFileUrlManager.Companion)VirtualFileUrlManager.Companion, (Project)this.project).fromPath(it);
        } else {
            virtualFileUrl = null;
        }
        VirtualFileUrl virtualFileUrl2 = outputUrl = virtualFileUrl;
        Intrinsics.checkNotNull(virtualFileUrl2);
        this.outputUrl = virtualFileUrl2;
    }

    public void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    public void setRootElement(@NotNull CompositePackagingElement<?> root) {
        Intrinsics.checkNotNullParameter(root, (String)"root");
        this.rootElement = root;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<ArtifactPropertiesProvider> getPropertiesProviders() {
        void $this$filterTo$iv$iv;
        List list = ArtifactPropertiesProvider.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProviders(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ArtifactPropertiesProvider it = (ArtifactPropertiesProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isAvailableFor(this.artifactType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public ArtifactProperties<?> getProperties(@NotNull ArtifactPropertiesProvider propertiesProvider) {
        Intrinsics.checkNotNullParameter((Object)propertiesProvider, (String)"propertiesProvider");
        String providerId = propertiesProvider.getId();
        if (!this.artifactProperties.containsKey(providerId) && propertiesProvider.isAvailableFor(this.artifactType)) {
            ArtifactEntity existingArtifact;
            ArtifactEntity artifactEntity2 = existingArtifact = (ArtifactEntity)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().resolve((SymbolicEntityId)new ArtifactId(this.name));
            ArtifactProperties existingProperties = artifactEntity2 != null ? BridgeUtilsKt.getArtifactProperties((ArtifactEntity)artifactEntity2, (ArtifactType)this.artifactType, (ArtifactPropertiesProvider)propertiesProvider) : null;
            ArtifactProperties artifactProperties = existingProperties;
            if (artifactProperties == null) {
                ArtifactProperties artifactProperties2 = propertiesProvider.createProperties(this.artifactType);
                artifactProperties = artifactProperties2;
                Intrinsics.checkNotNullExpressionValue((Object)artifactProperties2, (String)"createProperties(...)");
            }
            ArtifactProperties properties = artifactProperties;
            Intrinsics.checkNotNull((Object)providerId);
            this.artifactProperties.put(providerId, properties);
        }
        return this.artifactProperties.get(providerId);
    }

    public void setProperties(@NotNull ArtifactPropertiesProvider provider, @Nullable ArtifactProperties<?> properties) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Map<String, ArtifactProperties<?>> map = this.artifactProperties;
        String string = provider.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = string;
        ArtifactProperties<?> artifactProperties = properties;
        Intrinsics.checkNotNull(artifactProperties);
        ArtifactProperties<?> artifactProperties2 = artifactProperties;
        map.put(string2, artifactProperties2);
    }

    public void setArtifactType(@NotNull ArtifactType selected) {
        Intrinsics.checkNotNullParameter((Object)selected, (String)"selected");
        this.artifactType = selected;
    }

    @NotNull
    public String toString() {
        return "ImporterModifiableArtifact(name='" + this.name + "')";
    }
}

