/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;

public final class MavenModuleNameMapper {
    public static Map<MavenProject, String> mapModuleNames(Collection<MavenProject> projects, Map<VirtualFile, String> existingPomModuleName) {
        HashMap<MavenProject, String> mavenProjectToModuleName = new HashMap<MavenProject, String>();
        Object[] names = new NameItem[projects.size()];
        int i2 = 0;
        for (MavenProject each : projects) {
            names[i2++] = new NameItem(each, existingPomModuleName.get(each.getFile()));
        }
        Arrays.sort(names);
        HashMap<String, Integer> nameCountersLowerCase = new HashMap<String, Integer>();
        for (i2 = 0; i2 < names.length; ++i2) {
            if (((NameItem)names[i2]).hasDuplicatedGroup) continue;
            for (int k = i2 + 1; k < names.length; ++k) {
                if (!((NameItem)names[i2]).originalName.equalsIgnoreCase(((NameItem)names[k]).originalName)) continue;
                nameCountersLowerCase.put(((NameItem)names[i2]).originalName.toLowerCase(Locale.ROOT), 0);
                if (!((NameItem)names[i2]).groupId.equals(((NameItem)names[k]).groupId)) continue;
                ((NameItem)names[i2]).hasDuplicatedGroup = true;
                ((NameItem)names[k]).hasDuplicatedGroup = true;
            }
        }
        HashSet<String> existingNames = new HashSet<String>();
        for (Object name : names) {
            if (((NameItem)name).existingName == null) continue;
            existingNames.add(((NameItem)name).getResultName());
        }
        for (Object nameItem : names) {
            String name;
            if (((NameItem)nameItem).existingName != null) continue;
            Integer c = (Integer)nameCountersLowerCase.get(((NameItem)nameItem).originalName.toLowerCase(Locale.ROOT));
            if (c != null) {
                ((NameItem)nameItem).number = c;
                nameCountersLowerCase.put(((NameItem)nameItem).originalName.toLowerCase(Locale.ROOT), c + 1);
            }
            while (!existingNames.add(name = ((NameItem)nameItem).getResultName())) {
                ++((NameItem)nameItem).number;
                nameCountersLowerCase.put(((NameItem)nameItem).originalName.toLowerCase(Locale.ROOT), ((NameItem)nameItem).number + 1);
            }
        }
        for (Object each : names) {
            mavenProjectToModuleName.put(((NameItem)each).project, ((NameItem)each).getResultName());
        }
        return mavenProjectToModuleName;
    }

    private static String getDefaultModuleName(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenModuleNameMapper.$$$reportNull$$$0(0);
        }
        String nameTemplate = Registry.stringValue((String)"maven.import.module.name.template");
        String folderName = mavenProject2.getDirectoryFile().getName();
        MavenId mavenId2 = mavenProject2.getMavenId();
        String nameCandidate = switch (nameTemplate) {
            case "folderName" -> folderName;
            case "groupId.artifactId" -> mavenId2.getGroupId() + "." + mavenId2.getArtifactId();
            default -> mavenId2.getArtifactId();
        };
        return MavenModuleNameMapper.isValidName(nameCandidate) ? nameCandidate : folderName;
    }

    private static boolean isValidName(String name) {
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return false;
        }
        if (name.equals("Unknown")) {
            return false;
        }
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char ch = name.charAt(i2);
            if (Character.isDigit(ch) || Character.isLetter(ch) || ch == '-' || ch == '_' || ch == '.') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mavenProject", "org/jetbrains/idea/maven/importing/MavenModuleNameMapper", "getDefaultModuleName"));
    }

    private static class NameItem
    implements Comparable<NameItem> {
        public final MavenProject project;
        public final String existingName;
        public final String originalName;
        public final String groupId;
        public int number = -1;
        public boolean hasDuplicatedGroup;

        private NameItem(MavenProject project2, @Nullable String existingName) {
            this.project = project2;
            this.existingName = existingName;
            this.originalName = this.calcOriginalName();
            String group = project2.getMavenId().getGroupId();
            this.groupId = MavenModuleNameMapper.isValidName(group) ? group : "";
        }

        private String calcOriginalName() {
            if (this.existingName != null) {
                return this.existingName;
            }
            return MavenModuleNameMapper.getDefaultModuleName(this.project);
        }

        public String getResultName() {
            if (this.existingName != null) {
                return this.existingName;
            }
            if (this.number == -1) {
                return this.originalName;
            }
            String result2 = this.originalName + " (" + (this.number + 1) + ")";
            if (!this.hasDuplicatedGroup && !this.groupId.isEmpty()) {
                result2 = result2 + " (" + this.groupId + ")";
            }
            return result2;
        }

        @Override
        public int compareTo(NameItem o) {
            return this.project.getPath().compareToIgnoreCase(o.project.getPath());
        }
    }
}

