/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.exp.TerminalPromptController;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalEnterHandler;", "Lcom/intellij/codeInsight/editorActions/BaseEnterHandler;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "executeWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "intellij.terminal"})
public final class TerminalEnterHandler
extends BaseEnterHandler {
    @NotNull
    private final EditorActionHandler originalHandler;

    public TerminalEnterHandler(@NotNull EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)originalHandler, (String)"originalHandler");
        this.originalHandler = originalHandler;
    }

    public void executeWriteAction(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        int offset;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        TerminalPromptController promptController = TerminalDataContextUtils.INSTANCE.getPromptController(dataContext);
        if (!(promptController == null || (offset = editor.getCaretModel().getOffset()) != 0 && Intrinsics.areEqual((Object)editor.getDocument().getText(new TextRange(offset - 1, offset)), (Object)"\\"))) {
            promptController.handleEnterPressed();
            return;
        }
        this.originalHandler.execute(editor, caret, dataContext);
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Editor editor2 = TerminalDataContextUtils.INSTANCE.getEditor(dataContext);
        return (editor2 != null ? TerminalDataContextUtils.INSTANCE.isPromptEditor(editor2) : false) || this.originalHandler.isEnabled(editor, caret, dataContext);
    }
}

