/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.TtyConnector;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.SimpleTerminalView;
import org.jetbrains.plugins.terminal.exp.TerminalContentView;
import org.jetbrains.plugins.terminal.exp.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.TerminalSession;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/terminal/exp/PlainTerminalView;", "Lorg/jetbrains/plugins/terminal/exp/TerminalContentView;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "preferredFocusableComponent", "getPreferredFocusableComponent", "view", "Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalView;", "addTerminationCallback", "", "onTerminated", "Ljava/lang/Runnable;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "connectToTty", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "Lcom/jediterm/core/util/TermSize;", "dispose", "getTerminalSize", "isFocused", "", "intellij.terminal"})
public final class PlainTerminalView
implements TerminalContentView {
    @NotNull
    private final TerminalSession session;
    @NotNull
    private final SimpleTerminalView view;

    public PlainTerminalView(@NotNull Project project, @NotNull TerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.session = session2;
        TerminalEventsHandler eventsHandler = new TerminalEventsHandler(this.session, settings);
        this.view = new SimpleTerminalView(project, settings, this.session, eventsHandler, false, 16, null);
        this.view.getComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                TermSize termSize = this.getTerminalSize();
                if (termSize == null) {
                    return;
                }
                TermSize newSize = termSize;
                session.postResize(newSize);
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.view);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.view.getComponent();
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        return this.view.getPreferredFocusableComponent();
    }

    @Override
    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        this.session.getController$intellij_terminal().resize(initialTermSize, RequestOrigin.User);
        this.session.start(ttyConnector);
    }

    @Override
    @Nullable
    public TermSize getTerminalSize() {
        if (this.view.getComponent().getBounds().isEmpty()) {
            return null;
        }
        Dimension contentSize = new Dimension(this.view.getTerminalWidth(), this.view.getComponent().getHeight());
        return TerminalUiUtils.INSTANCE.calculateTerminalSize(contentSize, this.view.getCharSize());
    }

    @Override
    public boolean isFocused() {
        return this.view.isFocused();
    }

    @Override
    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.session.addTerminationCallback(onTerminated, parentDisposable);
    }

    public void dispose() {
    }
}

