/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.TerminalSession;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0007H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/exp/CommandHistoryManager;", "", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalSession;)V", "history", "", "", "getHistory", "()Ljava/util/List;", "mutableHistory", "", "initCommandHistory", "", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nCommandHistoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandHistoryManager.kt\norg/jetbrains/plugins/terminal/exp/CommandHistoryManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1603#2,9:53\n1855#2:62\n1856#2:71\n1612#2:72\n124#3:63\n113#3,5:64\n1#4:69\n1#4:70\n*S KotlinDebug\n*F\n+ 1 CommandHistoryManager.kt\norg/jetbrains/plugins/terminal/exp/CommandHistoryManager\n*L\n37#1:53,9\n37#1:62\n37#1:71\n37#1:72\n40#1:63\n40#1:64,5\n37#1:70\n*E\n"})
public final class CommandHistoryManager {
    @NotNull
    private final Set<String> mutableHistory;

    public CommandHistoryManager(@NotNull TerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.mutableHistory = set;
        TerminalSession.addCommandListener$default(session2, new ShellCommandListener(){

            @Override
            public void commandHistoryReceived(@NotNull String history) {
                Intrinsics.checkNotNullParameter((Object)history, (String)"history");
                this.initCommandHistory(history);
            }

            @Override
            public void commandStarted(@NotNull String command) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                String trimmedCommand = ((Object)StringsKt.trim((CharSequence)command)).toString();
                if (((CharSequence)trimmedCommand).length() > 0) {
                    mutableHistory.remove(trimmedCommand);
                    mutableHistory.add(trimmedCommand);
                }
            }
        }, null, 2, null);
    }

    @NotNull
    public final List<String> getHistory() {
        return CollectionsKt.toList((Iterable)this.mutableHistory);
    }

    /*
     * WARNING - void declaration
     */
    private final void initCommandHistory(String history) {
        void $this$mapNotNullTo$iv$iv;
        if (!((Collection)this.mutableHistory).isEmpty()) {
            return;
        }
        String[] stringArray = new String[]{"\n"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)history, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            CharSequence charSequence;
            String string;
            block4: {
                void $this$trimStart$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String row = (String)element$iv$iv;
                boolean bl2 = false;
                string = ((Object)StringsKt.trimStart((CharSequence)row)).toString();
                boolean $i$f$trimStart = false;
                CharSequence $this$trimStart$iv$iv = (CharSequence)$this$trimStart$iv;
                boolean $i$f$trimStart2 = false;
                int n = $this$trimStart$iv$iv.length();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                    boolean bl3 = false;
                    if (Character.isDigit(it)) continue;
                    charSequence = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                    break block4;
                }
                charSequence = "";
            }
            String it = string = ((Object)StringsKt.trim((CharSequence)((Object)charSequence).toString())).toString();
            boolean bl = false;
            if ((((CharSequence)it).length() > 0 ? string : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List unsortedHistory = (List)destination$iv$iv;
        LinkedHashSet historySet = new LinkedHashSet();
        for (int ind = unsortedHistory.size() - 1; -1 < ind; --ind) {
            historySet.add(unsortedHistory.get(ind));
        }
        List reversedHistory = CollectionsKt.reversed((Iterable)historySet);
        this.mutableHistory.addAll(reversedHistory);
    }
}

