/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalCommandHandlerCustomizer;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;
import org.jetbrains.plugins.terminal.action.TerminalAdvancedSettingToggleAction;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;

public final class TerminalToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NonNls
    public static final String TOOL_WINDOW_ID = "Terminal";

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            TerminalToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            TerminalToolWindowFactory.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        TerminalToolWindowManager terminalToolWindowManager = TerminalToolWindowManager.getInstance(project);
        terminalToolWindowManager.initToolWindow((ToolWindowEx)toolWindow);
        TerminalCommandHandlerCustomizer.TerminalCommandHandlerOptions options = new TerminalCommandHandlerCustomizer.TerminalCommandHandlerOptions(project);
        toolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new SmartCommandExecutionToggleAction(options), new TerminalAdvancedSettingToggleAction("terminal.use.1.0.line.spacing.for.alternative.screen.buffer"), new TerminalAdvancedSettingToggleAction("terminal.fill.character.background.including.line.spacing")}));
        TerminalArrangementManager terminalArrangementManager = TerminalArrangementManager.getInstance(project);
        terminalToolWindowManager.restoreTabs(terminalArrangementManager.getArrangementState());
        terminalArrangementManager.setToolWindow(toolWindow);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "toolWindow";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowFactory";
        objectArray[2] = "createToolWindowContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SmartCommandExecutionToggleAction
    extends DumbAwareToggleAction {
        private final TerminalCommandHandlerCustomizer.TerminalCommandHandlerOptions myOptions;

        private SmartCommandExecutionToggleAction(TerminalCommandHandlerCustomizer.TerminalCommandHandlerOptions options) {
            super(TerminalBundle.message("settings.terminal.smart.command.handling", new Object[0]));
            this.myOptions = options;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SmartCommandExecutionToggleAction.$$$reportNull$$$0(0);
            }
            return this.myOptions.getEnabled();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SmartCommandExecutionToggleAction.$$$reportNull$$$0(1);
            }
            this.myOptions.setEnabled(state);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SmartCommandExecutionToggleAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalToolWindowFactory$SmartCommandExecutionToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowFactory$SmartCommandExecutionToggleAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

