/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogAppConnectionSettings;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.InternalDataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogStatisticsService;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class EventLogInternalApplicationInfo
implements EventLogApplicationInfo {
    private static final DataCollectorDebugLogger LOG = new InternalDataCollectorDebugLogger(Logger.getInstance(EventLogStatisticsService.class));
    private static final String EVENT_LOG_SETTINGS_URL_TEMPLATE = "https://resources.jetbrains.com/storage/fus/config/v4/%s/%s.json";
    private final boolean myIsTestSendEndpoint;
    private final boolean myIsTestConfig;
    private final DataCollectorSystemEventLogger myEventLogger;
    private final EventLogAppConnectionSettings myConnectionSettings;

    public EventLogInternalApplicationInfo(boolean isTestConfig, boolean isTestSendEndpoint) {
        this.myIsTestConfig = isTestConfig;
        this.myIsTestSendEndpoint = isTestSendEndpoint;
        this.myConnectionSettings = new EventLogAppConnectionSettings();
        this.myEventLogger = new DataCollectorSystemEventLogger(){

            @Override
            public void logErrorEvent(@NotNull String recorderId, @NotNull String eventId, @NotNull Throwable exception) {
                if (recorderId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (eventId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (exception == null) {
                    1.$$$reportNull$$$0(2);
                }
                EventLogSystemLogger.logSystemError(recorderId, eventId, exception.getClass().getName(), -1L);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "recorderId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "eventId";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "exception";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/eventLog/EventLogInternalApplicationInfo$1";
                objectArray[2] = "logErrorEvent";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public String getTemplateUrl() {
        return EVENT_LOG_SETTINGS_URL_TEMPLATE;
    }

    @Override
    @NotNull
    public String getProductCode() {
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        if (string == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getProductVersion() {
        ApplicationInfo info = ApplicationInfo.getInstance();
        String string = info.getMajorVersion() + "." + info.getMinorVersion();
        if (string == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public int getBaselineVersion() {
        ApplicationInfo info = ApplicationInfo.getInstance();
        return info.getBuild().getBaselineVersion();
    }

    @Override
    @NotNull
    public EventLogConnectionSettings getConnectionSettings() {
        EventLogAppConnectionSettings eventLogAppConnectionSettings = this.myConnectionSettings;
        if (eventLogAppConnectionSettings == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(2);
        }
        return eventLogAppConnectionSettings;
    }

    @Override
    public boolean isInternal() {
        return StatisticsUploadAssistant.isTestStatisticsEnabled();
    }

    @Override
    public boolean isTestConfig() {
        return this.myIsTestConfig;
    }

    @Override
    public boolean isTestSendEndpoint() {
        return this.myIsTestSendEndpoint;
    }

    @Override
    public boolean isEAP() {
        return ApplicationManager.getApplication().isEAP();
    }

    @Override
    @NotNull
    public DataCollectorDebugLogger getLogger() {
        DataCollectorDebugLogger dataCollectorDebugLogger = LOG;
        if (dataCollectorDebugLogger == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(3);
        }
        return dataCollectorDebugLogger;
    }

    @Override
    @NotNull
    public DataCollectorSystemEventLogger getEventLogger() {
        DataCollectorSystemEventLogger dataCollectorSystemEventLogger = this.myEventLogger;
        if (dataCollectorSystemEventLogger == null) {
            EventLogInternalApplicationInfo.$$$reportNull$$$0(4);
        }
        return dataCollectorSystemEventLogger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/eventLog/EventLogInternalApplicationInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductCode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProductVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventLogger";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

