/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public final class TextMateSelectorLexer {
    public static List<TextMateSelectorToken> tokenize(@NotNull CharSequence selector) {
        if (selector == null) {
            TextMateSelectorLexer.$$$reportNull$$$0(0);
        }
        ArrayList<TextMateSelectorToken> result = new ArrayList<TextMateSelectorToken>();
        StringBuilder currentSelector = new StringBuilder();
        for (int i = 0; i < selector.length(); ++i) {
            char c = selector.charAt(i);
            if (c == '(') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.LPAREN);
                continue;
            }
            if (c == ')') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.RPAREN);
                continue;
            }
            if (c == ',') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.COMMA);
                continue;
            }
            if (c == '|') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.PIPE);
                continue;
            }
            if (c == '^') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.HAT);
                continue;
            }
            if (c == '-' && currentSelector.isEmpty()) {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                result.add(TextMateSelectorToken.MINUS);
                continue;
            }
            if (c == ' ') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                continue;
            }
            if ((c == 'R' || c == 'L' || c == 'B') && i + 1 < selector.length() && selector.charAt(i + 1) == ':') {
                currentSelector = TextMateSelectorLexer.addPendingToken(result, currentSelector);
                ++i;
                if (c == 'R') {
                    result.add(new PriorityToken(TextMateWeigh.Priority.LOW));
                    continue;
                }
                if (c != 'L') continue;
                result.add(new PriorityToken(TextMateWeigh.Priority.HIGH));
                continue;
            }
            currentSelector.append(c);
        }
        TextMateSelectorLexer.addPendingToken(result, currentSelector);
        return result;
    }

    @NotNull
    private static StringBuilder addPendingToken(ArrayList<TextMateSelectorToken> result, StringBuilder currentSelector) {
        if (!currentSelector.isEmpty()) {
            result.add(new SelectorToken(currentSelector.toString()));
            return new StringBuilder();
        }
        StringBuilder stringBuilder = currentSelector;
        if (stringBuilder == null) {
            TextMateSelectorLexer.$$$reportNull$$$0(1);
        }
        return stringBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addPendingToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static final class PriorityToken
    implements TextMateSelectorToken {
        private final TextMateWeigh.Priority myPriority;

        public PriorityToken(TextMateWeigh.Priority priority) {
            this.myPriority = priority;
        }

        public TextMateWeigh.Priority getPriority() {
            return this.myPriority;
        }

        public String toString() {
            return this.myPriority.name();
        }
    }

    public static final class SelectorToken
    implements TextMateSelectorToken {
        private final String myText;

        public SelectorToken(String text) {
            this.myText = text;
        }

        public String getText() {
            return this.myText;
        }

        public String toString() {
            return this.myText;
        }
    }

    public static final class SignToken
    implements TextMateSelectorToken {
        private final char mySign;

        public SignToken(char c) {
            this.mySign = c;
        }

        public String toString() {
            return String.valueOf(this.mySign);
        }
    }
}

