/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.configuration.TextMateBundlesListPanel;
import org.jetbrains.plugins.textmate.configuration.TextMateConfigurableBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0014\u0010\u000f\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel;", "Lcom/intellij/openapi/Disposable;", "()V", "myBundlesList", "Lcom/intellij/ui/CheckBoxList;", "Lorg/jetbrains/plugins/textmate/configuration/TextMateConfigurableBundle;", "createMainComponent", "Ljavax/swing/JPanel;", "dispose", "", "getState", "", "isModified", "", "bundles", "setState", "", "Companion", "intellij.textmate"})
public final class TextMateBundlesListPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CheckBoxList<TextMateConfigurableBundle> myBundlesList = (CheckBoxList)new CheckBoxList<TextMateConfigurableBundle>(){
        {
            this.setSelectionMode(2);
            ListSpeedSearch.installOn((JList)((JList)((Object)this)), arg_0 -> 1._init_$lambda$0(1.INSTANCE, arg_0));
        }

        @Nullable
        protected String getSecondaryText(int index) {
            String string;
            TextMateConfigurableBundle textMateConfigurableBundle = (TextMateConfigurableBundle)this.getItemAt(index);
            if (textMateConfigurableBundle != null) {
                TextMateConfigurableBundle bundle = textMateConfigurableBundle;
                boolean bl = false;
                string = bundle.getBuiltin() ? TextMateBundle.message("title.built.in", new Object[0]) : PathUtil.toSystemDependentName((String)bundle.getPath());
            } else {
                string = null;
            }
            return string;
        }

        private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }
    };
    @NotNull
    private static final String TEXTMATE_LAST_ADDED_BUNDLE = "textmate.last.added.bundle";

    @NotNull
    public final Set<TextMateConfigurableBundle> getState() {
        Set result = new HashSet();
        int n = this.myBundlesList.getItemsCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.myBundlesList.getItemAt(i);
            Intrinsics.checkNotNull((Object)object);
            result.add(TextMateConfigurableBundle.copy$default((TextMateConfigurableBundle)object, null, null, this.myBundlesList.isItemSelected(i), false, 11, null));
        }
        return result;
    }

    public final void setState(@NotNull Collection<TextMateConfigurableBundle> bundles) {
        Intrinsics.checkNotNullParameter(bundles, (String)"bundles");
        this.myBundlesList.clear();
        Iterable iterable = bundles;
        Comparator comparator = NaturalComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"INSTANCE");
        Comparator comparator2 = comparator;
        for (TextMateConfigurableBundle bean : CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(comparator2){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                TextMateConfigurableBundle textMateConfigurableBundle = (TextMateConfigurableBundle)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                TextMateConfigurableBundle p0 = (TextMateConfigurableBundle)b;
                String string = p0.getName();
                bl = false;
                String string2 = p0.getName();
                return comparator.compare(string, string2);
            }
        })) {
            this.myBundlesList.addItem((Object)bean, bean.getName(), bean.getEnabled());
        }
    }

    @NotNull
    public final JPanel createMainComponent() {
        return (JPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ TextMateBundlesListPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)createMainComponent.1.INSTANCE, (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ TextMateBundlesListPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)ToolbarDecorator.createDecorator((JList)((JList)TextMateBundlesListPanel.access$getMyBundlesList$p(this.this$0))).setRemoveAction(arg_0 -> createMainComponent.2.invoke$lambda$0(this.this$0, arg_0)).setAddAction(arg_0 -> createMainComponent.2.invoke$lambda$5(this.this$0, $this$row, arg_0)).setRemoveActionUpdater(arg_0 -> createMainComponent.2.invoke$lambda$6(this.this$0, arg_0)).disableUpDownActions().createPanel()).align(Align.FILL);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private static final void invoke$lambda$0(TextMateBundlesListPanel this$0, AnActionButton it) {
                        void $this$filterIsInstanceTo$iv$iv;
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        List list = TextMateBundlesListPanel.access$getMyBundlesList$p(this$0).getSelectedValuesList();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedValuesList(...)");
                        Object[] $this$filterIsInstance$iv = (Object[])list;
                        boolean $i$f$filterIsInstance = false;
                        Object[] objectArray = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof JCheckBox)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List bundlesToDelete = (List)destination$iv$iv;
                        if (!((Collection)bundlesToDelete).isEmpty()) {
                            String message2 = CollectionsKt.joinToString$default((Iterable)bundlesToDelete, (CharSequence)"\n", null, null, (int)0, null, (Function1)createMainComponent.1.message.1.INSTANCE, (int)30, null);
                            objectArray = new Object[]{bundlesToDelete.size()};
                            String string = TextMateBundle.message("textmate.remove.title", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            MessageDialogBuilder.YesNo yesNo = MessageDialogBuilder.Companion.yesNo(string, message2);
                            String string2 = CommonBundle.message((String)"button.remove", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                            MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string2);
                            String string3 = CommonBundle.getCancelButtonText();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getCancelButtonText(...)");
                            if (((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)yesNo2.noText(string3)).icon(null)).ask((Component)TextMateBundlesListPanel.access$getMyBundlesList$p(this$0))) {
                                ListUtil.removeSelectedItems((JList)((JList)TextMateBundlesListPanel.access$getMyBundlesList$p(this$0)));
                            }
                        }
                    }

                    private static final boolean invoke$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        return (Boolean)$tmp0.invoke(p0);
                    }

                    private static final TextMateBundleReader invoke$lambda$5$lambda$3(VirtualFile $bundleDirectory) {
                        return TextMateService.getInstance().readBundle($bundleDirectory.toNioPath());
                    }

                    private static final void invoke$lambda$5(TextMateBundlesListPanel this$0, Row $this_row, AnActionButton it) {
                        VirtualFile virtualFile;
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$this_row, (String)"$this_row");
                        String string = PropertiesComponent.getInstance().getValue("textmate.last.added.bundle");
                        if (string != null) {
                            String lastAddedBundlePath = string;
                            boolean bl = false;
                            virtualFile = LocalFileSystem.getInstance().findFileByPath(lastAddedBundlePath);
                        } else {
                            virtualFile = null;
                        }
                        VirtualFile fileToSelect = virtualFile;
                        FileChooserDescriptor chooserDescriptor2 = new FileChooserDescriptor(true, true, false, false, false, true).withFileFilter(arg_0 -> createMainComponent.2.invoke$lambda$5$lambda$2(createMainComponent.2.chooserDescriptor.1.INSTANCE, arg_0));
                        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor2, (Component)((Component)TextMateBundlesListPanel.access$getMyBundlesList$p(this$0)), null, (VirtualFile)fileToSelect);
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"chooseFiles(...)");
                        VirtualFile[] bundleDirectories = virtualFileArray;
                        if (!(bundleDirectories.length == 0)) {
                            String errorMessage = null;
                            for (VirtualFile bundleDirectory : bundleDirectories) {
                                Object $this$invoke_u24lambda_u245_u24lambda_u244;
                                PropertiesComponent.getInstance().setValue("textmate.last.added.bundle", bundleDirectory.getPath());
                                ThrowableComputable readBundleProcess = () -> createMainComponent.2.invoke$lambda$5$lambda$3(bundleDirectory);
                                Object[] objectArray = $this_row;
                                try {
                                    $this$invoke_u24lambda_u245_u24lambda_u244 = objectArray;
                                    boolean bl = false;
                                    $this$invoke_u24lambda_u245_u24lambda_u244 = Result.constructor-impl((Object)((TextMateBundleReader)ProgressManager.getInstance().runProcessWithProgressSynchronously(readBundleProcess, TextMateBundle.message("button.add.bundle", new Object[0]), true, null)));
                                }
                                catch (Throwable bl) {
                                    $this$invoke_u24lambda_u245_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                                }
                                objectArray = $this$invoke_u24lambda_u245_u24lambda_u244;
                                TextMateBundleReader bundleReader = (TextMateBundleReader)(Result.isFailure-impl((Object)objectArray) ? null : objectArray);
                                if (bundleReader != null) {
                                    String bundleDirectoryPath;
                                    Intrinsics.checkNotNullExpressionValue((Object)bundleDirectory.getPath(), (String)"getPath(...)");
                                    boolean alreadyAdded = false;
                                    int n = TextMateBundlesListPanel.access$getMyBundlesList$p(this$0).getItemsCount();
                                    for (int i = 0; i < n; ++i) {
                                        TextMateConfigurableBundle item = (TextMateConfigurableBundle)TextMateBundlesListPanel.access$getMyBundlesList$p(this$0).getItemAt(i);
                                        if (item == null || !Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)bundleDirectoryPath), (Object)item.getPath())) continue;
                                        TextMateBundlesListPanel.access$getMyBundlesList$p(this$0).clearSelection();
                                        TextMateBundlesListPanel.access$getMyBundlesList$p(this$0).setSelectedIndex(i);
                                        UIUtil.scrollListToVisibleIfNeeded((JList)((JList)TextMateBundlesListPanel.access$getMyBundlesList$p(this$0)));
                                        alreadyAdded = true;
                                        break;
                                    }
                                    if (alreadyAdded) continue;
                                    TextMateConfigurableBundle item = new TextMateConfigurableBundle(bundleReader.getBundleName(), bundleDirectoryPath, true, false);
                                    TextMateBundlesListPanel.access$getMyBundlesList$p(this$0).addItem((Object)item, item.getName(), true);
                                    continue;
                                }
                                objectArray = new Object[]{bundleDirectory.getPresentableUrl()};
                                errorMessage = TextMateBundle.message("message.textmate.bundle.error", objectArray);
                            }
                            if (errorMessage != null) {
                                Messages.showErrorDialog(errorMessage, (String)TextMateBundle.message("title.textmate.bundle.error", new Object[0]));
                            }
                        }
                    }

                    private static final boolean invoke$lambda$6(TextMateBundlesListPanel this$0, AnActionEvent it) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        int[] nArray = TextMateBundlesListPanel.access$getMyBundlesList$p(this$0).getSelectedIndices();
                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedIndices(...)");
                        for (int index : nArray) {
                            TextMateConfigurableBundle bean;
                            TextMateConfigurableBundle textMateConfigurableBundle = bean = (TextMateConfigurableBundle)TextMateBundlesListPanel.access$getMyBundlesList$p(this$0).getItemAt(index);
                            Intrinsics.checkNotNull((Object)textMateConfigurableBundle);
                            if (!textMateConfigurableBundle.getBuiltin()) continue;
                            return false;
                        }
                        return true;
                    }
                }), (int)1, null).resizableRow();
            }
        }));
    }

    public final boolean isModified(@NotNull Set<TextMateConfigurableBundle> bundles) {
        Intrinsics.checkNotNullParameter(bundles, (String)"bundles");
        return !Intrinsics.areEqual(this.getState(), bundles);
    }

    public void dispose() {
    }

    public static final /* synthetic */ CheckBoxList access$getMyBundlesList$p(TextMateBundlesListPanel $this) {
        return $this.myBundlesList;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel$Companion;", "", "()V", "TEXTMATE_LAST_ADDED_BUNDLE", "", "intellij.textmate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

