/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.ssh.impl.sshj.PlatformAuthPublickey;
import com.intellij.ssh.impl.sshj.SshjConnectionUtilKt;
import com.intellij.ssh.impl.sshj.UtilKt;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.userauth.UserAuth;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AuthMethod;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\"\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J>\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ssh/impl/sshj/AuthMethodGroup;", "", "reusable", "", "(Z)V", "queue", "Ljava/util/ArrayDeque;", "Lnet/schmizz/sshj/userauth/method/AuthMethod;", "triedReusableMethods", "Ljava/util/IdentityHashMap;", "add", "", "authMethod", "authenticate", "Lcom/intellij/ssh/impl/sshj/AuthMethodGroup$AuthResult;", "briefInfo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sshClient", "Lnet/schmizz/sshj/SSHClient;", "username", "", "authenticateMethod", "userAuth", "Lnet/schmizz/sshj/userauth/UserAuth;", "service", "Lnet/schmizz/sshj/Service;", "method", "timeoutMs", "", "AuthResult", "intellij.platform.ssh"})
final class AuthMethodGroup {
    private final boolean reusable;
    @NotNull
    private final ArrayDeque<AuthMethod> queue;
    @NotNull
    private final IdentityHashMap<AuthMethod, Boolean> triedReusableMethods;

    public AuthMethodGroup(boolean reusable) {
        this.reusable = reusable;
        this.queue = new ArrayDeque();
        this.triedReusableMethods = new IdentityHashMap();
    }

    public final void add(@NotNull AuthMethod authMethod) {
        Intrinsics.checkNotNullParameter((Object)authMethod, (String)"authMethod");
        this.queue.add(authMethod);
    }

    @NotNull
    public final AuthResult authenticate(@NotNull StringBuilder briefInfo, @NotNull SSHClient sshClient, @NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)briefInfo, (String)"briefInfo");
        Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        UserAuth userAuth = sshClient.getUserAuth();
        Service service = (Service)Service.class.cast(sshClient.getConnection());
        int timeoutMs = sshClient.getTransport().getTimeoutMs();
        AuthResult result2 = AuthResult.WASTED;
        while (!((Collection)this.queue).isEmpty() && result2 != AuthResult.SUCCESS && result2 != AuthResult.PARTIAL_SUCCESS) {
            AuthMethod method = this.queue.removeFirst();
            if (!((Map)this.triedReusableMethods).containsKey(method)) {
                PlatformAuthPublickey.ValidationResult validity;
                StringBuilder stringBuilder = briefInfo.append("\n  => ");
                Intrinsics.checkNotNull((Object)method);
                stringBuilder.append(SshjConnectionUtilKt.access$getDescriptiveName(method)).append(" (");
                PlatformAuthPublickey platformAuthPublickey = method instanceof PlatformAuthPublickey ? (PlatformAuthPublickey)method : null;
                PlatformAuthPublickey.ValidationResult validationResult = validity = platformAuthPublickey != null ? platformAuthPublickey.checkValidity() : null;
                result2 = switch (validationResult == null ? -1 : WhenMappings.$EnumSwitchMapping$0[validationResult.ordinal()]) {
                    case -1, 1 -> {
                        Intrinsics.checkNotNull((Object)userAuth);
                        yield this.authenticateMethod(userAuth, username, service, method, timeoutMs, briefInfo);
                    }
                    case 2, 3, 4 -> {
                        briefInfo.append(validity.getDescription());
                        yield AuthResult.FAILURE;
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
                briefInfo.append(")");
                continue;
            }
            result2 = AuthResult.FAILURE;
        }
        return result2;
    }

    private final AuthResult authenticateMethod(UserAuth userAuth, String username, Service service, AuthMethod method, int timeoutMs, StringBuilder briefInfo) {
        AuthResult result2 = AuthResult.FAILURE;
        try {
            if (userAuth.authenticate(username, service, method, timeoutMs)) {
                briefInfo.append("success");
                result2 = AuthResult.SUCCESS;
            } else {
                if (userAuth.hadPartialSuccess()) {
                    briefInfo.append("partial success");
                    this.triedReusableMethods.clear();
                    result2 = AuthResult.PARTIAL_SUCCESS;
                } else {
                    briefInfo.append("failure");
                }
                StringBuilder stringBuilder = briefInfo.append(", new auth methods allowed by the server: ");
                Collection collection = userAuth.getAllowedMethods();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllowedMethods(...)");
                stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, null, (int)63, null));
            }
            if (this.reusable) {
                ((Map)this.triedReusableMethods).put(method, true);
                this.queue.addLast(method);
            } else if (result2 != AuthResult.SUCCESS && method.shouldRetry()) {
                this.queue.addFirst(method);
            }
        }
        catch (UserAuthException e) {
            UtilKt.getSSHJ_LOG().warn("While was authenticating " + method, (Throwable)e);
            briefInfo.append("user auth exception: " + e.getMessage());
        }
        catch (Throwable e) {
            briefInfo.append("exception: " + e.getMessage());
            throw e;
        }
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ssh/impl/sshj/AuthMethodGroup$AuthResult;", "", "(Ljava/lang/String;I)V", "SUCCESS", "PARTIAL_SUCCESS", "FAILURE", "WASTED", "intellij.platform.ssh"})
    public static final class AuthResult
    extends Enum<AuthResult> {
        public static final /* enum */ AuthResult SUCCESS = new AuthResult();
        public static final /* enum */ AuthResult PARTIAL_SUCCESS = new AuthResult();
        public static final /* enum */ AuthResult FAILURE = new AuthResult();
        public static final /* enum */ AuthResult WASTED = new AuthResult();
        private static final /* synthetic */ AuthResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AuthResult[] values() {
            return (AuthResult[])$VALUES.clone();
        }

        public static AuthResult valueOf(String value) {
            return Enum.valueOf(AuthResult.class, value);
        }

        @NotNull
        public static EnumEntries<AuthResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = authResultArray = new AuthResult[]{AuthResult.SUCCESS, AuthResult.PARTIAL_SUCCESS, AuthResult.FAILURE, AuthResult.WASTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlatformAuthPublickey.ValidationResult.values().length];
            try {
                nArray[PlatformAuthPublickey.ValidationResult.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformAuthPublickey.ValidationResult.CORRUPTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformAuthPublickey.ValidationResult.EMPTY_PASSWORD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformAuthPublickey.ValidationResult.WRONG_PASSPHRASE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

