/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelBase;
import com.intellij.packageChecker.python.PythonBuildFileProvider;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u001bH&J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\f2\u0006\u0010\u0013\u001a\u00020\u0019H&J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/packageChecker/python/PyPIProjectDependenciesModel;", "Lcom/intellij/packageChecker/model/impl/ProjectDependenciesModelBase;", "Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildFileName", "", "getBuildFileName", "()Ljava/lang/String;", "importedPackages", "", "Lcom/jetbrains/python/packaging/PyPackage;", "getImportedPackages", "()Ljava/util/List;", "setImportedPackages", "(Ljava/util/List;)V", "copyModule", "module", "newDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "findBuildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/module/Module;", "findCorrespondingBuildFileProvider", "Lcom/intellij/packageChecker/api/BuildFileProvider;", "getAllImported", "getAllModules", "getBuildFileSpecificRequirements", "Lcom/jetbrains/python/packaging/PyRequirement;", "supports", "", "intellij.packageChecker.python"})
@SourceDebugExtension(value={"SMAP\nPyPIProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPIProjectDependenciesModel.kt\ncom/intellij/packageChecker/python/PyPIProjectDependenciesModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n11383#2,9:93\n13309#2:102\n13310#2:104\n11392#2:105\n11383#2,9:106\n13309#2:115\n13310#2:117\n11392#2:118\n1#3:103\n1#3:116\n766#4:119\n857#4,2:120\n1360#4:122\n1446#4,5:123\n*S KotlinDebug\n*F\n+ 1 PyPIProjectDependenciesModel.kt\ncom/intellij/packageChecker/python/PyPIProjectDependenciesModel\n*L\n50#1:93,9\n50#1:102\n50#1:104\n50#1:105\n75#1:106,9\n75#1:115\n75#1:117\n75#1:118\n50#1:103\n75#1:116\n78#1:119\n78#1:120,2\n83#1:122\n83#1:123,5\n*E\n"})
public abstract class PyPIProjectDependenciesModel
extends ProjectDependenciesModelBase<MutableModuleModel>
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private List<PyPackage> importedPackages;

    public PyPIProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableJob completableJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        String string = PyPIProjectDependenciesModel.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        super(completableJob.plus((CoroutineContext)new CoroutineName(string)));
        this.project = project;
        this.init();
        this.importedPackages = CollectionsKt.emptyList();
    }

    @NotNull
    public final List<PyPackage> getImportedPackages() {
        return this.importedPackages;
    }

    public final void setImportedPackages(@NotNull List<PyPackage> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.importedPackages = list;
    }

    @NotNull
    public abstract String getBuildFileName();

    @Nullable
    public abstract VirtualFile findBuildFile(@NotNull Module var1);

    @NotNull
    public abstract List<PyRequirement> getBuildFileSpecificRequirements(@NotNull Module var1);

    @NotNull
    public abstract BuildFileProvider findCorrespondingBuildFileProvider();

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectDependenciesModelBase.Companion.isModelSupportedByProject(project, this.getBuildFileName());
    }

    @Override
    @NotNull
    protected MutableModuleModel copyModule(@NotNull MutableModuleModel module, @NotNull Iterable<Dependency> newDependencies) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(newDependencies, (String)"newDependencies");
        return module.withDependencies(newDependencies);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MutableModuleModel> getAllModules() {
        List list;
        void $this$mapNotNullTo$iv$iv;
        Module[] $this$mapNotNull$iv = ModuleManager.Companion.getInstance(this.project).getModules();
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            MutableModuleModel mutableModuleModel;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void module = element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            if (this.findBuildFile((Module)module) == null) {
                mutableModuleModel = null;
            } else {
                VirtualFile buildFile;
                ProgressManager.checkCanceled();
                List<Pair<PyRequirement, PyPackage>> importedModuleDependencies = ((PythonBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(PythonBuildFileProvider.class, (AreaInstance)this.project)).getMatchingImported(this.getBuildFileSpecificRequirements((Module)module));
                List<Dependency> dependencies2 = PythonBuildFileProvider.Companion.getDependenciesFromMatchingImported(importedModuleDependencies);
                String string = module.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                mutableModuleModel = new MutableModuleModel(string, (Module)module, buildFile, CollectionsKt.toSet((Iterable)dependencies2), this.project);
            }
            if (mutableModuleModel == null) continue;
            MutableModuleModel it$iv$iv = mutableModuleModel;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        this.importedPackages = this.getAllImported();
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PyPackage> getAllImported() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        if (this.project.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        Module[] $this$mapNotNull$iv = PyStatisticToolsKt.getModules((Project)this.project);
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Iterable<Sdk> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Sdk it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void module = element$iv$iv;
            boolean bl2 = false;
            if (PythonSdkUtil.findPythonSdk((Module)module) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List applicableSdk = (List)destination$iv$iv;
        Iterable $this$filter$iv = applicableSdk;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sdk sdk = (Sdk)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            VirtualFile virtualFile = sdk.getHomeDirectory();
            boolean bl4 = (virtualFile != null ? virtualFile.exists() : false) && PyPackageUtil.packageManagementEnabled((Sdk)sdk, (boolean)false, (boolean)false);
            if (!bl4) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List filteredSdks = (List)destination$iv$iv2;
        Iterable $this$flatMap$iv = filteredSdks;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            Sdk sdk = (Sdk)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            try {
                list = PyPackageManager.getInstance((Sdk)sdk).refreshAndGetPackages(false);
                Intrinsics.checkNotNull((Object)list);
            }
            catch (ExecutionException e) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }
}

