/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.java.BuildFileProviderBase;
import com.intellij.packageChecker.java.IntellijModuleProjectDependenciesModel;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.java.JpsBuildFileProviderKt;
import com.intellij.packageChecker.model.ProjectDependenciesModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00152\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/packageChecker/java/JpsBuildFileProvider;", "Lcom/intellij/packageChecker/java/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "collectPackages", "", "Lorg/jetbrains/security/package/Package;", "module", "Lcom/intellij/openapi/module/Module;", "declaredPackages", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "file", "Lcom/intellij/psi/PsiFile;", "findModuleForFile", "getModule", "getRoots", "", "pkgs", "importedPackages", "moduleScript", "supports", "", "supportsFixes", "intellij.packageChecker.java"})
@SourceDebugExtension(value={"SMAP\nJpsBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsBuildFileProvider.kt\ncom/intellij/packageChecker/java/JpsBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n1271#2,2:81\n1285#2,4:83\n*S KotlinDebug\n*F\n+ 1 JpsBuildFileProvider.kt\ncom/intellij/packageChecker/java/JpsBuildFileProvider\n*L\n38#1:77\n38#1:78,3\n55#1:81,2\n55#1:83,4\n*E\n"})
public final class JpsBuildFileProvider
extends BuildFileProviderBase {
    @NotNull
    private final String id;

    public JpsBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.id = "jps";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Module getModule(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = this.findModuleForFile(file2);
        if (module == null) {
            JpsBuildFileProviderKt.access$getLogger$p().warn("Not a Jps module by file: " + file2.getName());
        }
        return module;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = module.getModuleFile();
        if (virtualFile != null) {
            VirtualFile moduleFile = virtualFile;
            boolean bl = false;
            if (this.getProject().isDisposed() || !moduleFile.isValid()) {
                return null;
            }
            psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(moduleFile);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PackageDeclaration> declaredPackages(@Nullable PsiFile file2, @NotNull Module module) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (file2 == null) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = this.collectPackages(module);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PackageDeclaration((Package)it, (PsiElement)file2, null, 4, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = this.findModuleForFile(file2);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        return this.collectPackages(module2);
    }

    @Override
    public boolean supports(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return Intrinsics.areEqual((Object)file2.getFileType(), (Object)ModuleFileType.INSTANCE);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ((IntellijModuleProjectDependenciesModel)ProjectDependenciesModel.Companion.getEP_NAME().findExtensionOrFail(IntellijModuleProjectDependenciesModel.class, (AreaInstance)this.getProject())).shouldProcess(module);
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file2, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        Module module = ModuleUtil.findModuleForFile((PsiFile)file2);
        if (module == null) {
            return MapsKt.emptyMap();
        }
        Module module2 = module;
        Iterable $this$associateWith$iv = this.collectPackages(module2);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Package package_ = (Package)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            map2.put(t, list);
        }
        return result$iv;
    }

    @Override
    public boolean supportsFixes() {
        return false;
    }

    private final Module findModuleForFile(PsiFile file2) {
        return ModuleUtil.findModuleForFile((PsiFile)file2);
    }

    private final List<Package> collectPackages(Module module) {
        List packages = new ArrayList();
        if (module.isDisposed()) {
            return packages;
        }
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> JpsBuildFileProvider.collectPackages$lambda$3((Function1)new Function1<Library, Boolean>((List<Package>)packages){
            final /* synthetic */ List<Package> $packages;
            {
                this.$packages = $packages;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Library it) {
                Intrinsics.checkNotNull((Object)it);
                Package pkg = JavaPackageUtilKt.createPackage(it);
                if (pkg != null) {
                    this.$packages.add(pkg);
                }
                return true;
            }
        }, arg_0));
        return packages;
    }

    private static final boolean collectPackages$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

