/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.gradle.workaround;

import com.intellij.packageChecker.gradle.workaround.GradleCommonUtilsKt;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteralContainer;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrStringImpl;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/packageChecker/gradle/workaround/GradleGroovyVulnerablePackageFix;", "", "pkg", "Lorg/jetbrains/security/package/Package;", "(Lorg/jetbrains/security/package/Package;)V", "doFix", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "fixGCompoundString", "element", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/literals/GrStringImpl;", "fixGrArgumentList", "grArgumentList", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrArgumentList;", "fixLiteral", "grLiteral", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteralContainer;", "intellij.packageChecker.gradle"})
public final class GradleGroovyVulnerablePackageFix {
    @NotNull
    private final Package pkg;

    public GradleGroovyVulnerablePackageFix(@NotNull Package pkg) {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        this.pkg = pkg;
    }

    public final void doFix(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof GrStringImpl) {
            this.fixGCompoundString((GrStringImpl)psiElement);
        } else if (psiElement2 instanceof GrArgumentList) {
            this.fixGrArgumentList((GrArgumentList)psiElement);
        } else if (psiElement2 instanceof GrLiteralContainer) {
            this.fixLiteral((GrLiteralContainer)psiElement);
        }
    }

    private final void fixGCompoundString(GrStringImpl element) {
        Package package_;
        Package $this$fixGCompoundString_u24lambda_u240 = package_ = this.pkg;
        boolean bl = false;
        GrInspectionUtil.replaceExpression((GrExpression)((GrExpression)element), (String)("\"" + $this$fixGCompoundString_u24lambda_u240.getNamespace() + ":" + $this$fixGCompoundString_u24lambda_u240.getName() + ":" + $this$fixGCompoundString_u24lambda_u240.getVersion() + "\""));
    }

    private final void fixGrArgumentList(GrArgumentList grArgumentList) {
        GrExpression grExpression;
        GrNamedArgument grNamedArgument = grArgumentList.findNamedArgument("version");
        if (grNamedArgument == null || (grExpression = grNamedArgument.getExpression()) == null) {
            return;
        }
        GrExpression versionLiteral = grExpression;
        GrInspectionUtil.replaceExpression((GrExpression)versionLiteral, (String)("'" + this.pkg.getVersion() + "'"));
    }

    private final void fixLiteral(GrLiteralContainer grLiteral) {
        GrLiteralContainer grLiteralContainer = grLiteral;
        try {
            GrLiteralContainer $this$fixLiteral_u24lambda_u241 = grLiteralContainer;
            boolean bl = false;
            Object object = grLiteral.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String patchedDependencyNotation = GradleCommonUtilsKt.patchDependencyNotation((String)object, this.pkg.getVersion().getValue());
            Object object2 = Result.constructor-impl((Object)((GrLiteralContainer)ElementManipulators.handleContentChange((PsiElement)((PsiElement)grLiteral), (String)patchedDependencyNotation)));
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }
}

