/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui.cloneDialog;

import com.intellij.collaboration.ui.util.ActionUtilKt;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManagerKt;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.ui.cloneDialog.GHRepositoryListItem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ8\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J8\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J \u0010\u0018\u001a\u00020\u00142\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListItem;", "errorHandler", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListCellRenderer$ErrorHandler;", "accountsSupplier", "Lkotlin/Function0;", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "(Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListCellRenderer$ErrorHandler;Lkotlin/jvm/functions/Function0;)V", "nameRenderer", "Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListCellRenderer$AccountNameRenderer;", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "getListCellRendererComponent", "Ljava/awt/Component;", "showAccountNameAbove", "AccountNameRenderer", "ErrorHandler", "intellij.vcs.github"})
public final class GHRepositoryListCellRenderer
extends ColoredListCellRenderer<GHRepositoryListItem> {
    @NotNull
    private final ErrorHandler errorHandler;
    @NotNull
    private final Function0<Collection<GithubAccount>> accountsSupplier;
    @NotNull
    private final AccountNameRenderer nameRenderer;

    public GHRepositoryListCellRenderer(@NotNull ErrorHandler errorHandler, @NotNull Function0<? extends Collection<GithubAccount>> accountsSupplier) {
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter(accountsSupplier, (String)"accountsSupplier");
        this.errorHandler = errorHandler;
        this.accountsSupplier = accountsSupplier;
        this.nameRenderer = new AccountNameRenderer();
    }

    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends GHRepositoryListItem> list, @NotNull GHRepositoryListItem value, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Component component2 = super.getListCellRendererComponent(list, (Object)value, index, selected, hasFocus);
        if (this.showAccountNameAbove(list, index)) {
            GHRepositoryListItem $this$getListCellRendererComponent_u24lambda_u240 = value;
            boolean bl = false;
            String name = GHAccountManagerKt.isGHAccount($this$getListCellRendererComponent_u24lambda_u240.getAccount()) ? $this$getListCellRendererComponent_u24lambda_u240.getAccount().getName() : $this$getListCellRendererComponent_u24lambda_u240.getAccount().getServer().getHost() + "/" + $this$getListCellRendererComponent_u24lambda_u240.getAccount().getName();
            Intrinsics.checkNotNull((Object)component2);
            return (Component)((Object)this.nameRenderer.withName(name, component2, index != 0));
        }
        Intrinsics.checkNotNull((Object)component2);
        return component2;
    }

    private final boolean showAccountNameAbove(JList<? extends GHRepositoryListItem> list, int index) {
        return ((Collection)this.accountsSupplier.invoke()).size() > 1 && (index == 0 || !Intrinsics.areEqual((Object)((Object)list.getModel().getElementAt(index).getAccount()), (Object)((Object)list.getModel().getElementAt(index - 1).getAccount())));
    }

    protected void customizeCellRenderer(@NotNull JList<? extends GHRepositoryListItem> list, @NotNull GHRepositoryListItem value, int index, boolean selected, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GHRepositoryListItem gHRepositoryListItem = value;
        if (gHRepositoryListItem instanceof GHRepositoryListItem.Repo) {
            GithubUser user = ((GHRepositoryListItem.Repo)value).getUser();
            GithubRepo repo = ((GHRepositoryListItem.Repo)value).getRepo();
            this.getIpad().left = 10;
            this.setToolTipText(repo.getDescription());
            this.append(Intrinsics.areEqual((Object)repo.getOwner().getLogin(), (Object)user.getLogin()) ? repo.getName() : repo.getFullName());
        } else if (gHRepositoryListItem instanceof GHRepositoryListItem.Error) {
            Throwable error = ((GHRepositoryListItem.Error)value).getError();
            this.getIpad().left = 10;
            this.setToolTipText(null);
            this.append(this.errorHandler.getPresentableText(error), SimpleTextAttributes.ERROR_ATTRIBUTES);
            Action action2 = this.errorHandler.getAction(value.getAccount(), error);
            this.append(" ");
            String string = ActionUtilKt.getName((Action)action2);
            if (string == null) {
                string = "";
            }
            this.append(string, SimpleTextAttributes.LINK_ATTRIBUTES, action2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u00002\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListCellRenderer$AccountNameRenderer;", "Lcom/intellij/ui/CellRendererPanel;", "()V", "borderLayout", "Ljava/awt/BorderLayout;", "titleLabel", "Lcom/intellij/ui/SimpleColoredComponent;", "topLine", "Ljavax/swing/border/Border;", "Lorg/jetbrains/annotations/NotNull;", "withName", "title", "", "itemContent", "Ljava/awt/Component;", "withBorder", "", "intellij.vcs.github"})
    private static final class AccountNameRenderer
    extends CellRendererPanel {
        @NotNull
        private final SimpleColoredComponent titleLabel;
        @NotNull
        private final Border topLine;
        @NotNull
        private final BorderLayout borderLayout;

        /*
         * WARNING - void declaration
         */
        public AccountNameRenderer() {
            void $this$titleLabel_u24lambda_u240;
            SimpleColoredComponent simpleColoredComponent;
            SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent = new SimpleColoredComponent();
            AccountNameRenderer accountNameRenderer = this;
            boolean bl = false;
            $this$titleLabel_u24lambda_u240.setBackground(UIUtil.getListBackground());
            accountNameRenderer.titleLabel = simpleColoredComponent;
            Border border = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.BigPopup.listSeparatorColor(), (int)1, (int)0, (int)0, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLine(...)");
            this.topLine = border;
            this.borderLayout = new BorderLayout();
            this.setLayout(this.borderLayout);
            this.add((Component)this.titleLabel, "North");
            this.setBackground(UIUtil.getListBackground());
        }

        @NotNull
        public final AccountNameRenderer withName(@NlsSafe @NotNull String title, @NotNull Component itemContent, boolean withBorder) {
            Component prevContent;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)itemContent, (String)"itemContent");
            this.titleLabel.setBorder(null);
            this.titleLabel.clear();
            this.titleLabel.append(title, SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
            if (withBorder) {
                this.titleLabel.setBorder(this.topLine);
            }
            if ((prevContent = this.borderLayout.getLayoutComponent("Center")) != null) {
                this.remove(prevContent);
            }
            this.add(itemContent, "Center");
            return this;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/github/ui/cloneDialog/GHRepositoryListCellRenderer$ErrorHandler;", "", "getAction", "Ljavax/swing/Action;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "error", "", "getPresentableText", "", "Lorg/jetbrains/annotations/Nls;", "intellij.vcs.github"})
    public static interface ErrorHandler {
        @NotNull
        public String getPresentableText(@NotNull Throwable var1);

        @NotNull
        public Action getAction(@NotNull GithubAccount var1, @NotNull Throwable var2);
    }
}

