/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.LabelPainter;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.ui.details.BranchTooltipDescriptor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRBranchesTooltip;", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "descriptors", "", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/BranchTooltipDescriptor;", "(Ljava/util/List;)V", "createIcon", "Ljavax/swing/Icon;", "descriptor", "height", "", "createLabel", "Lcom/intellij/ui/components/JBLabel;", "text", "", "icon", "getIconHeight", "getLabelsFont", "Ljava/awt/Font;", "update", "", "intellij.vcs.github"})
public final class GHPRBranchesTooltip
extends NonOpaquePanel {
    @NotNull
    private final List<BranchTooltipDescriptor> descriptors;

    public GHPRBranchesTooltip(@NotNull List<BranchTooltipDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        super((LayoutManager)new VerticalStackLayout());
        this.descriptors = descriptors;
        this.update();
    }

    public /* synthetic */ GHPRBranchesTooltip(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    public final void update() {
        this.removeAll();
        int height = this.getIconHeight();
        for (BranchTooltipDescriptor descriptor : this.descriptors) {
            Icon icon = this.createIcon(descriptor, height);
            String text = descriptor.getName();
            JBLabel label = this.createLabel(text, icon);
            this.add((Component)label);
        }
        this.setVisible(!((Collection)this.descriptors).isEmpty());
        this.revalidate();
        this.repaint();
    }

    private final int getIconHeight() {
        return this.getFontMetrics(this.getLabelsFont()).getHeight();
    }

    private final Font getLabelsFont() {
        Font font = LabelPainter.getReferenceFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getReferenceFont(...)");
        return font;
    }

    private final Icon createIcon(BranchTooltipDescriptor descriptor, int height) {
        return (Icon)new LabelIcon((JComponent)((Object)this), height, this.getBackground(), CollectionsKt.listOf((Object)descriptor.getColor()));
    }

    private final JBLabel createLabel(@Nls String text, Icon icon) {
        JBLabel label = new JBLabel(text, icon, 2);
        label.setFont(this.getLabelsFont());
        label.setIconTextGap(JBUIScale.scale((int)4));
        label.setVerticalTextPosition(0);
        return label;
    }

    public GHPRBranchesTooltip() {
        this(null, 1, null);
    }
}

