/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.dsl.builder.Panel;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.MainCoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.ui.GHCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHOAuthCredentialsUi;
import org.jetbrains.plugins.github.authentication.ui.GHTokenCredentialsUi;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012:\u0010\u0006\u001a6\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\u0007j\u0002`\u000f\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0*H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\u0012H\u0002J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020&0/J\b\u00100\u001a\u0004\u0018\u000101J\u0006\u00102\u001a\u00020\fJ\u0010\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u000eH\u0002J\u0010\u00105\u001a\u00020\u00162\b\u00106\u001a\u0004\u0018\u000107J\u0018\u00108\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u00109\u001a\u00020\u000eJ\u0006\u0010:\u001a\u00020\u0016J\u0016\u0010;\u001a\u00020\u00162\u0006\u0010<\u001a\u00020\b2\u0006\u00109\u001a\u00020\u000eJ\u0006\u0010=\u001a\u00020\u0016J\u0012\u0010>\u001a\u0004\u0018\u00010&2\u0006\u0010?\u001a\u00020@H\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000RF\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u00172\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u00178F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginPanel;", "Lcom/intellij/ui/components/panels/Wrapper;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "login", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "(Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lkotlin/jvm/functions/Function2;)V", "currentUi", "Lorg/jetbrains/plugins/github/authentication/ui/GHCredentialsUi;", "value", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/builder/Panel;", "", "Lkotlin/ExtensionFunctionType;", "footer", "getFooter", "()Lkotlin/jvm/functions/Function1;", "setFooter", "(Lkotlin/jvm/functions/Function1;)V", "oauthUi", "Lorg/jetbrains/plugins/github/authentication/ui/GHOAuthCredentialsUi;", "progressExtension", "Lcom/intellij/ui/components/fields/ExtendableTextComponent$Extension;", "progressIcon", "Lcom/intellij/ui/AnimatedIcon$Default;", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "tokenAcquisitionError", "Lcom/intellij/openapi/ui/ValidationInfo;", "tokenUi", "Lorg/jetbrains/plugins/github/authentication/ui/GHTokenCredentialsUi;", "acquireLoginAndToken", "Lkotlin/Pair;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyUi", "ui", "doValidateAll", "", "getPreferredFocusableComponent", "Ljavax/swing/JComponent;", "getServer", "setBusy", "busy", "setError", "exception", "", "setLogin", "editable", "setOAuthUi", "setServer", "path", "setTokenUi", "validateServerPath", "field", "Ljavax/swing/JTextField;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubLoginPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubLoginPanel.kt\norg/jetbrains/plugins/github/authentication/ui/GithubLoginPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class GithubLoginPanel
extends Wrapper {
    @NotNull
    private final ExtendableTextField serverTextField;
    @Nullable
    private ValidationInfo tokenAcquisitionError;
    private GHCredentialsUi currentUi;
    @NotNull
    private GHTokenCredentialsUi tokenUi;
    @NotNull
    private GHOAuthCredentialsUi oauthUi;
    @NotNull
    private final AnimatedIcon.Default progressIcon;
    @NotNull
    private final ExtendableTextComponent.Extension progressExtension;

    public GithubLoginPanel(@NotNull CoroutineScope cs, @NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkNotNullParameter(isAccountUnique, (String)"isAccountUnique");
        this.serverTextField = new ExtendableTextField("github.com", 0);
        this.tokenUi = new GHTokenCredentialsUi(cs, this.serverTextField, executorFactory, isAccountUnique);
        this.oauthUi = new GHOAuthCredentialsUi(cs, executorFactory, isAccountUnique);
        this.progressIcon = new AnimatedIcon.Default();
        this.progressExtension = arg_0 -> GithubLoginPanel.progressExtension$lambda$0(this, arg_0);
        this.applyUi(this.tokenUi);
    }

    @NotNull
    public final Function1<Panel, Unit> getFooter() {
        return this.tokenUi.getFooter();
    }

    public final void setFooter(@NotNull Function1<? super Panel, Unit> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.tokenUi.setFooter(value);
        this.oauthUi.setFooter(value);
        GHCredentialsUi gHCredentialsUi = this.currentUi;
        if (gHCredentialsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
            gHCredentialsUi = null;
        }
        this.applyUi(gHCredentialsUi);
    }

    private final void applyUi(GHCredentialsUi ui) {
        this.currentUi = ui;
        GHCredentialsUi gHCredentialsUi = this.currentUi;
        if (gHCredentialsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
            gHCredentialsUi = null;
        }
        this.setContent(gHCredentialsUi.getPanel());
        GHCredentialsUi gHCredentialsUi2 = this.currentUi;
        if (gHCredentialsUi2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
            gHCredentialsUi2 = null;
        }
        JComponent jComponent = gHCredentialsUi2.getPreferredFocusableComponent();
        if (jComponent != null) {
            jComponent.requestFocus();
        }
        this.tokenAcquisitionError = null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final JComponent getPreferredFocusableComponent() {
        it = var1_1 = this.serverTextField;
        $i$a$-takeIf-GithubLoginPanel$getPreferredFocusableComponent$1 = false;
        if (!it.isEditable()) ** GOTO lbl-1000
        v0 = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)v0)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        v2 /* !! */  = v1 != false ? var1_1 : null;
        if (v2 /* !! */  != null) {
            v3 = (JComponent)v2 /* !! */ ;
        } else {
            v4 = this.currentUi;
            if (v4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
                v4 = null;
            }
            v3 = v4.getPreferredFocusableComponent();
        }
        return v3;
    }

    @NotNull
    public final List<ValidationInfo> doValidateAll() {
        JTextField jTextField = (JTextField)this.serverTextField;
        String string = GithubBundle.message("credentials.server.cannot.be.empty", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ValidationInfo validationInfo = DialogValidationUtils.INSTANCE.notBlank(jTextField, string);
        if (validationInfo == null && (validationInfo = this.validateServerPath((JTextField)this.serverTextField)) == null) {
            GHCredentialsUi gHCredentialsUi = this.currentUi;
            if (gHCredentialsUi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
                gHCredentialsUi = null;
            }
            validationInfo = (ValidationInfo)gHCredentialsUi.getValidator().invoke();
        }
        ValidationInfo uiError = validationInfo;
        Object[] objectArray = new ValidationInfo[]{uiError, this.tokenAcquisitionError};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private final ValidationInfo validateServerPath(JTextField field) {
        ValidationInfo validationInfo;
        try {
            GithubServerPath.from(field.getText());
            validationInfo = null;
        }
        catch (Exception e) {
            validationInfo = new ValidationInfo(GithubBundle.message("credentials.server.path.invalid", new Object[0]), (JComponent)field);
        }
        return validationInfo;
    }

    private final void setBusy(boolean busy) {
        ExtendableTextField extendableTextField;
        ExtendableTextField $this$setBusy_u24lambda_u242 = extendableTextField = this.serverTextField;
        boolean bl = false;
        if (busy) {
            $this$setBusy_u24lambda_u242.addExtension(this.progressExtension);
        } else {
            $this$setBusy_u24lambda_u242.removeExtension(this.progressExtension);
        }
        this.serverTextField.setEnabled(!busy);
        GHCredentialsUi gHCredentialsUi = this.currentUi;
        if (gHCredentialsUi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
            gHCredentialsUi = null;
        }
        gHCredentialsUi.setBusy(busy);
    }

    @Nullable
    public final Object acquireLoginAndToken(@NotNull Continuation<? super Pair<String, String>> $completion) {
        MainCoroutineDispatcher mainCoroutineDispatcher = Dispatchers.getMain().getImmediate();
        ModalityState modalityState = ModalityState.stateForComponent((Component)((Component)((Object)this)));
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        return BuildersKt.withContext((CoroutineContext)mainCoroutineDispatcher.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends String, ? extends String>>, Object>(this, null){
            int label;
            final /* synthetic */ GithubLoginPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        GithubLoginPanel.access$setBusy(this.this$0, true);
                        GithubLoginPanel.access$setTokenAcquisitionError$p(this.this$0, null);
                        v0 = GithubLoginPanel.access$getCurrentUi$p(this.this$0);
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
                            v0 = null;
                        }
                        this.label = 1;
                        v1 = v0.login(this.this$0.getServer(), (Continuation<? super Pair<String, String>>)((Continuation)this));
                        ** if (v1 != var4_2) goto lbl17
lbl16:
                        // 1 sources

                        return var4_2;
lbl17:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            var2_3 = (Pair)v1;
                            ** GOTO lbl35
                        }
                        catch (CancellationException ce) {
                            throw ce;
                        }
                        catch (Exception e) {
                            this.this$0.setError(e);
                            throw e;
                        }
                    }
                    catch (Throwable var3_6) {
                        throw var3_6;
                    }
                    {
                        finally {
                            GithubLoginPanel.access$setBusy(this.this$0, false);
                        }
lbl35:
                        // 1 sources

                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Pair<String, String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final GithubServerPath getServer() {
        String string = this.serverTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        GithubServerPath githubServerPath = GithubServerPath.from(((Object)StringsKt.trim((CharSequence)string)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"from(...)");
        return githubServerPath;
    }

    public final void setServer(@NotNull String path, boolean editable) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.serverTextField.setText(path);
        this.serverTextField.setEditable(editable);
    }

    public final void setLogin(@Nullable String login2, boolean editable) {
        this.tokenUi.setFixedLogin(editable ? null : login2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setError(@Nullable Throwable exception) {
        ValidationInfo validationInfo;
        GithubLoginPanel githubLoginPanel = this;
        Throwable throwable = exception;
        if (throwable != null) {
            void it;
            Throwable throwable2 = throwable;
            GithubLoginPanel githubLoginPanel2 = githubLoginPanel;
            boolean bl = false;
            GHCredentialsUi gHCredentialsUi = this.currentUi;
            if (gHCredentialsUi == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
                gHCredentialsUi = null;
            }
            validationInfo = gHCredentialsUi.handleAcquireError((Throwable)it);
            githubLoginPanel = githubLoginPanel2;
        } else {
            validationInfo = null;
        }
        githubLoginPanel.tokenAcquisitionError = validationInfo;
    }

    public final void setOAuthUi() {
        this.applyUi(this.oauthUi);
    }

    public final void setTokenUi() {
        this.applyUi(this.tokenUi);
    }

    private static final Icon progressExtension$lambda$0(GithubLoginPanel this$0, boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return (Icon)this$0.progressIcon;
    }

    public static final /* synthetic */ void access$setBusy(GithubLoginPanel $this, boolean busy) {
        $this.setBusy(busy);
    }

    public static final /* synthetic */ void access$setTokenAcquisitionError$p(GithubLoginPanel $this, ValidationInfo validationInfo) {
        $this.tokenAcquisitionError = validationInfo;
    }

    public static final /* synthetic */ GHCredentialsUi access$getCurrentUi$p(GithubLoginPanel $this) {
        return $this.currentUi;
    }
}

