/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.sarif;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.sarif.CodeInspectionProblemReader;
import org.jetbrains.qodana.sarif.NonUniqueProblemReporter;
import org.jetbrains.teamcity.qodana.model.version3.Problem;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/sarif/ProblemTransformer;", "", "gson", "Lcom/google/gson/Gson;", "(Lcom/google/gson/Gson;)V", "getCoreReportSimpleProblems", "", "Lorg/jetbrains/teamcity/qodana/model/version3/Problem;", "input", "Ljava/io/File;", "transformAndWriteProblemsV3", "output", "writeProblemsV3", "", "problems", "PathSerializer", "sarif-converter"})
@SourceDebugExtension(value={"SMAP\nProblemTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProblemTransformer.kt\norg/jetbrains/qodana/sarif/ProblemTransformer\n+ 2 json.kt\norg/jetbrains/qodana/sarif/json/JsonKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n8#2:61\n9#2:62\n1855#3,2:63\n*S KotlinDebug\n*F\n+ 1 ProblemTransformer.kt\norg/jetbrains/qodana/sarif/ProblemTransformer\n*L\n19#1:61\n39#1:62\n44#1:63,2\n*E\n"})
public final class ProblemTransformer {
    @NotNull
    private final Gson gson;

    public ProblemTransformer(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.gson = gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Problem> getCoreReportSimpleProblems(File input) {
        NonUniqueProblemReporter reporter = new NonUniqueProblemReporter();
        List problems2 = new ArrayList();
        boolean $i$f$useJsonReader = false;
        Closeable closeable = (Closeable)new JsonReader((Reader)new BufferedReader(new FileReader(input, StandardCharsets.UTF_8)));
        Throwable throwable = null;
        try {
            JsonReader reader = (JsonReader)closeable;
            boolean bl = false;
            reader.beginArray();
            while (reader.peek() == JsonToken.BEGIN_OBJECT) {
                Problem problem = CodeInspectionProblemReader.INSTANCE.read(reader);
                reporter.checkIfDuplicate(problem.getHash());
                problems2.add(problem);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        reporter.reportDuplicates();
        return problems2;
    }

    @NotNull
    public final List<Problem> transformAndWriteProblemsV3(@NotNull File input, @NotNull File output2) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
        List<Problem> problemsV3 = this.getCoreReportSimpleProblems(input);
        this.writeProblemsV3(problemsV3, output2);
        return problemsV3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeProblemsV3(List<Problem> problems2, File output2) {
        boolean $i$f$useJsonWriter = false;
        Closeable closeable = (Closeable)new JsonWriter((Writer)new BufferedWriter(new FileWriter(output2, StandardCharsets.UTF_8)));
        Throwable throwable = null;
        try {
            JsonWriter writer = (JsonWriter)closeable;
            boolean bl = false;
            writer.beginObject();
            writer.name("version").value("3");
            writer.name("listProblem");
            writer.beginArray();
            Iterable $this$forEach$iv = problems2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Problem problemV3 = (Problem)element$iv;
                boolean bl2 = false;
                writer.jsonValue(this.gson.toJson((Object)problemV3));
            }
            JsonWriter jsonWriter = writer.endArray().endObject();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/sarif/ProblemTransformer$PathSerializer;", "Lcom/google/gson/JsonDeserializer;", "Ljava/nio/file/Path;", "Lcom/google/gson/JsonSerializer;", "()V", "deserialize", "jsonElement", "Lcom/google/gson/JsonElement;", "type", "Ljava/lang/reflect/Type;", "jsonDeserializationContext", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "path", "jsonSerializationContext", "Lcom/google/gson/JsonSerializationContext;", "sarif-converter"})
    public static final class PathSerializer
    implements JsonDeserializer<Path>,
    JsonSerializer<Path> {
        @NotNull
        public Path deserialize(@NotNull JsonElement jsonElement, @NotNull Type type, @NotNull JsonDeserializationContext jsonDeserializationContext) {
            Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"jsonElement");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)jsonDeserializationContext, (String)"jsonDeserializationContext");
            Path path = Paths.get(jsonElement.getAsString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(jsonElement.asString)");
            return path;
        }

        @NotNull
        public JsonElement serialize(@NotNull Path path, @NotNull Type type, @NotNull JsonSerializationContext jsonSerializationContext) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)jsonSerializationContext, (String)"jsonSerializationContext");
            return (JsonElement)new JsonPrimitive(((Object)path).toString());
        }
    }
}

