/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.cloud;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J'\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\b\b\u0001\u0010\u0013*\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/qodana/cloud/StateManager;", "T", "", "initialStateProvider", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)V", "_exitedState", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "exitedState", "Lkotlinx/coroutines/flow/SharedFlow;", "getExitedState", "()Lkotlinx/coroutines/flow/SharedFlow;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "changeState", "S", "oldState", "newState", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "intellij.qodana"})
public final class StateManager<T> {
    @NotNull
    private final MutableStateFlow<T> _state;
    @NotNull
    private final StateFlow<T> state;
    @NotNull
    private final MutableSharedFlow<T> _exitedState;
    @NotNull
    private final SharedFlow<T> exitedState;

    public StateManager(@NotNull Function1<? super StateManager<T>, ? extends T> initialStateProvider) {
        Intrinsics.checkNotNullParameter(initialStateProvider, (String)"initialStateProvider");
        this._state = StateFlowKt.MutableStateFlow((Object)initialStateProvider.invoke((Object)this));
        this.state = FlowKt.asStateFlow(this._state);
        this._exitedState = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        this.exitedState = FlowKt.asSharedFlow(this._exitedState);
    }

    @NotNull
    public final StateFlow<T> getState() {
        return this.state;
    }

    @NotNull
    public final SharedFlow<T> getExitedState() {
        return this.exitedState;
    }

    @Nullable
    public final <S extends T> S changeState(T oldState, S newState) {
        boolean successFullyUpdatedState = this._state.compareAndSet(oldState, newState);
        if (!successFullyUpdatedState) {
            return null;
        }
        this._exitedState.tryEmit(oldState);
        return newState;
    }
}

