/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.model;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.toolwindow.ReviewTabViewModel;
import com.intellij.openapi.project.Project;
import com.intellij.util.CoroutineScopeKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.GitLabProjectsManager;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabProject;
import org.jetbrains.plugins.gitlab.mergerequest.ui.create.model.GitLabMergeRequestCreateViewModelImpl;
import org.jetbrains.plugins.gitlab.mergerequest.ui.details.model.GitLabMergeRequestDetailsLoadingViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.details.model.GitLabMergeRequestDetailsLoadingViewModelImpl;
import org.jetbrains.plugins.gitlab.mergerequest.ui.details.model.GitLabMergeRequestDetailsViewModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;
import org.jetbrains.plugins.gitlab.util.GitLabProjectPath;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0002\u0005\u0006J\u0011\u0010\u0002\u001a\u00020\u0003H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0002\u0007\b\u00f8\u0001\u0001\u0082\u0002\n\n\u0002\b\u0019\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel;", "Lcom/intellij/collaboration/ui/toolwindow/ReviewTabViewModel;", "destroy", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "CreateMergeRequest", "Details", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel$CreateMergeRequest;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel$Details;", "intellij.vcs.gitlab"})
public interface GitLabReviewTabViewModel
extends ReviewTabViewModel {
    @Nullable
    public Object destroy(@NotNull Continuation<? super Unit> var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00121\u0010\r\u001a-\b\u0001\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0011\u0010 \u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel$CreateMergeRequest;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "projectsManager", "Lorg/jetbrains/plugins/gitlab/GitLabProjectsManager;", "projectData", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabProject;", "avatarIconProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "openReviewTabAction", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "mrIid", "Lkotlin/coroutines/Continuation;", "", "", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/gitlab/GitLabProjectsManager;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabProject;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lkotlin/jvm/functions/Function2;)V", "createVm", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/create/model/GitLabMergeRequestCreateViewModelImpl;", "getCreateVm", "()Lorg/jetbrains/plugins/gitlab/mergerequest/ui/create/model/GitLabMergeRequestCreateViewModelImpl;", "cs", "displayName", "getDisplayName", "()Ljava/lang/String;", "projectPath", "destroy", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.gitlab"})
    public static final class CreateMergeRequest
    implements GitLabReviewTabViewModel {
        @NotNull
        private final CoroutineScope cs;
        @NotNull
        private final String projectPath;
        @NotNull
        private final String displayName;
        @NotNull
        private final GitLabMergeRequestCreateViewModelImpl createVm;

        public CreateMergeRequest(@NotNull Project project, @NotNull CoroutineScope parentCs, @NotNull GitLabProjectsManager projectsManager, @NotNull GitLabProject projectData, @NotNull IconsProvider<GitLabUserDTO> avatarIconProvider, @NotNull Function2<? super String, ? super Continuation<? super Unit>, ? extends Object> openReviewTabAction) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
            Intrinsics.checkNotNullParameter((Object)projectsManager, (String)"projectsManager");
            Intrinsics.checkNotNullParameter((Object)projectData, (String)"projectData");
            Intrinsics.checkNotNullParameter(avatarIconProvider, (String)"avatarIconProvider");
            Intrinsics.checkNotNullParameter(openReviewTabAction, (String)"openReviewTabAction");
            this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, null, (boolean)false, (int)3, null);
            this.projectPath = GitLabProjectPath.fullPath$default(projectData.getProjectMapping().getRepository().getProjectPath(), false, 1, null);
            Object[] objectArray = new Object[]{this.projectPath};
            this.displayName = GitLabBundle.message("merge.request.create.tab.title", objectArray);
            this.createVm = new GitLabMergeRequestCreateViewModelImpl(project, this.cs, projectsManager, projectData, avatarIconProvider, openReviewTabAction);
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final GitLabMergeRequestCreateViewModelImpl getCreateVm() {
            return this.createVm;
        }

        @Override
        @Nullable
        public Object destroy(@NotNull Continuation<? super Unit> $completion) {
            Object object = CoroutineUtilKt.cancelAndJoinSilently((CoroutineScope)this.cs, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B,\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel$Details;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/toolwindow/model/GitLabReviewTabViewModel;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "reviewId", "", "detailsVm", "Lkotlinx/coroutines/flow/Flow;", "Lkotlin/Result;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/details/model/GitLabMergeRequestDetailsViewModel;", "(Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;Lkotlinx/coroutines/flow/Flow;)V", "cs", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/details/model/GitLabMergeRequestDetailsLoadingViewModel;", "getDetailsVm", "()Lorg/jetbrains/plugins/gitlab/mergerequest/ui/details/model/GitLabMergeRequestDetailsLoadingViewModel;", "displayName", "Lcom/intellij/openapi/util/NlsSafe;", "getDisplayName", "()Ljava/lang/String;", "destroy", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.gitlab"})
    public static final class Details
    implements GitLabReviewTabViewModel {
        @NotNull
        private final CoroutineScope cs;
        @NotNull
        private final String displayName;
        @NotNull
        private final GitLabMergeRequestDetailsLoadingViewModel detailsVm;

        public Details(@NotNull CoroutineScope parentCs, @NotNull String reviewId, @NotNull Flow<? extends Result<? extends GitLabMergeRequestDetailsViewModel>> detailsVm2) {
            Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
            Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
            Intrinsics.checkNotNullParameter(detailsVm2, (String)"detailsVm");
            this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, null, (boolean)false, (int)3, null);
            this.displayName = "!" + reviewId;
            this.detailsVm = new GitLabMergeRequestDetailsLoadingViewModelImpl(this.cs, reviewId, detailsVm2);
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final GitLabMergeRequestDetailsLoadingViewModel getDetailsVm() {
            return this.detailsVm;
        }

        @Override
        @Nullable
        public Object destroy(@NotNull Continuation<? super Unit> $completion) {
            Object object = CoroutineUtilKt.cancelAndJoinSilently((CoroutineScope)this.cs, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }
}

